/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.xml.XmlAttributeDescriptor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class XmlDefaultAttributeValueInspection
extends XmlSuppressableInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            @Override
            public void visitXmlAttributeValue(XmlAttributeValue value) {
                String defaultValue;
                XmlAttributeDescriptor descriptor;
                PsiElement parent = value.getParent();
                if (parent instanceof XmlAttribute && (descriptor = ((XmlAttribute)parent).getDescriptor()) != null && (defaultValue = descriptor.getDefaultValue()) != null && defaultValue.equals(value.getValue())) {
                    holder.registerProblem((PsiElement)value, "Redundant default attribute value assignment", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix(){

                        @Override
                        @Nls
                        @NotNull
                        public String getFamilyName() {
                            String string = XmlErrorMessages.message("remove.attribute.quickfix.family", new Object[0]);
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection$1$1", "getFamilyName"));
                            }
                            return string;
                        }

                        @Override
                        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection$1$1", "applyFix"));
                            }
                            if (descriptor == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection$1$1", "applyFix"));
                            }
                            XmlAttribute attribute = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), XmlAttribute.class);
                            if (attribute != null) {
                                attribute.delete();
                            }
                        }
                    });
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlDefaultAttributeValueInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }
}

