/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoxForComparisonInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/BoxForComparisonInspection", "buildVisitor"));
        }
        if (!PsiUtil.getLanguageLevel(holder.getFile()).isAtLeast(LanguageLevel.JDK_1_4)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/BoxForComparisonInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                String name = nameElement.getText();
                if (!"compareTo".equals(name)) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length != 1) {
                    return;
                }
                PsiExpression arg = args[0];
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                PsiClassType boxedType = BoxForComparisonInspection.getBoxedType(call);
                if (boxedType == null) {
                    return;
                }
                PsiPrimitiveType primitiveType = PsiPrimitiveType.getUnboxedType(boxedType);
                if (primitiveType == null || !PsiType.DOUBLE.equals(primitiveType) && !PsiType.FLOAT.equals(primitiveType) && !PsiUtil.isLanguageLevel7OrHigher(call)) {
                    return;
                }
                PsiExpression left = BoxForComparisonInspection.extractPrimitive(boxedType, primitiveType, qualifier);
                if (left == null) {
                    return;
                }
                PsiExpression right = BoxForComparisonInspection.extractPrimitive(boxedType, primitiveType, arg);
                if (right == null) {
                    return;
                }
                holder.registerProblem(nameElement, "Can be replaced with '" + boxedType.getClassName() + ".compare'", new ReplaceWithPrimitiveCompareFix(boxedType.getCanonicalText()));
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/BoxForComparisonInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    static PsiClassType getBoxedType(PsiMethodCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory(call.getProject()).createType(aClass);
    }

    @Nullable
    static PsiExpression extractPrimitive(PsiClassType type, PsiPrimitiveType primitiveType, PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) == null) {
            return null;
        }
        if (primitiveType.equals(expression.getType())) {
            return expression;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (!"valueOf".equals(call.getMethodExpression().getReferenceName())) {
                return null;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null || type.resolve() != method.getContainingClass()) {
                return null;
            }
            return BoxForComparisonInspection.checkPrimitive(args[0]);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression cast = (PsiTypeCastExpression)expression;
            if (!type.equals(cast.getType())) {
                return null;
            }
            return BoxForComparisonInspection.checkPrimitive(cast.getOperand());
        }
        if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            if (!type.equals(newExpression.getType())) {
                return null;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1) {
                return null;
            }
            if (!(args[0].getType() instanceof PsiPrimitiveType)) {
                return null;
            }
            return BoxForComparisonInspection.checkPrimitive(args[0]);
        }
        return null;
    }

    private static PsiExpression checkPrimitive(PsiExpression expression) {
        return expression != null && expression.getType() instanceof PsiPrimitiveType ? expression : null;
    }

    private static class ReplaceWithPrimitiveCompareFix
    implements LocalQuickFix {
        private String myClassName;

        public ReplaceWithPrimitiveCompareFix(String className) {
            this.myClassName = className;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with '" + StringUtil.getShortName(this.myClassName) + ".compare'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/BoxForComparisonInspection$ReplaceWithPrimitiveCompareFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with static 'compare' method" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/BoxForComparisonInspection$ReplaceWithPrimitiveCompareFix", "getFamilyName"));
            }
            return "Replace with static 'compare' method";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/BoxForComparisonInspection$ReplaceWithPrimitiveCompareFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/BoxForComparisonInspection$ReplaceWithPrimitiveCompareFix", "applyFix"));
            }
            PsiMethodCallExpression call = PsiTreeUtil.getParentOfType(descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiClassType boxedType = BoxForComparisonInspection.getBoxedType(call);
            if (boxedType == null) {
                return;
            }
            PsiPrimitiveType primitiveType = PsiPrimitiveType.getUnboxedType(boxedType);
            if (primitiveType == null) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression left = BoxForComparisonInspection.extractPrimitive(boxedType, primitiveType, qualifier);
            if (left == null) {
                return;
            }
            PsiExpression right = BoxForComparisonInspection.extractPrimitive(boxedType, primitiveType, args[0]);
            if (right == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)call, boxedType.getCanonicalText() + ".compare(" + ct.text(left) + "," + ct.text(right) + ")");
        }
    }
}

