/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.Bytes;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.HComponent;
import com.intellij.codeInspection.bytecodeAnalysis.HEffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HEffects;
import com.intellij.codeInspection.bytecodeAnalysis.HEquations;
import com.intellij.codeInspection.bytecodeAnalysis.HFinal;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HPending;
import com.intellij.codeInspection.bytecodeAnalysis.HResult;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.KeyedMethodVisitor;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class BytecodeAnalysisIndex
extends ScalarIndexExtension<Bytes> {
    private static final ID<Bytes, Void> NAME = ID.create("bytecodeAnalysis");
    private static final HKeyDescriptor KEY_DESCRIPTOR = new HKeyDescriptor();
    private static final VirtualFileGist<Map<Bytes, HEquations>> ourGist = GistManager.getInstance().newVirtualFileGist("BytecodeAnalysisIndex", 5, new HEquationsExternalizer(), new ClassDataIndexer());

    @Override
    @NotNull
    public ID<Bytes, Void> getName() {
        ID<Bytes, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getName"));
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<Bytes, Void, FileContent> getIndexer() {
        DataIndexer<Bytes, Void, FileContent> dataIndexer = inputData -> {
            try {
                return BytecodeAnalysisIndex.collectKeys(inputData.getContent());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
                return Collections.emptyMap();
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    private static Map<Bytes, Void> collectKeys(byte[] content) throws NoSuchAlgorithmException {
        final HashMap<Bytes, Void> map = new HashMap<Bytes, Void>();
        final MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
        new ClassReader(content).accept((ClassVisitor)new KeyedMethodVisitor(){

            @Override
            @Nullable
            MethodVisitor visitMethod(MethodNode node, Key key) {
                map.put(ClassDataIndexer.compressKey(md, key), null);
                return null;
            }
        }, 6);
        HashMap<Bytes, Void> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "collectKeys"));
        }
        return hashMap;
    }

    @Override
    @NotNull
    public KeyDescriptor<Bytes> getKeyDescriptor() {
        HKeyDescriptor hKeyDescriptor = KEY_DESCRIPTOR;
        if (hKeyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getKeyDescriptor"));
        }
        return hKeyDescriptor;
    }

    @Override
    public boolean hasSnapshotMapping() {
        return true;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(JavaClassFileType.INSTANCE);
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return 10;
    }

    @NotNull
    static List<HEquations> getEquations(GlobalSearchScope scope, Bytes key) {
        Project project = ProjectManager.getInstance().getDefaultProject();
        List<HEquations> list = ContainerUtil.mapNotNull(FileBasedIndex.getInstance().getContainingFiles(NAME, key, scope), file -> ourGist.getFileData(project, (VirtualFile)file).get(key));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getEquations"));
        }
        return list;
    }

    public static class HEquationsExternalizer
    implements DataExternalizer<Map<Bytes, HEquations>> {
        @Override
        public void save(@NotNull DataOutput out, Map<Bytes, HEquations> value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "save"));
            }
            DataInputOutputUtilRt.writeSeq(out, value.entrySet(), entry -> {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "lambda$save$0"));
                }
                KEY_DESCRIPTOR.save(out, (Bytes)entry.getKey());
                HEquationsExternalizer.saveEquations(out, (HEquations)entry.getValue());
            });
        }

        @Override
        public Map<Bytes, HEquations> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "read"));
            }
            return DataInputOutputUtilRt.readSeq(in, () -> {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "lambda$read$1"));
                }
                return Pair.create(KEY_DESCRIPTOR.read(in), HEquationsExternalizer.readEquations(in));
            }).stream().collect(Collectors.toMap(p -> (Bytes)p.getFirst(), p -> (HEquations)p.getSecond()));
        }

        private static void saveEquations(@NotNull DataOutput out, HEquations eqs) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "saveEquations"));
            }
            out.writeBoolean(eqs.stable);
            DataInputOutputUtil.writeINT(out, eqs.results.size());
            for (DirectionResultPair pair : eqs.results) {
                DataInputOutputUtil.writeINT(out, pair.directionKey);
                HResult rhs = pair.hResult;
                if (rhs instanceof HFinal) {
                    HFinal finalResult = (HFinal)rhs;
                    out.writeBoolean(true);
                    DataInputOutputUtil.writeINT(out, finalResult.value.ordinal());
                    continue;
                }
                if (rhs instanceof HPending) {
                    HPending pendResult = (HPending)rhs;
                    out.writeBoolean(false);
                    DataInputOutputUtil.writeINT(out, pendResult.delta.length);
                    for (HComponent component : pendResult.delta) {
                        DataInputOutputUtil.writeINT(out, component.value.ordinal());
                        HKey[] ids = component.ids;
                        DataInputOutputUtil.writeINT(out, ids.length);
                        for (HKey hKey : ids) {
                            out.write(hKey.key);
                            int rawDirKey = hKey.negated ? -hKey.dirKey : hKey.dirKey;
                            DataInputOutputUtil.writeINT(out, rawDirKey);
                            out.writeBoolean(hKey.stable);
                        }
                    }
                    continue;
                }
                if (!(rhs instanceof HEffects)) continue;
                HEffects effects = (HEffects)rhs;
                DataInputOutputUtil.writeINT(out, effects.effects.size());
                for (HEffectQuantum effect : effects.effects) {
                    if (effect == HEffectQuantum.TopEffectQuantum) {
                        DataInputOutputUtil.writeINT(out, -1);
                        continue;
                    }
                    if (effect == HEffectQuantum.ThisChangeQuantum) {
                        DataInputOutputUtil.writeINT(out, -2);
                        continue;
                    }
                    if (effect instanceof HEffectQuantum.CallQuantum) {
                        DataInputOutputUtil.writeINT(out, -3);
                        HEffectQuantum.CallQuantum callQuantum = (HEffectQuantum.CallQuantum)effect;
                        out.write(callQuantum.key.key);
                        DataInputOutputUtil.writeINT(out, callQuantum.key.dirKey);
                        out.writeBoolean(callQuantum.key.stable);
                        out.writeBoolean(callQuantum.isStatic);
                        DataInputOutputUtil.writeINT(out, callQuantum.data.length);
                        for (DataValue dataValue : callQuantum.data) {
                            if (dataValue == DataValue.ThisDataValue) {
                                DataInputOutputUtil.writeINT(out, -1);
                                continue;
                            }
                            if (dataValue == DataValue.LocalDataValue) {
                                DataInputOutputUtil.writeINT(out, -2);
                                continue;
                            }
                            if (dataValue == DataValue.OwnedDataValue) {
                                DataInputOutputUtil.writeINT(out, -3);
                                continue;
                            }
                            if (dataValue == DataValue.UnknownDataValue1) {
                                DataInputOutputUtil.writeINT(out, -4);
                                continue;
                            }
                            if (dataValue == DataValue.UnknownDataValue2) {
                                DataInputOutputUtil.writeINT(out, -5);
                                continue;
                            }
                            if (!(dataValue instanceof DataValue.ParameterDataValue)) continue;
                            DataInputOutputUtil.writeINT(out, ((DataValue.ParameterDataValue)dataValue).n);
                        }
                        continue;
                    }
                    if (!(effect instanceof HEffectQuantum.ParamChangeQuantum)) continue;
                    DataInputOutputUtil.writeINT(out, ((HEffectQuantum.ParamChangeQuantum)effect).n);
                }
            }
        }

        private static HEquations readEquations(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "readEquations"));
            }
            boolean stable = in.readBoolean();
            int size = DataInputOutputUtil.readINT(in);
            ArrayList<DirectionResultPair> results = new ArrayList<DirectionResultPair>(size);
            for (int k = 0; k < size; ++k) {
                int directionKey = DataInputOutputUtil.readINT(in);
                Direction direction = Direction.fromInt(directionKey);
                if (direction == Direction.Pure) {
                    HashSet<HEffectQuantum> effects = new HashSet<HEffectQuantum>();
                    int effectsSize = DataInputOutputUtil.readINT(in);
                    for (int i2 = 0; i2 < effectsSize; ++i2) {
                        int effectMask = DataInputOutputUtil.readINT(in);
                        if (effectMask == -1) {
                            effects.add(HEffectQuantum.TopEffectQuantum);
                            continue;
                        }
                        if (effectMask == -2) {
                            effects.add(HEffectQuantum.ThisChangeQuantum);
                            continue;
                        }
                        if (effectMask == -3) {
                            byte[] bytes = new byte[14];
                            in.readFully(bytes);
                            int rawDirKey = DataInputOutputUtil.readINT(in);
                            boolean isStable = in.readBoolean();
                            HKey key = new HKey(bytes, Math.abs(rawDirKey), isStable, false);
                            boolean isStatic = in.readBoolean();
                            int dataLength = DataInputOutputUtil.readINT(in);
                            DataValue[] data = new DataValue[dataLength];
                            for (int di = 0; di < dataLength; ++di) {
                                int dataI = DataInputOutputUtil.readINT(in);
                                data[di] = dataI == -1 ? DataValue.ThisDataValue : (dataI == -2 ? DataValue.LocalDataValue : (dataI == -3 ? DataValue.OwnedDataValue : (dataI == -4 ? DataValue.UnknownDataValue1 : (dataI == -5 ? DataValue.UnknownDataValue2 : new DataValue.ParameterDataValue(dataI)))));
                            }
                            effects.add(new HEffectQuantum.CallQuantum(key, data, isStatic));
                            continue;
                        }
                        effects.add(new HEffectQuantum.ParamChangeQuantum(effectMask));
                    }
                    results.add(new DirectionResultPair(directionKey, new HEffects(effects)));
                    continue;
                }
                boolean isFinal = in.readBoolean();
                if (isFinal) {
                    int ordinal = DataInputOutputUtil.readINT(in);
                    Value value = Value.values()[ordinal];
                    results.add(new DirectionResultPair(directionKey, new HFinal(value)));
                    continue;
                }
                int sumLength = DataInputOutputUtil.readINT(in);
                HComponent[] components = new HComponent[sumLength];
                for (int i3 = 0; i3 < sumLength; ++i3) {
                    int ordinal = DataInputOutputUtil.readINT(in);
                    Value value = Value.values()[ordinal];
                    int componentSize = DataInputOutputUtil.readINT(in);
                    HKey[] ids = new HKey[componentSize];
                    for (int j = 0; j < componentSize; ++j) {
                        byte[] bytes = new byte[14];
                        in.readFully(bytes);
                        int rawDirKey = DataInputOutputUtil.readINT(in);
                        ids[j] = new HKey(bytes, Math.abs(rawDirKey), in.readBoolean(), rawDirKey < 0);
                    }
                    components[i3] = new HComponent(value, ids);
                }
                results.add(new DirectionResultPair(directionKey, new HPending(components)));
            }
            return new HEquations(results, stable);
        }
    }

    private static class HKeyDescriptor
    implements KeyDescriptor<Bytes>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private HKeyDescriptor() {
        }

        @Override
        public void save(@NotNull DataOutput out, Bytes value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor", "save"));
            }
            out.write(value.bytes);
        }

        @Override
        public Bytes read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor", "read"));
            }
            byte[] bytes = new byte[14];
            in.readFully(bytes);
            return new Bytes(bytes);
        }

        @Override
        public int getHashCode(Bytes value) {
            return Arrays.hashCode(value.bytes);
        }

        @Override
        public boolean isEqual(Bytes val1, Bytes val2) {
            return Arrays.equals(val1.bytes, val2.bytes);
        }
    }
}

