/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedData;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Product;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.util.SingletonSet;
import com.intellij.util.containers.HashSet;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

final class CombinedAnalysis {
    private final ControlFlowGraph controlFlow;
    private final Method method;
    private final CombinedInterpreter interpreter;
    private BasicValue returnValue;
    private boolean exception;
    private final MethodNode methodNode;

    CombinedAnalysis(Method method, ControlFlowGraph controlFlow) {
        this.method = method;
        this.controlFlow = controlFlow;
        this.methodNode = controlFlow.methodNode;
        this.interpreter = new CombinedInterpreter(this.methodNode.instructions, Type.getArgumentTypes((String)this.methodNode.desc).length);
    }

    final void analyze() throws AnalyzerException {
        Frame<BasicValue> frame = this.createStartFrame();
        int insnIndex = 0;
        block8: while (true) {
            AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
            switch (insnNode.getType()) {
                case 8: 
                case 14: 
                case 15: {
                    insnIndex = this.controlFlow.transitions[insnIndex][0];
                    continue block8;
                }
            }
            switch (insnNode.getOpcode()) {
                case 191: {
                    this.exception = true;
                    return;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    this.returnValue = (BasicValue)frame.pop();
                    return;
                }
                case 177: {
                    return;
                }
            }
            frame.execute(insnNode, (Interpreter)this.interpreter);
            insnIndex = this.controlFlow.transitions[insnIndex][0];
        }
    }

    final Equation notNullParamEquation(int i2, boolean stable) {
        Result result;
        Key key = new Key(this.method, new Direction.In(i2, 0), stable);
        if (this.interpreter.dereferencedParams[i2]) {
            result = new Final(Value.NotNull);
        } else {
            Set<CombinedData.ParamKey> calls = this.interpreter.parameterFlow[i2];
            if (calls == null || calls.isEmpty()) {
                result = new Final(Value.Top);
            } else {
                HashSet<Key> keys = new HashSet<Key>();
                for (CombinedData.ParamKey pk : calls) {
                    keys.add(new Key(pk.method, new Direction.In(pk.i, 0), pk.stable));
                }
                result = new Pending(new SingletonSet<Product>(new Product(Value.Top, keys)));
            }
        }
        return new Equation(key, result);
    }

    final Equation nullableParamEquation(int i2, boolean stable) {
        Result result;
        Key key = new Key(this.method, new Direction.In(i2, 1), stable);
        if (this.interpreter.dereferencedParams[i2] || this.interpreter.notNullableParams[i2] || this.returnValue instanceof AbstractValues.NthParamValue && ((AbstractValues.NthParamValue)this.returnValue).n == i2) {
            result = new Final(Value.Top);
        } else {
            Set<CombinedData.ParamKey> calls = this.interpreter.parameterFlow[i2];
            if (calls == null || calls.isEmpty()) {
                result = new Final(Value.Null);
            } else {
                HashSet<Product> sum = new HashSet<Product>();
                for (CombinedData.ParamKey pk : calls) {
                    sum.add(new Product(Value.Top, Collections.singleton(new Key(pk.method, new Direction.In(pk.i, 1), pk.stable))));
                }
                result = new Pending(sum);
            }
        }
        return new Equation(key, result);
    }

    @Nullable
    final Equation contractEquation(int i2, Value inValue, boolean stable) {
        Result result;
        Direction.InOut direction = new Direction.InOut(i2, inValue);
        Key key = new Key(this.method, direction, stable);
        if (this.exception || inValue == Value.Null && this.interpreter.dereferencedParams[i2]) {
            result = new Final(Value.Bot);
        } else if (AbstractValues.FalseValue == this.returnValue) {
            result = new Final(Value.False);
        } else if (AbstractValues.TrueValue == this.returnValue) {
            result = new Final(Value.True);
        } else if (this.returnValue instanceof CombinedData.TrackableNullValue) {
            result = new Final(Value.Null);
        } else if (this.returnValue instanceof AbstractValues.NotNullValue || CombinedData.ThisValue == this.returnValue) {
            result = new Final(Value.NotNull);
        } else if (this.returnValue instanceof AbstractValues.NthParamValue && ((AbstractValues.NthParamValue)this.returnValue).n == i2) {
            result = new Final(inValue);
        } else if (this.returnValue instanceof CombinedData.TrackableCallValue) {
            CombinedData.TrackableCallValue call = (CombinedData.TrackableCallValue)this.returnValue;
            Set<Key> keys = call.getKeysForParameter(i2, direction);
            if (ASMUtils.isReferenceType(call.getType())) {
                keys.add(new Key(call.method, Direction.Out, call.stableCall));
            }
            if (keys.isEmpty()) {
                return null;
            }
            result = new Pending(new SingletonSet<Product>(new Product(Value.Top, keys)));
        } else {
            return null;
        }
        return new Equation(key, result);
    }

    @Nullable
    final Equation failEquation(boolean stable) {
        Result result;
        Key key = new Key(this.method, Direction.Throw, stable);
        if (this.exception) {
            result = new Final(Value.Fail);
        } else if (!this.interpreter.calls.isEmpty()) {
            Set<Key> keys = this.interpreter.calls.stream().map(call -> new Key(call.method, Direction.Throw, call.stableCall)).collect(Collectors.toSet());
            result = new Pending(new SingletonSet<Product>(new Product(Value.Top, keys)));
        } else {
            return null;
        }
        return new Equation(key, result);
    }

    @Nullable
    final Equation failEquation(int i2, Value inValue, boolean stable) {
        Result result;
        Direction.InThrow direction = new Direction.InThrow(i2, inValue);
        Key key = new Key(this.method, direction, stable);
        if (this.exception) {
            result = new Final(Value.Fail);
        } else if (!this.interpreter.calls.isEmpty()) {
            HashSet<Key> keys = new HashSet<Key>();
            for (CombinedData.TrackableCallValue call : this.interpreter.calls) {
                keys.addAll(call.getKeysForParameter(i2, direction));
                keys.add(new Key(call.method, Direction.Throw, call.stableCall));
            }
            result = new Pending(new SingletonSet<Product>(new Product(Value.Top, keys)));
        } else {
            return null;
        }
        return new Equation(key, result);
    }

    @Nullable
    final Equation outContractEquation(boolean stable) {
        Result result;
        Key key = new Key(this.method, Direction.Out, stable);
        if (this.exception) {
            result = new Final(Value.Bot);
        } else if (AbstractValues.FalseValue == this.returnValue) {
            result = new Final(Value.False);
        } else if (AbstractValues.TrueValue == this.returnValue) {
            result = new Final(Value.True);
        } else if (this.returnValue instanceof CombinedData.TrackableNullValue) {
            result = new Final(Value.Null);
        } else if (this.returnValue instanceof AbstractValues.NotNullValue || this.returnValue == CombinedData.ThisValue) {
            result = new Final(Value.NotNull);
        } else if (this.returnValue instanceof CombinedData.TrackableCallValue) {
            CombinedData.TrackableCallValue call = (CombinedData.TrackableCallValue)this.returnValue;
            Key callKey = new Key(call.method, Direction.Out, call.stableCall);
            SingletonSet<Key> keys = new SingletonSet<Key>(callKey);
            result = new Pending(new SingletonSet<Product>(new Product(Value.Top, keys)));
        } else {
            return null;
        }
        return new Equation(key, result);
    }

    final Equation nullableResultEquation(boolean stable) {
        Result result;
        Key key = new Key(this.method, Direction.NullableOut, stable);
        if (this.exception || this.returnValue instanceof CombinedData.Trackable && this.interpreter.dereferencedValues[((CombinedData.Trackable)this.returnValue).getOriginInsnIndex()]) {
            result = new Final(Value.Bot);
        } else if (this.returnValue instanceof CombinedData.TrackableCallValue) {
            CombinedData.TrackableCallValue call = (CombinedData.TrackableCallValue)this.returnValue;
            Key callKey = new Key(call.method, Direction.NullableOut, call.stableCall || call.thisCall);
            SingletonSet<Key> keys = new SingletonSet<Key>(callKey);
            result = new Pending(new SingletonSet<Product>(new Product(Value.Null, keys)));
        } else {
            result = this.returnValue instanceof CombinedData.TrackableNullValue ? new Final(Value.Null) : new Final(Value.Bot);
        }
        return new Equation(key, result);
    }

    final Frame<BasicValue> createStartFrame() {
        Frame frame = new Frame(this.methodNode.maxLocals, this.methodNode.maxStack);
        Type returnType = Type.getReturnType((String)this.methodNode.desc);
        BasicValue returnValue = Type.VOID_TYPE.equals((Object)returnType) ? null : new BasicValue(returnType);
        frame.setReturn((org.jetbrains.org.objectweb.asm.tree.analysis.Value)returnValue);
        Type[] args = Type.getArgumentTypes((String)this.methodNode.desc);
        int local = 0;
        if ((this.methodNode.access & 8) == 0) {
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)CombinedData.ThisValue);
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            AbstractValues.NthParamValue value = new AbstractValues.NthParamValue(args[i2], i2);
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)value);
            if (args[i2].getSize() != 2) continue;
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)BasicValue.UNINITIALIZED_VALUE);
        }
        while (local < this.methodNode.maxLocals) {
            frame.setLocal(local++, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)BasicValue.UNINITIALIZED_VALUE);
        }
        return frame;
    }
}

