/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import java.util.Arrays;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public final class HKey {
    @NotNull
    final byte[] key;
    final int dirKey;
    final boolean stable;
    final boolean negated;

    HKey(@NotNull byte[] key, int dirKey, boolean stable, boolean negated) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/HKey", "<init>"));
        }
        this.key = key;
        this.dirKey = dirKey;
        this.stable = stable;
        this.negated = negated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HKey hKey = (HKey)o;
        if (this.dirKey != hKey.dirKey) {
            return false;
        }
        if (this.stable != hKey.stable) {
            return false;
        }
        if (this.negated != hKey.negated) {
            return false;
        }
        return Arrays.equals(this.key, hKey.key);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.key);
        result = 31 * result + this.dirKey;
        result = 31 * result + (this.stable ? 1 : 0);
        result = 31 * result + (this.negated ? 1 : 0);
        return result;
    }

    HKey invertStability() {
        return new HKey(this.key, this.dirKey, !this.stable, this.negated);
    }

    HKey mkStable() {
        return this.stable ? this : new HKey(this.key, this.dirKey, true, this.negated);
    }

    HKey mkUnstable() {
        return this.stable ? new HKey(this.key, this.dirKey, false, this.negated) : this;
    }

    public HKey mkBase() {
        return this.dirKey == 0 ? this : new HKey(this.key, 0, this.stable, false);
    }

    HKey withDirection(Direction dir) {
        return new HKey(this.key, dir.asInt(), this.stable, false);
    }

    HKey negate() {
        return new HKey(this.key, this.dirKey, this.stable, true);
    }

    public Direction getDirection() {
        return Direction.fromInt(this.dirKey);
    }

    public String toString() {
        return "HKey [" + HKey.bytesToString(this.key) + "|" + (this.stable ? "S" : "-") + (this.negated ? "N" : "-") + "|" + this.getDirection() + "]";
    }

    static String bytesToString(byte[] key) {
        return IntStreamEx.of((byte[])key).mapToObj(b -> String.format("%02x", b & 0xFF)).joining((CharSequence)".");
    }
}

