/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

final class HardCodedPurity {
    private static Set<Couple<String>> ownedFields = ContainerUtil.set(new Couple<String>("java/lang/AbstractStringBuilder", "value"));
    private static Set<Method> thisChangingMethods = ContainerUtil.set(new Method("java/lang/Throwable", "fillInStackTrace", "()Ljava/lang/Throwable;"));
    private static Set<Method> pureMethods = ContainerUtil.set(new Method("java/lang/Throwable", "toString", "()Ljava/lang/String;"), new Method("java/lang/Object", "getClass", "()Ljava/lang/Class;"), new Method("java/lang/Class", "getComponentType", "()Ljava/lang/Class;"), new Method("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;"), new Method("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;[I)Ljava/lang/Object;"), new Method("java/lang/Float", "floatToRawIntBits", "(F)I"), new Method("java/lang/Float", "intBitsToFloat", "(I)F"), new Method("java/lang/Double", "doubleToRawLongBits", "(D)J"), new Method("java/lang/Double", "longBitsToDouble", "(J)D"));
    private static Map<Method, Set<EffectQuantum>> solutions = new HashMap<Method, Set<EffectQuantum>>();
    private static Set<EffectQuantum> thisChange = Collections.singleton(EffectQuantum.ThisChangeQuantum);

    HardCodedPurity() {
    }

    static Set<EffectQuantum> getHardCodedSolution(Key key) {
        return HardCodedPurity.isThisChangingMethod(key) ? thisChange : (HardCodedPurity.isPureMethod(key) ? Collections.emptySet() : solutions.get(key.method));
    }

    static boolean isThisChangingMethod(Key key) {
        return HardCodedPurity.isBuilderChainCall(key) || thisChangingMethods.contains(key.method);
    }

    static boolean isBuilderChainCall(Key key) {
        Method method = key.method;
        return (method.internalClassName.equals("java/lang/StringBuilder") || method.internalClassName.equals("java/lang/StringBuffer")) && method.methodName.startsWith("append");
    }

    static boolean isPureMethod(Key key) {
        return key.method.methodName.equals("toString") && key.method.methodDesc.equals("()Ljava/lang/String;") || pureMethods.contains(key.method);
    }

    static boolean isOwnedField(FieldInsnNode fieldInsn) {
        return ownedFields.contains(new Couple<String>(fieldInsn.owner, fieldInsn.name));
    }

    static {
        solutions.put(new Method("java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V"), Collections.singleton(new EffectQuantum.ParamChangeQuantum(2)));
        solutions.put(new Method("java/lang/Object", "hashCode", "()I"), Collections.emptySet());
    }
}

