/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;

public final class Method {
    final String internalClassName;
    final String methodName;
    final String methodDesc;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        return this.internalClassName.equals(method.internalClassName) && this.methodDesc.equals(method.methodDesc) && this.methodName.equals(method.methodName);
    }

    public int hashCode() {
        int result = this.internalClassName.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.methodDesc.hashCode();
        return result;
    }

    public Method(String internalClassName, String methodName, String methodDesc) {
        this.internalClassName = internalClassName;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public Method(MethodInsnNode mNode) {
        this.internalClassName = mNode.owner;
        this.methodName = mNode.name;
        this.methodDesc = mNode.desc;
    }

    public String toString() {
        return this.internalClassName + ' ' + this.methodName + ' ' + this.methodDesc;
    }
}

