/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.HEffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.PurityAnalysis;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

final class PuritySolver {
    private HashMap<HKey, Set<HEffectQuantum>> solved = new HashMap();
    private HashMap<HKey, Set<HKey>> dependencies = new HashMap();
    private final Stack<HKey> moving = new Stack();
    private HashMap<HKey, Set<HEffectQuantum>> pending = new HashMap();

    PuritySolver() {
    }

    void addEquation(HKey key, Set<HEffectQuantum> effects) {
        HashSet<HKey> callKeys = new HashSet<HKey>();
        for (HEffectQuantum effect : effects) {
            if (!(effect instanceof HEffectQuantum.CallQuantum)) continue;
            callKeys.add(((HEffectQuantum.CallQuantum)effect).key);
        }
        if (callKeys.isEmpty()) {
            this.solved.put(key, effects);
            this.moving.add(key);
        } else {
            this.pending.put(key, effects);
            for (HKey callKey : callKeys) {
                Set<HKey> deps = this.dependencies.get(callKey);
                if (deps == null) {
                    deps = new HashSet<HKey>();
                    this.dependencies.put(callKey, deps);
                }
                deps.add(key);
            }
        }
    }

    public Map<HKey, Set<HEffectQuantum>> solve() {
        while (!this.moving.isEmpty()) {
            Set[] propagateEffects;
            HKey[] propagateKeys;
            HKey key = this.moving.pop();
            Set<HEffectQuantum> effects = this.solved.get(key);
            if (key.stable) {
                propagateKeys = new HKey[]{key, key.mkUnstable()};
                propagateEffects = new Set[]{effects, effects};
            } else {
                propagateKeys = new HKey[]{key.mkStable(), key};
                propagateEffects = new Set[]{effects, PurityAnalysis.topHEffect};
            }
            for (int i2 = 0; i2 < propagateKeys.length; ++i2) {
                HKey pKey = propagateKeys[i2];
                Set pEffects = propagateEffects[i2];
                Set<HKey> dKeys = this.dependencies.remove(pKey);
                if (dKeys == null) continue;
                for (HKey dKey : dKeys) {
                    Set<HEffectQuantum> dEffects = this.pending.remove(dKey);
                    if (dEffects == null) continue;
                    HashSet<HKey> callKeys = new HashSet<HKey>();
                    HashSet<HEffectQuantum> newEffects = new HashSet<HEffectQuantum>();
                    Set<HEffectQuantum> delta = null;
                    for (HEffectQuantum dEffect : dEffects) {
                        if (dEffect instanceof HEffectQuantum.CallQuantum) {
                            HEffectQuantum.CallQuantum call = (HEffectQuantum.CallQuantum)dEffect;
                            if (call.key.equals(pKey)) {
                                delta = PuritySolver.substitute(pEffects, call.data, call.isStatic);
                                newEffects.addAll(delta);
                                continue;
                            }
                            callKeys.add(call.key);
                            newEffects.add(call);
                            continue;
                        }
                        newEffects.add(dEffect);
                    }
                    if (PurityAnalysis.topHEffect.equals(delta)) {
                        this.solved.put(dKey, PurityAnalysis.topHEffect);
                        this.moving.push(dKey);
                        continue;
                    }
                    if (callKeys.isEmpty()) {
                        this.solved.put(dKey, newEffects);
                        this.moving.push(dKey);
                        continue;
                    }
                    this.pending.put(dKey, newEffects);
                }
            }
        }
        return this.solved;
    }

    private static Set<HEffectQuantum> substitute(Set<HEffectQuantum> effects, DataValue[] data, boolean isStatic) {
        if (effects.isEmpty() || PurityAnalysis.topHEffect.equals(effects)) {
            return effects;
        }
        HashSet<HEffectQuantum> newEffects = new HashSet<HEffectQuantum>(effects.size());
        int shift = isStatic ? 0 : 1;
        for (HEffectQuantum effect : effects) {
            DataValue arg = null;
            if (effect == HEffectQuantum.ThisChangeQuantum) {
                arg = data[0];
            } else if (effect instanceof HEffectQuantum.ParamChangeQuantum) {
                HEffectQuantum.ParamChangeQuantum paramChange = (HEffectQuantum.ParamChangeQuantum)effect;
                arg = data[paramChange.n + shift];
            }
            if (arg == null || arg == DataValue.LocalDataValue) continue;
            if (arg == DataValue.ThisDataValue || arg == DataValue.OwnedDataValue) {
                newEffects.add(HEffectQuantum.ThisChangeQuantum);
                continue;
            }
            if (arg instanceof DataValue.ParameterDataValue) {
                newEffects.add(new HEffectQuantum.ParamChangeQuantum(((DataValue.ParameterDataValue)arg).n));
                continue;
            }
            return PurityAnalysis.topHEffect;
        }
        return newEffects;
    }
}

