/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.codeInspection.dataFlow.value.DfaRangeValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardInstructionVisitor
extends InstructionVisitor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.StandardInstructionVisitor");
    private static final Object ANY_VALUE = new Object();
    private static final Set<String> OPTIONAL_METHOD_NAMES = ContainerUtil.set("of", "ofNullable", "fromNullable", "empty", "absent", "or", "orElse", "orElseGet", "ifPresent", "map", "flatMap", "filter", "transform");
    private static final CallMapper<LongRangeSet> KNOWN_METHOD_RANGES = new CallMapper<LongRangeSet>().register((CallMatcher)CallMatcher.instanceCall("java.time.LocalDateTime", "getHour"), LongRangeSet.range(0L, 23L)).register((CallMatcher)CallMatcher.instanceCall("java.time.LocalDateTime", "getMinute", "getSecond"), LongRangeSet.range(0L, 59L)).register((CallMatcher)CallMatcher.staticCall("java.lang.Long", "numberOfLeadingZeros", "numberOfTrailingZeros", "bitCount"), LongRangeSet.range(0L, 64L)).register((CallMatcher)CallMatcher.staticCall("java.lang.Integer", "numberOfLeadingZeros", "numberOfTrailingZeros", "bitCount"), LongRangeSet.range(0L, 32L));
    private final Set<BinopInstruction> myReachable = new THashSet();
    private final Set<BinopInstruction> myCanBeNullInInstanceof = new THashSet();
    private final MultiMap<PushInstruction, Object> myPossibleVariableValues = MultiMap.createSet();
    private final Set<PsiElement> myNotToReportReachability = new THashSet();
    private final Set<InstanceofInstruction> myUsefulInstanceofs = new THashSet();
    private final FactoryMap<MethodCallInstruction, Nullness> myReturnTypeNullability = new FactoryMap<MethodCallInstruction, Nullness>(){

        @Override
        protected Nullness create(MethodCallInstruction key) {
            PsiCall callExpression = key.getCallExpression();
            if (callExpression instanceof PsiNewExpression) {
                return Nullness.NOT_NULL;
            }
            return callExpression != null ? DfaPsiUtil.getElementNullability(key.getResultType(), callExpression.resolveMethod()) : null;
        }
    };

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaSource = memState.pop();
        DfaValue dfaDest = memState.pop();
        if (instruction.getAssignedValue() != null) {
            dfaDest = instruction.getAssignedValue();
        }
        if (dfaDest instanceof DfaVariableValue) {
            boolean forceDeclaredNullity;
            DfaVariableValue var = (DfaVariableValue)dfaDest;
            PsiModifierListOwner psi = var.getPsiVariable();
            boolean bl = forceDeclaredNullity = !(psi instanceof PsiParameter) || !(psi.getParent() instanceof PsiParameterList);
            if (forceDeclaredNullity && var.getInherentNullability() == Nullness.NOT_NULL) {
                this.checkNotNullable(memState, dfaSource, NullabilityProblem.assigningToNotNull, instruction.getRExpression());
            }
            if (!(psi instanceof PsiField) || !psi.hasModifierProperty("volatile")) {
                memState.setVarValue(var, dfaSource);
            }
            if (var.getInherentNullability() == Nullness.NULLABLE && !memState.isNotNull(dfaSource) && instruction.isVariableInitializer()) {
                DfaMemoryStateImpl stateImpl = (DfaMemoryStateImpl)memState;
                stateImpl.setVariableState(var, stateImpl.getVariableState(var).withFact(DfaFactType.CAN_BE_NULL, true));
            }
        } else if (dfaDest instanceof DfaTypeValue && ((DfaTypeValue)dfaDest).isNotNull()) {
            this.checkNotNullable(memState, dfaSource, NullabilityProblem.assigningToNotNull, instruction.getRExpression());
        }
        memState.push(dfaDest);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue retValue = memState.pop();
        this.checkNotNullable(memState, retValue, NullabilityProblem.nullableReturn, instruction.getReturn());
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitArrayAccess(ArrayAccessInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiArrayAccessExpression arrayExpression;
        DfaValue index = memState.pop();
        DfaValue array = memState.pop();
        if (!this.checkNotNullable(memState, array, NullabilityProblem.fieldAccessNPE, (arrayExpression = instruction.getExpression()).getArrayExpression())) {
            StandardInstructionVisitor.forceNotNull(runner, memState, array);
        }
        boolean alwaysOutOfBounds = false;
        if (index != DfaUnknownValue.getInstance()) {
            DfaValue indexLessThanLength;
            DfaValue dfaLength;
            DfaValueFactory factory = runner.getFactory();
            DfaValue indexNonNegative = factory.createCondition(index, DfaRelationValue.RelationType.GE, factory.getConstFactory().createFromValue(0, PsiType.INT, null));
            if (!memState.applyCondition(indexNonNegative)) {
                alwaysOutOfBounds = true;
            }
            if ((dfaLength = SpecialField.ARRAY_LENGTH.createValue(factory, array)) != null && !memState.applyCondition(indexLessThanLength = factory.createCondition(index, DfaRelationValue.RelationType.LT, dfaLength))) {
                alwaysOutOfBounds = true;
            }
        }
        this.processArrayAccess(arrayExpression, alwaysOutOfBounds);
        memState.push(instruction.getValue());
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void processArrayAccess(PsiArrayAccessExpression expression, boolean alwaysOutOfBounds) {
    }

    @Override
    public DfaInstructionState[] visitFieldReference(FieldReferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiElement parent;
        DfaValue qualifier = memState.pop();
        if (!this.checkNotNullable(memState, qualifier, NullabilityProblem.fieldAccessNPE, instruction.getElementToAssert())) {
            StandardInstructionVisitor.forceNotNull(runner, memState, qualifier);
        }
        if ((parent = instruction.getExpression().getParent()) instanceof PsiMethodReferenceExpression) {
            this.handleMethodReference(qualifier, (PsiMethodReferenceExpression)parent, runner, memState);
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private void handleMethodReference(DfaValue qualifier, PsiMethodReferenceExpression methodRef, DataFlowRunner runner, DfaMemoryState state) {
        PsiType functionalInterfaceType = methodRef.getFunctionalInterfaceType();
        if (functionalInterfaceType == null) {
            return;
        }
        PsiMethod sam2 = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (sam2 == null || PsiType.VOID.equals(sam2.getReturnType())) {
            return;
        }
        JavaResolveResult resolveResult = methodRef.advancedResolve(false);
        PsiMethod method = ObjectUtils.tryCast(resolveResult.getElement(), PsiMethod.class);
        if (method == null || !ControlFlowAnalyzer.isPure(method)) {
            return;
        }
        List<? extends MethodContract> contracts2 = ControlFlowAnalyzer.getMethodCallContracts(method, null);
        if (contracts2.isEmpty()) {
            return;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        DfaCallArguments callArguments = StandardInstructionVisitor.getMethodReferenceCallArguments(methodRef, qualifier, runner, sam2, method, substitutor);
        PsiType returnType = substitutor.substitute(method.getReturnType());
        DfaValue defaultResult = runner.getFactory().createTypeValue(returnType, DfaPsiUtil.getElementNullability(returnType, method));
        Stream<DfaValue> returnValues = StandardInstructionVisitor.possibleReturnValues(callArguments, state, contracts2, runner.getFactory(), defaultResult);
        returnValues.forEach(res -> this.processMethodReferenceResult(methodRef, contracts2, (DfaValue)res));
    }

    @NotNull
    private static DfaCallArguments getMethodReferenceCallArguments(PsiMethodReferenceExpression methodRef, DfaValue qualifier, DataFlowRunner runner, PsiMethod sam2, PsiMethod method, PsiSubstitutor substitutor) {
        PsiParameter[] samParameters = sam2.getParameterList().getParameters();
        boolean isStatic = method.hasModifierProperty("static");
        boolean instanceBound = !isStatic && !PsiMethodReferenceUtil.isStaticallyReferenced(methodRef);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        Object[] arguments = new DfaValue[parameters.length];
        Arrays.fill(arguments, DfaUnknownValue.getInstance());
        for (int i2 = 0; i2 < samParameters.length; ++i2) {
            DfaValue value = runner.getFactory().createTypeValue(substitutor.substitute(samParameters[i2].getType()), DfaPsiUtil.getFunctionalParameterNullability(methodRef, i2));
            if (i2 == 0 && !isStatic && !instanceBound) {
                qualifier = value;
                continue;
            }
            int idx = i2 - (isStatic || instanceBound ? 0 : 1);
            if (idx >= arguments.length) break;
            if (parameters[idx].getType() instanceof PsiEllipsisType) continue;
            arguments[idx] = value;
        }
        DfaCallArguments dfaCallArguments = new DfaCallArguments(qualifier, (DfaValue[])arguments);
        if (dfaCallArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodReferenceCallArguments"));
        }
        return dfaCallArguments;
    }

    private static Stream<DfaValue> possibleReturnValues(DfaCallArguments callArguments, DfaMemoryState state, List<? extends MethodContract> contracts2, DfaValueFactory factory, DfaValue defaultResult) {
        LinkedHashSet<DfaMemoryState> currentStates = ContainerUtil.newLinkedHashSet(state.createClosureState());
        LinkedHashSet<DfaMemoryState> finalStates = ContainerUtil.newLinkedHashSet();
        for (MethodContract methodContract : contracts2) {
            DfaValue result = methodContract.getDfaReturnValue(factory, defaultResult);
            currentStates = StandardInstructionVisitor.addContractResults(callArguments, methodContract, currentStates, factory, finalStates, result);
        }
        return ((StreamEx)StreamEx.of(finalStates).map(DfaMemoryState::peek).append((Stream)(currentStates.isEmpty() ? StreamEx.empty() : StreamEx.of((Object)defaultResult)))).distinct();
    }

    protected void processMethodReferenceResult(PsiMethodReferenceExpression methodRef, List<? extends MethodContract> contracts2, DfaValue res) {
    }

    @Override
    public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaValue;
        PsiExpression place = instruction.getPlace();
        if (!instruction.isReferenceWrite() && place instanceof PsiReferenceExpression && (dfaValue = instruction.getValue()) instanceof DfaVariableValue) {
            DfaConstValue constValue = memState.getConstantValue((DfaVariableValue)dfaValue);
            boolean report = constValue != null && StandardInstructionVisitor.shouldReportConstValue(constValue.getValue(), place);
            this.myPossibleVariableValues.putValue(instruction, report ? constValue : ANY_VALUE);
        }
        return super.visitPush(instruction, runner, memState);
    }

    private static boolean shouldReportConstValue(Object value, PsiElement place) {
        return value == null || value instanceof Boolean || value.equals(new Long(0L)) && StandardInstructionVisitor.isDivider(PsiUtil.skipParenthesizedExprUp(place));
    }

    private static boolean isDivider(PsiElement expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof PsiBinaryExpression) {
            return ControlFlowAnalyzer.isBinaryDivision(((PsiBinaryExpression)parent).getOperationTokenType()) && ((PsiBinaryExpression)parent).getROperand() == expr;
        }
        if (parent instanceof PsiAssignmentExpression) {
            return ControlFlowAnalyzer.isAssignmentDivision(((PsiAssignmentExpression)parent).getOperationTokenType()) && ((PsiAssignmentExpression)parent).getRExpression() == expr;
        }
        return false;
    }

    public List<Pair<PsiReferenceExpression, DfaConstValue>> getConstantReferenceValues() {
        ArrayList<Pair<PsiReferenceExpression, DfaConstValue>> result = ContainerUtil.newArrayList();
        for (PushInstruction instruction : this.myPossibleVariableValues.keySet()) {
            Object singleValue;
            Collection<Object> values = this.myPossibleVariableValues.get(instruction);
            if (values.size() != 1 || (singleValue = values.iterator().next()) == ANY_VALUE) continue;
            result.add(Pair.create((PsiReferenceExpression)instruction.getPlace(), (DfaConstValue)singleValue));
        }
        return result;
    }

    @Override
    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValueFactory factory = runner.getFactory();
        DfaValue dfaExpr = factory.createValue(instruction.getCasted());
        if (dfaExpr != null) {
            DfaTypeValue dfaType = (DfaTypeValue)factory.createTypeValue(instruction.getCastTo(), Nullness.UNKNOWN);
            DfaRelationValue dfaInstanceof = factory.getRelationFactory().createRelation(dfaExpr, DfaRelationValue.RelationType.IS, dfaType);
            if (dfaInstanceof != null && !memState.applyInstanceofOrNull(dfaInstanceof)) {
                this.onInstructionProducesCCE(instruction);
            }
        }
        if (instruction.getCastTo() instanceof PsiPrimitiveType) {
            memState.push(runner.getFactory().getBoxedFactory().createUnboxed(memState.pop()));
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
    }

    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        LinkedHashSet<DfaMemoryState> finalStates = ContainerUtil.newLinkedHashSet();
        finalStates.addAll(this.handleOptionalMethods(instruction, runner, memState));
        finalStates.addAll(this.handleKnownMethods(instruction, runner, memState));
        if (finalStates.isEmpty()) {
            DfaCallArguments callArguments = this.popCall(instruction, runner, memState, true);
            LinkedHashSet<DfaMemoryState> currentStates = ContainerUtil.newLinkedHashSet(memState);
            if (callArguments.myArguments != null) {
                for (MethodContract contract : instruction.getContracts()) {
                    DfaValue returnValue = this.getMethodResultValue(instruction, callArguments.myQualifier, runner.getFactory());
                    returnValue = contract.getDfaReturnValue(runner.getFactory(), returnValue);
                    if ((currentStates = StandardInstructionVisitor.addContractResults(callArguments, contract, currentStates, runner.getFactory(), finalStates, returnValue)).size() + finalStates.size() <= 300) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Too complex contract on " + instruction.getContext() + ", skipping contract processing");
                    }
                    finalStates.clear();
                    currentStates = ContainerUtil.newLinkedHashSet(memState);
                    break;
                }
            }
            for (DfaMemoryState state : currentStates) {
                state.push(this.getMethodResultValue(instruction, callArguments.myQualifier, runner.getFactory()));
                finalStates.add(state);
            }
        }
        DfaInstructionState[] result = new DfaInstructionState[finalStates.size()];
        int i2 = 0;
        for (DfaMemoryState state : finalStates) {
            if (instruction.shouldFlushFields()) {
                state.flushFields();
            }
            result[i2++] = new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), state);
        }
        return result;
    }

    @NotNull
    private List<DfaMemoryState> handleKnownMethods(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        List<DfaMemoryState> states;
        PsiMethodCallExpression call = ObjectUtils.tryCast(instruction.getCallExpression(), PsiMethodCallExpression.class);
        CustomMethodHandlers.CustomMethodHandler handler = CustomMethodHandlers.find(call);
        if (handler == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "handleKnownMethods"));
            }
            return list;
        }
        DfaCallArguments callArguments = this.popCall(instruction, runner, memState, false);
        List<DfaMemoryState> list = states = callArguments.myArguments == null ? Collections.emptyList() : handler.handle(callArguments, memState, runner.getFactory());
        if (states.isEmpty()) {
            memState.push(this.getMethodResultValue(instruction, callArguments.myQualifier, runner.getFactory()));
            List<DfaMemoryState> list2 = Collections.singletonList(memState);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "handleKnownMethods"));
            }
            return list2;
        }
        List<DfaMemoryState> list3 = states;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "handleKnownMethods"));
        }
        return list3;
    }

    @NotNull
    private List<DfaMemoryState> handleOptionalMethods(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiMethodCallExpression call = ObjectUtils.tryCast(instruction.getCallExpression(), PsiMethodCallExpression.class);
        if (call == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "handleOptionalMethods"));
            }
            return list;
        }
        String methodName = call.getMethodExpression().getReferenceName();
        if (methodName == null || !OPTIONAL_METHOD_NAMES.contains(methodName)) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "handleOptionalMethods"));
            }
            return list;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null || !TypeUtils.isOptional(method.getContainingClass())) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "handleOptionalMethods"));
            }
            return list;
        }
        List<DfaMemoryState> closures = runner.getStackTopClosures();
        DfaCallArguments arguments = this.popCall(instruction, runner, memState, false);
        DfaValue[] argValues = arguments.myArguments;
        DfaOptionalValue result = null;
        DfaValueFactory factory = runner.getFactory();
        switch (methodName) {
            case "of": 
            case "ofNullable": 
            case "fromNullable": {
                if (!"of".equals(methodName) && (argValues == null || argValues.length != 1 || !memState.isNotNull(argValues[0]))) break;
                result = factory.getOptionalFactory().getOptional(true);
                break;
            }
            case "empty": 
            case "absent": {
                result = factory.getOptionalFactory().getOptional(false);
                break;
            }
            case "orElse": {
                if (argValues == null || argValues.length != 1) break;
                DfaMemoryState falseState = memState.createCopy();
                DfaOptionalValue optional = factory.getOptionalFactory().getOptional(true);
                DfaValue relation = factory.createCondition(arguments.myQualifier, DfaRelationValue.RelationType.IS, optional);
                ArrayList<DfaMemoryState> states = new ArrayList<DfaMemoryState>(2);
                if (memState.applyCondition(relation)) {
                    memState.push(factory.createTypeValue(instruction.getResultType(), Nullness.NOT_NULL));
                    states.add(memState);
                }
                if (falseState.applyCondition(relation.createNegated())) {
                    falseState.push(argValues[0]);
                    states.add(falseState);
                }
                ArrayList<DfaMemoryState> arrayList = states;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "handleOptionalMethods"));
                }
                return arrayList;
            }
            case "filter": 
            case "flatMap": 
            case "ifPresent": 
            case "map": 
            case "or": 
            case "orElseGet": 
            case "transform": {
                DfaOptionalValue optional = factory.getOptionalFactory().getOptional(!methodName.startsWith("or"));
                DfaValue relation = factory.createCondition(arguments.myQualifier, DfaRelationValue.RelationType.IS, optional);
                for (DfaMemoryState closure : closures) {
                    closure.applyCondition(relation);
                }
                break;
            }
        }
        memState.push(result == null ? this.getMethodResultValue(instruction, arguments.myQualifier, factory) : result);
        List<DfaMemoryState> list = Collections.singletonList(memState);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "handleOptionalMethods"));
        }
        return list;
    }

    @NotNull
    private DfaCallArguments popCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, boolean contractOnly) {
        DfaValue[] argValues = this.popCallArguments(instruction, runner, memState, contractOnly);
        DfaValue qualifier = this.popQualifier(instruction, runner, memState);
        DfaCallArguments dfaCallArguments = new DfaCallArguments(qualifier, argValues);
        if (dfaCallArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "popCall"));
        }
        return dfaCallArguments;
    }

    @Nullable
    private DfaValue[] popCallArguments(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, boolean contractOnly) {
        DfaValue[] argValues;
        PsiExpression[] args = instruction.getArgs();
        PsiMethod method = instruction.getTargetMethod();
        boolean varargCall = instruction.isVarArgCall();
        if (method == null || contractOnly && instruction.getContracts().isEmpty()) {
            argValues = null;
        } else {
            PsiParameterList paramList = method.getParameterList();
            int paramCount = paramList.getParametersCount();
            if (paramCount == args.length || method.isVarArgs() && args.length >= paramCount - 1) {
                argValues = new DfaValue[paramCount];
                if (varargCall) {
                    argValues[paramCount - 1] = runner.getFactory().createTypeValue(paramList.getParameters()[paramCount - 1].getType(), Nullness.NOT_NULL);
                }
            } else {
                argValues = null;
            }
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            PsiExpression expr;
            Nullness requiredNullability;
            DfaValue arg = memState.pop();
            int paramIndex = args.length - i2 - 1;
            if (!(argValues == null || paramIndex >= argValues.length - 1 && varargCall)) {
                argValues[paramIndex] = arg;
            }
            if ((requiredNullability = instruction.getArgRequiredNullability(expr = args[paramIndex])) == Nullness.NOT_NULL) {
                if (this.checkNotNullable(memState, arg, NullabilityProblem.passingNullableToNotNullParameter, expr)) continue;
                StandardInstructionVisitor.forceNotNull(runner, memState, arg);
                continue;
            }
            if (instruction.updateOfNullable(memState, arg) || requiredNullability != Nullness.UNKNOWN) continue;
            this.checkNotNullable(memState, arg, NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter, expr);
        }
        return argValues;
    }

    private DfaValue popQualifier(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiElement anchor;
        DfaValue qualifier = memState.pop();
        boolean unboxing = instruction.getMethodType() == MethodCallInstruction.MethodType.UNBOXING;
        NullabilityProblem problem = unboxing ? NullabilityProblem.unboxingNullable : NullabilityProblem.callNPE;
        PsiElement psiElement = anchor = unboxing ? instruction.getContext() : instruction.getCallExpression();
        if (!this.checkNotNullable(memState, qualifier, problem, anchor)) {
            StandardInstructionVisitor.forceNotNull(runner, memState, qualifier);
        }
        return qualifier;
    }

    private static LinkedHashSet<DfaMemoryState> addContractResults(DfaCallArguments callArguments, MethodContract contract, LinkedHashSet<DfaMemoryState> states, DfaValueFactory factory, Set<DfaMemoryState> finalStates, DfaValue returnValue) {
        List<DfaValue> conditions = ContainerUtil.map(contract.getConditions(), cv -> cv.makeDfaValue(factory, callArguments));
        if (StreamEx.of(conditions).allMatch(factory.getConstFactory().getTrue()::equals)) {
            for (DfaMemoryState state : states) {
                state.push(returnValue);
                finalStates.add(state);
            }
            return new LinkedHashSet<DfaMemoryState>();
        }
        if (StreamEx.of(conditions).has((Object)factory.getConstFactory().getFalse())) {
            return states;
        }
        LinkedHashSet<DfaMemoryState> falseStates = ContainerUtil.newLinkedHashSet();
        LinkedHashSet<DfaMemoryState> trueStates = ContainerUtil.newLinkedHashSet();
        for (DfaMemoryState state : states) {
            for (DfaValue condition : conditions) {
                DfaMemoryState falseState;
                if (condition == null) {
                    condition = DfaUnknownValue.getInstance();
                }
                if ((falseState = state.createCopy()).applyContractCondition(condition.createNegated())) {
                    falseStates.add(falseState);
                }
                if (state.applyContractCondition(condition)) continue;
                state = null;
                break;
            }
            if (state == null) continue;
            trueStates.add(state);
        }
        for (DfaMemoryState state : trueStates) {
            state.push(returnValue);
            finalStates.add(state);
        }
        return falseStates;
    }

    private static void forceNotNull(DataFlowRunner runner, DfaMemoryState memState, DfaValue arg) {
        if (arg instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)arg;
            memState.setVarValue(var, runner.getFactory().createTypeValue(var.getVariableType(), Nullness.NOT_NULL));
        }
    }

    @NotNull
    private DfaValue getMethodResultValue(MethodCallInstruction instruction, @Nullable DfaValue qualifierValue, DfaValueFactory factory) {
        DfaValue precalculated = instruction.getPrecalculatedReturnValue();
        if (precalculated != null) {
            DfaValue dfaValue = precalculated;
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        PsiType type = instruction.getResultType();
        MethodCallInstruction.MethodType methodType = instruction.getMethodType();
        if (methodType == MethodCallInstruction.MethodType.UNBOXING) {
            DfaValue dfaValue = factory.getBoxedFactory().createUnboxed(qualifierValue);
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        if (methodType == MethodCallInstruction.MethodType.BOXING) {
            DfaValue boxed = factory.getBoxedFactory().createBoxed(qualifierValue);
            DfaValue dfaValue = boxed == null ? factory.createTypeValue(type, Nullness.NOT_NULL) : boxed;
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        if (methodType == MethodCallInstruction.MethodType.CAST) {
            assert (qualifierValue != null);
            if (qualifierValue instanceof DfaConstValue) {
                Object casted = TypeConversionUtil.computeCastTo(((DfaConstValue)qualifierValue).getValue(), type);
                DfaConstValue dfaConstValue = factory.getConstFactory().createFromValue(casted, type, ((DfaConstValue)qualifierValue).getConstant());
                if (dfaConstValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
                }
                return dfaConstValue;
            }
            DfaValue dfaValue = qualifierValue;
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        if (type != null && !(type instanceof PsiPrimitiveType)) {
            Nullness nullability = this.myReturnTypeNullability.get(instruction);
            if (nullability == Nullness.UNKNOWN && factory.isUnknownMembersAreNullable()) {
                nullability = Nullness.NULLABLE;
            }
            DfaValue dfaValue = factory.createTypeValue(type, nullability);
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        DfaRangeValue rangeValue = factory.getRangeFactory().create(type);
        if (rangeValue != null) {
            PsiCall call = instruction.getCallExpression();
            if (call instanceof PsiMethodCallExpression) {
                PsiMethod method;
                LongRangeSet range = KNOWN_METHOD_RANGES.mapFirst((PsiMethodCallExpression)call);
                if (range == null && (method = call.resolveMethod()) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "javax.annotation.Nonnegative", false)) {
                    range = LongRangeSet.range(0L, Long.MAX_VALUE);
                }
                if (range != null) {
                    DfaRangeValue dfaRangeValue = rangeValue.intersect(range);
                    if (dfaRangeValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
                    }
                    return dfaRangeValue;
                }
            }
            DfaRangeValue dfaRangeValue = rangeValue;
            if (dfaRangeValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaRangeValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
        }
        return dfaUnknownValue;
    }

    protected boolean checkNotNullable(DfaMemoryState state, DfaValue value, NullabilityProblem problem, PsiElement anchor) {
        boolean notNullable = state.checkNotNullable(value);
        if (notNullable && problem != NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter) {
            DfaValueFactory factory = ((DfaMemoryStateImpl)state).getFactory();
            state.applyCondition(factory.createCondition(value, DfaRelationValue.RelationType.NE, factory.getConstFactory().getNull()));
        }
        return notNullable;
    }

    @Override
    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        this.myReachable.add(instruction);
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        IElementType opSign = instruction.getOperationSign();
        DfaRelationValue.RelationType relationType = DfaRelationValue.RelationType.fromElementType(opSign);
        if (relationType != null) {
            DfaInstructionState[] states = StandardInstructionVisitor.handleConstantComparison(instruction, runner, memState, dfaRight, dfaLeft, relationType);
            if (states == null) {
                states = this.handleRelationBinop(instruction, runner, memState, dfaRight, dfaLeft, relationType);
            }
            if (states != null) {
                return states;
            }
        }
        DfaValue result = null;
        if (JavaTokenType.AND == opSign) {
            LongRangeSet left = memState.getValueFact(DfaFactType.RANGE, dfaLeft);
            LongRangeSet right = memState.getValueFact(DfaFactType.RANGE, dfaRight);
            if (left != null && right != null) {
                result = runner.getFactory().getRangeFactory().create(left.bitwiseAnd(right));
            }
        } else if (JavaTokenType.PLUS == opSign) {
            result = instruction.getNonNullStringValue(runner.getFactory());
        } else if (instruction instanceof InstanceofInstruction) {
            this.handleInstanceof((InstanceofInstruction)instruction, dfaRight, dfaLeft);
        }
        memState.push(result == null ? DfaUnknownValue.getInstance() : result);
        instruction.setTrueReachable();
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Nullable
    private DfaInstructionState[] handleRelationBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft, DfaRelationValue.RelationType relationType) {
        DfaMemoryState falseCopy;
        DfaValueFactory factory = runner.getFactory();
        Instruction next = runner.getInstruction(instruction.getIndex() + 1);
        DfaValue condition = factory.createCondition(dfaLeft, relationType, dfaRight);
        if (condition instanceof DfaUnknownValue) {
            return null;
        }
        this.myCanBeNullInInstanceof.add(instruction);
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(2);
        DfaMemoryState trueCopy = memState.createCopy();
        if (trueCopy.applyCondition(condition)) {
            trueCopy.push(factory.getConstFactory().getTrue());
            instruction.setTrueReachable();
            states.add(new DfaInstructionState(next, trueCopy));
        }
        if ((falseCopy = memState).applyCondition(condition.createNegated())) {
            falseCopy.push(factory.getConstFactory().getFalse());
            instruction.setFalseReachable();
            states.add(new DfaInstructionState(next, falseCopy));
            if (instruction instanceof InstanceofInstruction && !falseCopy.isNull(dfaLeft)) {
                this.myUsefulInstanceofs.add((InstanceofInstruction)instruction);
            }
        }
        return states.toArray(new DfaInstructionState[states.size()]);
    }

    public void skipConstantConditionReporting(@Nullable PsiElement anchor) {
        ContainerUtil.addIfNotNull(this.myNotToReportReachability, anchor);
    }

    private void handleInstanceof(InstanceofInstruction instruction, DfaValue dfaRight, DfaValue dfaLeft) {
        if (dfaLeft instanceof DfaTypeValue && dfaRight instanceof DfaTypeValue) {
            if (!((DfaTypeValue)dfaLeft).isNotNull()) {
                this.myCanBeNullInInstanceof.add(instruction);
            }
            if (((DfaTypeValue)dfaRight).getDfaType().isAssignableFrom(((DfaTypeValue)dfaLeft).getDfaType())) {
                return;
            }
        }
        this.myUsefulInstanceofs.add(instruction);
    }

    @Nullable
    private static DfaInstructionState[] handleConstantComparison(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft, DfaRelationValue.RelationType relationType) {
        DfaInstructionState[] result;
        Object value;
        if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaVariableValue) {
            Number leftValue = StandardInstructionVisitor.getKnownNumberValue(memState, (DfaVariableValue)dfaLeft);
            Number rightValue = StandardInstructionVisitor.getKnownNumberValue(memState, (DfaVariableValue)dfaRight);
            if (leftValue != null && rightValue != null) {
                return StandardInstructionVisitor.checkComparisonWithKnownValue(instruction, runner, memState, relationType, leftValue, rightValue);
            }
        }
        if (dfaRight instanceof DfaConstValue && dfaLeft instanceof DfaVariableValue && (value = ((DfaConstValue)dfaRight).getValue()) instanceof Number && (result = StandardInstructionVisitor.checkComparingWithConstant(instruction, runner, memState, (DfaVariableValue)dfaLeft, relationType, (Number)value)) != null) {
            return result;
        }
        if (dfaRight instanceof DfaVariableValue && dfaLeft instanceof DfaConstValue) {
            return StandardInstructionVisitor.handleConstantComparison(instruction, runner, memState, dfaLeft, dfaRight, relationType.getFlipped());
        }
        if (relationType != DfaRelationValue.RelationType.EQ && relationType != DfaRelationValue.RelationType.NE) {
            return null;
        }
        if (dfaLeft instanceof DfaConstValue && dfaRight instanceof DfaConstValue || dfaLeft == runner.getFactory().getConstFactory().getContractFail() || dfaRight == runner.getFactory().getConstFactory().getContractFail()) {
            boolean negated;
            if (dfaLeft == dfaRight ^ (negated = relationType == DfaRelationValue.RelationType.NE ^ (DfaMemoryStateImpl.isNaN(dfaLeft) || DfaMemoryStateImpl.isNaN(dfaRight)))) {
                return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
            }
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        return null;
    }

    @Nullable
    private static DfaInstructionState[] checkComparingWithConstant(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaVariableValue var, DfaRelationValue.RelationType opSign, Number comparedWith) {
        Number knownValue = StandardInstructionVisitor.getKnownNumberValue(memState, var);
        if (knownValue != null) {
            return StandardInstructionVisitor.checkComparisonWithKnownValue(instruction, runner, memState, opSign, knownValue, comparedWith);
        }
        return null;
    }

    @Nullable
    private static Number getKnownNumberValue(DfaMemoryState memState, DfaVariableValue var) {
        DfaConstValue knownConstantValue = memState.getConstantValue(var);
        return knownConstantValue != null && knownConstantValue.getValue() instanceof Number ? (Number)((Number)knownConstantValue.getValue()) : (Number)null;
    }

    private static DfaInstructionState[] checkComparisonWithKnownValue(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaRelationValue.RelationType opSign, Number leftValue, Number rightValue) {
        boolean hasNaN;
        int cmp = StandardInstructionVisitor.compare(leftValue, rightValue);
        Boolean result = null;
        boolean bl = hasNaN = DfaUtil.isNaN(leftValue) || DfaUtil.isNaN(rightValue);
        if (cmp < 0 || cmp > 0) {
            if (opSign == DfaRelationValue.RelationType.EQ) {
                result = false;
            } else if (opSign == DfaRelationValue.RelationType.NE) {
                result = true;
            }
        }
        if (opSign == DfaRelationValue.RelationType.LT) {
            result = !hasNaN && cmp < 0;
        } else if (opSign == DfaRelationValue.RelationType.GT) {
            result = !hasNaN && cmp > 0;
        } else if (opSign == DfaRelationValue.RelationType.LE) {
            result = !hasNaN && cmp <= 0;
        } else if (opSign == DfaRelationValue.RelationType.GE) {
            result = !hasNaN && cmp >= 0;
        }
        if (result == null) {
            return null;
        }
        return result != false ? StandardInstructionVisitor.alwaysTrue(instruction, runner, memState) : StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
    }

    private static int compare(Number a, Number b) {
        long bLong;
        long aLong = a.longValue();
        if (aLong != (bLong = b.longValue())) {
            return aLong > bLong ? 1 : -1;
        }
        return Double.compare(a.doubleValue(), b.doubleValue());
    }

    private static DfaInstructionState[] alwaysFalse(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.push(runner.getFactory().getConstFactory().getFalse());
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private static DfaInstructionState[] alwaysTrue(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.push(runner.getFactory().getConstFactory().getTrue());
        instruction.setTrueReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public boolean isInstanceofRedundant(InstanceofInstruction instruction) {
        return !this.myUsefulInstanceofs.contains(instruction) && !instruction.isConditionConst() && this.myReachable.contains(instruction);
    }

    public boolean canBeNull(BinopInstruction instruction) {
        return this.myCanBeNullInInstanceof.contains(instruction);
    }

    public boolean silenceConstantCondition(@Nullable PsiElement element) {
        for (PsiElement skipped : this.myNotToReportReachability) {
            if (!PsiTreeUtil.isAncestor(element, skipped, false)) continue;
            return true;
        }
        return false;
    }
}

