/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.configurationStore.StreamProviderKt;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class StateSplitterEx
implements StateSplitter {
    public static final String EXTERNAL_SYSTEM_ID_ATTRIBUTE = "external-system-id";

    @Override
    public abstract List<Pair<Element, String>> splitState(@NotNull Element var1);

    public void mergeStateInto(@NotNull Element target, @NotNull Element subState) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/openapi/components/StateSplitterEx", "mergeStateInto"));
        }
        if (subState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subState", "com/intellij/openapi/components/StateSplitterEx", "mergeStateInto"));
        }
        target.addContent(subState);
    }

    @Override
    public final void mergeStatesInto(Element target, Element[] elements) {
        throw new IllegalStateException();
    }

    @NotNull
    protected static List<Pair<Element, String>> splitState(@NotNull Element state, @NotNull String attributeName) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/StateSplitterEx", "splitState"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/openapi/components/StateSplitterEx", "splitState"));
        }
        List<Pair<Element, String>> list = StateSplitterEx.splitState(state, attributeName, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/StateSplitterEx", "splitState"));
        }
        return list;
    }

    @NotNull
    protected static List<Pair<Element, String>> splitState(@NotNull Element state, @NotNull String attributeName, boolean filterOutExternalElements) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/StateSplitterEx", "splitState"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/openapi/components/StateSplitterEx", "splitState"));
        }
        UniqueNameGenerator generator = new UniqueNameGenerator();
        SmartList<Pair<Element, String>> result = new SmartList<Pair<Element, String>>();
        boolean isExternalStorageEnabled = filterOutExternalElements && StreamProviderKt.isExternalStorageEnabled();
        for (Element subState : state.getChildren()) {
            if (isExternalStorageEnabled && subState.getAttribute(EXTERNAL_SYSTEM_ID_ATTRIBUTE) != null) continue;
            result.add(StateSplitterEx.createItem(subState.getAttributeValue(attributeName), generator, subState));
        }
        SmartList<Pair<Element, String>> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/StateSplitterEx", "splitState"));
        }
        return smartList;
    }

    @NotNull
    protected static Pair<Element, String> createItem(@NotNull String fileName, @NotNull UniqueNameGenerator generator, @NotNull Element element) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/components/StateSplitterEx", "createItem"));
        }
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/openapi/components/StateSplitterEx", "createItem"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/StateSplitterEx", "createItem"));
        }
        Pair<Element, String> pair = Pair.create(element, generator.generateUniqueName(FileUtil.sanitizeFileName(fileName)) + ".xml");
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/StateSplitterEx", "createItem"));
        }
        return pair;
    }

    protected static void mergeStateInto(@NotNull Element target, @NotNull Element subState, @NotNull String subStateName) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/openapi/components/StateSplitterEx", "mergeStateInto"));
        }
        if (subState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subState", "com/intellij/openapi/components/StateSplitterEx", "mergeStateInto"));
        }
        if (subStateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subStateName", "com/intellij/openapi/components/StateSplitterEx", "mergeStateInto"));
        }
        if (subState.getName().equals(subStateName)) {
            target.addContent(subState);
        } else {
            JDOMUtil.merge(target, subState);
        }
    }
}

