/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EditorFontCacheImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.colors.impl.TextAttributesReader;
import com.intellij.openapi.editor.colors.impl.ValueElementReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.ColorUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColorsScheme
extends EditorFontCacheImpl
implements EditorColorsScheme,
SerializableScheme {
    private static final int CURR_VERSION = 142;
    private static final FontSize DEFAULT_FONT_SIZE = FontSize.SMALL;
    protected EditorColorsScheme myParentScheme;
    protected FontSize myQuickDocFontSize = DEFAULT_FONT_SIZE;
    @NotNull
    private FontPreferences myFontPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
    @NotNull
    private FontPreferences myConsoleFontPreferences = new DelegatingFontPreferences(() -> this.myFontPreferences);
    private final ValueElementReader myValueReader = new TextAttributesReader();
    private String mySchemeName;
    private boolean myIsSaveNeeded;
    private boolean myCanBeDeleted = true;
    private int myVersion = 142;
    protected Map<ColorKey, Color> myColorsMap = ContainerUtilRt.newHashMap();
    protected Map<TextAttributesKey, TextAttributes> myAttributesMap = new THashMap();
    @NonNls
    private static final String EDITOR_FONT = "font";
    @NonNls
    private static final String CONSOLE_FONT = "console-font";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    private static final String CONSOLE_FONT_NAME = "CONSOLE_FONT_NAME";
    private Color myDeprecatedBackgroundColor = null;
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String BASE_ATTRIBUTES_ATTR = "baseAttributes";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String CONSOLE_LINE_SPACING = "CONSOLE_LINE_SPACING";
    @NonNls
    private static final String FONT_SCALE = "FONT_SCALE";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    @NonNls
    private static final String CONSOLE_FONT_SIZE = "CONSOLE_FONT_SIZE";
    @NonNls
    private static final String EDITOR_LIGATURES = "EDITOR_LIGATURES";
    @NonNls
    private static final String CONSOLE_LIGATURES = "CONSOLE_LIGATURES";
    @NonNls
    private static final String EDITOR_QUICK_JAVADOC_FONT_SIZE = "EDITOR_QUICK_DOC_FONT_SIZE";
    private final Properties myMetaInfo = new Properties();
    private static final SimpleDateFormat META_INFO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @NonNls
    private static final String META_INFO_ELEMENT = "metaInfo";
    @NonNls
    private static final String PROPERTY_ELEMENT = "property";
    @NonNls
    private static final String PROPERTY_NAME_ATTR = "name";
    @NonNls
    private static final String META_INFO_CREATION_TIME = "created";
    @NonNls
    private static final String META_INFO_MODIFIED_TIME = "modified";
    @NonNls
    private static final String META_INFO_IDE = "ide";
    @NonNls
    private static final String META_INFO_IDE_VERSION = "ideVersion";
    @NonNls
    private static final String META_INFO_ORIGINAL = "originalScheme";
    private static final Map<String, Couple<Color>> DEFAULT_STRIPE_COLORS = new THashMap<String, Couple<Color>>(){
        {
            this.put(CodeInsightColors.ERRORS_ATTRIBUTES.getExternalName(), Couple.of(Color.red, ColorUtil.fromHex("CF5B56")));
            this.put(CodeInsightColors.WARNINGS_ATTRIBUTES.getExternalName(), Couple.of(Color.yellow, ColorUtil.fromHex("EBC700")));
            this.put("EXECUTIONPOINT_ATTRIBUTES", Couple.of(Color.blue, ColorUtil.fromHex("3763b0")));
            this.put(EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("CCCFFF"), ColorUtil.fromHex("BAA8FF")));
            this.put(EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("FFCCE5"), ColorUtil.fromHex("F0ADF0")));
            this.put(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("586E75"), ColorUtil.fromHex("71B362")));
            this.put(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("268BD2"), ColorUtil.fromHex("54AAE3")));
        }
    };

    protected AbstractColorsScheme(EditorColorsScheme parentScheme) {
        this.myParentScheme = parentScheme;
    }

    public AbstractColorsScheme() {
    }

    public void setDefaultMetaInfo(@Nullable AbstractColorsScheme parentScheme) {
        this.myMetaInfo.setProperty(META_INFO_CREATION_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        this.myMetaInfo.setProperty(META_INFO_IDE, PlatformUtils.getPlatformPrefix());
        this.myMetaInfo.setProperty(META_INFO_IDE_VERSION, ApplicationInfoEx.getInstanceEx().getStrictVersion());
        if (parentScheme != null && parentScheme != EmptyColorScheme.INSTANCE) {
            this.myMetaInfo.setProperty(META_INFO_ORIGINAL, parentScheme.getName());
        }
    }

    @Override
    @NotNull
    public Color getDefaultBackground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        Color color = c != null ? c : Color.white;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultBackground"));
        }
        return color;
    }

    @Override
    @NotNull
    public Color getDefaultForeground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        Color color = c != null ? c : Color.black;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultForeground"));
        }
        return color;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getName"));
        }
        return string;
    }

    @Override
    public void setFont(EditorFontType key, Font font) {
    }

    @Override
    public abstract Object clone();

    public void copyTo(AbstractColorsScheme newScheme) {
        newScheme.myQuickDocFontSize = this.myQuickDocFontSize;
        if (this.myConsoleFontPreferences instanceof DelegatingFontPreferences) {
            newScheme.setUseEditorFontPreferencesInConsole();
        } else {
            newScheme.setConsoleFontPreferences(this.myConsoleFontPreferences);
        }
        if (this.myFontPreferences instanceof DelegatingFontPreferences) {
            newScheme.setUseAppFontPreferencesInEditor();
        } else {
            newScheme.setFontPreferences(this.myFontPreferences);
        }
        newScheme.myAttributesMap = new THashMap(this.myAttributesMap);
        newScheme.myColorsMap = new HashMap<ColorKey, Color>(this.myColorsMap);
        newScheme.myVersion = this.myVersion;
    }

    @Override
    public void setEditorFontName(String fontName) {
        int editorFontSize = this.getEditorFontSize();
        this.ensureEditableFontPreferences().clear();
        this.ensureEditableFontPreferences().register(fontName, editorFontSize);
        this.initFonts();
    }

    @Override
    public void setEditorFontSize(int fontSize) {
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        this.ensureEditableFontPreferences().register(this.myFontPreferences.getFontFamily(), fontSize);
        this.initFonts();
    }

    @Override
    public void setUseAppFontPreferencesInEditor() {
        this.myFontPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
        this.initFonts();
    }

    @Override
    public boolean isUseAppFontPreferencesInEditor() {
        return this.myFontPreferences instanceof DelegatingFontPreferences;
    }

    @Override
    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontSize", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setQuickDocFontSize"));
        }
        if (this.myQuickDocFontSize != fontSize) {
            this.myQuickDocFontSize = fontSize;
            this.myIsSaveNeeded = true;
        }
    }

    @Override
    public void setLineSpacing(float lineSpacing) {
        this.ensureEditableFontPreferences().setLineSpacing(lineSpacing);
    }

    @Override
    @NotNull
    public Font getFont(EditorFontType key) {
        Font font = this.myFontPreferences instanceof DelegatingFontPreferences ? EditorFontCache.getInstance().getFont(key) : super.getFont(key);
        if (font == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getFont"));
        }
        return font;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setName"));
        }
        this.mySchemeName = name;
    }

    @Override
    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getFontPreferences"));
        }
        return fontPreferences;
    }

    @Override
    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setFontPreferences"));
        }
        preferences.copyTo(this.ensureEditableFontPreferences());
        this.initFonts();
    }

    @Override
    public String getEditorFontName() {
        return this.getFont(EditorFontType.PLAIN).getFamily();
    }

    @Override
    public int getEditorFontSize() {
        return this.myFontPreferences.getSize(this.myFontPreferences.getFontFamily());
    }

    @Override
    @NotNull
    public FontSize getQuickDocFontSize() {
        FontSize fontSize = this.myQuickDocFontSize;
        if (fontSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getQuickDocFontSize"));
        }
        return fontSize;
    }

    @Override
    public float getLineSpacing() {
        return this.myFontPreferences.getLineSpacing();
    }

    protected void initFonts() {
        this.reset();
    }

    @Override
    protected EditorColorsScheme getFontCacheScheme() {
        return this;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void readExternal(@NotNull Element parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readExternal"));
        }
        UISettings settings = UISettings.getInstanceOrNull();
        ColorBlindness blindness = settings == null ? null : settings.getColorBlindness();
        this.myValueReader.setAttribute(blindness == null ? null : blindness.name());
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            List children = parentNode.getChildren(SCHEME_ELEMENT);
            if (children.isEmpty()) {
                throw new InvalidDataException("Scheme is not valid");
            }
            for (Element element : children) {
                this.readScheme(element);
            }
        }
        this.initFonts();
        this.myVersion = 142;
    }

    private void readScheme(Element node) {
        boolean isDefault;
        this.myDeprecatedBackgroundColor = null;
        if (!SCHEME_ELEMENT.equals(node.getName())) {
            return;
        }
        this.setName(node.getAttributeValue("name"));
        int readVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
        if (readVersion > 142) {
            throw new IllegalStateException("Unsupported color scheme version: " + readVersion);
        }
        this.myVersion = readVersion;
        String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
        boolean bl = isDefault = isDefaultScheme != null && Boolean.parseBoolean(isDefaultScheme);
        if (!isDefault) {
            this.myParentScheme = AbstractColorsScheme.getDefaultScheme(node.getAttributeValue(PARENT_SCHEME_ATTR, "Empty"));
        }
        this.myMetaInfo.clear();
        Ref<Float> fontScale = Ref.create();
        boolean clearEditorFonts = true;
        boolean clearConsoleFonts = true;
        for (Element childNode : node.getChildren()) {
            String childName;
            switch (childName = childNode.getName()) {
                case "option": {
                    this.readSettings(childNode, isDefault, fontScale);
                    break;
                }
                case "font": {
                    this.readFontSettings(this.ensureEditableFontPreferences(), childNode, isDefault, fontScale.get(), clearEditorFonts);
                    clearEditorFonts = false;
                    break;
                }
                case "console-font": {
                    this.readFontSettings(this.ensureEditableConsoleFontPreferences(), childNode, isDefault, fontScale.get(), clearConsoleFonts);
                    clearConsoleFonts = false;
                    break;
                }
                case "colors": {
                    this.readColors(childNode);
                    break;
                }
                case "attributes": {
                    this.readAttributes(childNode);
                    break;
                }
                case "metaInfo": {
                    this.readMetaInfo(childNode);
                }
            }
        }
        if (this.myDeprecatedBackgroundColor != null) {
            TextAttributes textAttributes = this.myAttributesMap.get(HighlighterColors.TEXT);
            if (textAttributes == null) {
                textAttributes = new TextAttributes(Color.black, this.myDeprecatedBackgroundColor, null, EffectType.BOXED, 0);
                this.myAttributesMap.put(HighlighterColors.TEXT, textAttributes);
            } else {
                textAttributes.setBackgroundColor(this.myDeprecatedBackgroundColor);
            }
        }
        if (this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty()) {
            this.myFontPreferences.copyTo(this.myConsoleFontPreferences);
        }
        this.initFonts();
    }

    @NotNull
    private static EditorColorsScheme getDefaultScheme(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultScheme"));
        }
        DefaultColorSchemesManager manager = DefaultColorSchemesManager.getInstance();
        EditorColorsScheme defaultScheme = manager.getScheme(name);
        if (defaultScheme == null) {
            defaultScheme = new TemporaryParent(name);
        }
        EditorColorsScheme editorColorsScheme = defaultScheme;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultScheme"));
        }
        return editorColorsScheme;
    }

    private void readMetaInfo(@NotNull Element metaInfoElement) {
        if (metaInfoElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaInfoElement", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readMetaInfo"));
        }
        this.myMetaInfo.clear();
        for (Element e : metaInfoElement.getChildren()) {
            String propertyName;
            if (!PROPERTY_ELEMENT.equals(e.getName()) || (propertyName = e.getAttributeValue("name")) == null) continue;
            this.myMetaInfo.setProperty(propertyName, e.getText());
        }
    }

    public void readAttributes(@NotNull Element childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readAttributes"));
        }
        for (Element e : childNode.getChildren(OPTION_ELEMENT)) {
            Element valueElement = e.getChild(VALUE_ELEMENT);
            TextAttributesKey key = TextAttributesKey.find(e.getAttributeValue("name"));
            if (valueElement == null) {
                if (e.getAttributeValue(BASE_ATTRIBUTES_ATTR) == null) continue;
                this.myAttributesMap.put(key, TextAttributes.USE_INHERITED_MARKER);
                continue;
            }
            TextAttributes attr = this.myValueReader.read(TextAttributes.class, valueElement);
            if (attr == null) continue;
            this.myAttributesMap.put(key, attr);
            this.migrateErrorStripeColorFrom14(key, attr);
        }
    }

    private void migrateErrorStripeColorFrom14(@NotNull TextAttributesKey name, @NotNull TextAttributes attr) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (this.myVersion >= 141 || this.myParentScheme == null) {
            return;
        }
        Couple<Color> m = DEFAULT_STRIPE_COLORS.get(name.getExternalName());
        if (m != null && Comparing.equal(m.first, attr.getErrorStripeColor())) {
            attr.setErrorStripeColor((Color)m.second);
        }
    }

    private void readColors(Element childNode) {
        for (Element colorElement : childNode.getChildren(OPTION_ELEMENT)) {
            Color valueColor = this.myValueReader.read(Color.class, colorElement);
            String colorName = colorElement.getAttributeValue("name");
            if (BACKGROUND_COLOR_NAME.equals(colorName)) {
                this.myDeprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find(colorName);
            this.myColorsMap.put(name, valueColor);
        }
    }

    private void readSettings(@NotNull Element childNode, boolean isDefault, @NotNull Ref<Float> fontScale) {
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readSettings"));
        }
        if (fontScale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontScale", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readSettings"));
        }
        switch (childNode.getAttributeValue("name")) {
            case "FONT_SCALE": {
                fontScale.set(this.myValueReader.read(Float.class, childNode));
                break;
            }
            case "LINE_SPACING": {
                Float value = this.myValueReader.read(Float.class, childNode);
                if (value == null) break;
                this.setLineSpacing(value.floatValue());
                break;
            }
            case "EDITOR_FONT_SIZE": {
                int value = this.readFontSize(childNode, isDefault, fontScale.get());
                if (value <= 0) break;
                this.setEditorFontSize(value);
                break;
            }
            case "EDITOR_FONT_NAME": {
                String value = this.myValueReader.read(String.class, childNode);
                if (value == null) break;
                this.setEditorFontName(value);
                break;
            }
            case "CONSOLE_LINE_SPACING": {
                Float value = this.myValueReader.read(Float.class, childNode);
                if (value == null) break;
                this.setConsoleLineSpacing(value.floatValue());
                break;
            }
            case "CONSOLE_FONT_SIZE": {
                int value = this.readFontSize(childNode, isDefault, fontScale.get());
                if (value <= 0) break;
                this.setConsoleFontSize(value);
                break;
            }
            case "CONSOLE_FONT_NAME": {
                String value = this.myValueReader.read(String.class, childNode);
                if (value == null) break;
                this.setConsoleFontName(value);
                break;
            }
            case "EDITOR_QUICK_DOC_FONT_SIZE": {
                FontSize value = this.myValueReader.read(FontSize.class, childNode);
                if (value == null) break;
                this.myQuickDocFontSize = value;
                break;
            }
            case "EDITOR_LIGATURES": {
                Boolean value = this.myValueReader.read(Boolean.class, childNode);
                if (value == null) break;
                this.ensureEditableFontPreferences().setUseLigatures(value);
                break;
            }
            case "CONSOLE_LIGATURES": {
                Boolean value = this.myValueReader.read(Boolean.class, childNode);
                if (value == null) break;
                this.ensureEditableConsoleFontPreferences().setUseLigatures(value);
                break;
            }
        }
    }

    private int readFontSize(Element element, boolean isDefault, Float fontScale) {
        if (isDefault) {
            return UISettings.getDefFontSize();
        }
        Integer intSize = this.myValueReader.read(Integer.class, element);
        if (intSize == null) {
            return -1;
        }
        return UISettings.restoreFontSize(intSize, fontScale);
    }

    private void readFontSettings(@NotNull ModifiableFontPreferences preferences, @NotNull Element element, boolean isDefaultScheme, @Nullable Float fontScale, boolean clearFonts) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        if (clearFonts) {
            preferences.clearFonts();
        }
        List children = element.getChildren(OPTION_ELEMENT);
        String fontFamily = null;
        int size = -1;
        for (Object child : children) {
            Element e = (Element)child;
            if (EDITOR_FONT_NAME.equals(e.getAttributeValue("name"))) {
                fontFamily = this.myValueReader.read(String.class, e);
                continue;
            }
            if (!EDITOR_FONT_SIZE.equals(e.getAttributeValue("name"))) continue;
            size = this.readFontSize(e, isDefaultScheme, fontScale);
        }
        if (fontFamily != null && size > 1) {
            preferences.register(fontFamily, size);
        } else if (fontFamily != null) {
            preferences.addFontFamily(fontFamily);
        }
    }

    public void writeExternal(Element parentNode) {
        boolean useOldFontFormat;
        parentNode.setAttribute("name", this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.myVersion));
        if (!(this.myFontPreferences instanceof DelegatingFontPreferences) || !(this.myConsoleFontPreferences instanceof DelegatingFontPreferences)) {
            JdomKt.addOptionTag(parentNode, FONT_SCALE, String.valueOf(UISettings.getDefFontScale()));
        }
        if (this.myParentScheme != null && this.myParentScheme != EmptyColorScheme.INSTANCE) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.myParentScheme.getName());
        }
        if (!this.myMetaInfo.isEmpty()) {
            parentNode.addContent(this.metaInfoToElement());
        }
        if (this.getLineSpacing() != 1.0f) {
            JdomKt.addOptionTag(parentNode, LINE_SPACING, String.valueOf(this.getLineSpacing()));
        }
        boolean bl = useOldFontFormat = this.myFontPreferences.getEffectiveFontFamilies().size() <= 1;
        if (!(this.myFontPreferences instanceof DelegatingFontPreferences)) {
            if (useOldFontFormat) {
                JdomKt.addOptionTag(parentNode, EDITOR_FONT_SIZE, String.valueOf(this.getEditorFontSize()));
                JdomKt.addOptionTag(parentNode, EDITOR_FONT_NAME, this.myFontPreferences.getFontFamily());
            } else {
                AbstractColorsScheme.writeFontPreferences(EDITOR_FONT, parentNode, this.myFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myFontPreferences, EDITOR_LIGATURES);
        }
        if (!(this.myConsoleFontPreferences instanceof DelegatingFontPreferences)) {
            if (this.myConsoleFontPreferences.getEffectiveFontFamilies().size() <= 1) {
                JdomKt.addOptionTag(parentNode, CONSOLE_FONT_NAME, this.getConsoleFontName());
                if (this.getConsoleFontSize() != this.getEditorFontSize()) {
                    JdomKt.addOptionTag(parentNode, CONSOLE_FONT_SIZE, Integer.toString(this.getConsoleFontSize()));
                }
            } else {
                AbstractColorsScheme.writeFontPreferences(CONSOLE_FONT, parentNode, this.myConsoleFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myConsoleFontPreferences, CONSOLE_LIGATURES);
            if (this.getConsoleLineSpacing() != 1.0f) {
                JdomKt.addOptionTag(parentNode, CONSOLE_LINE_SPACING, Float.toString(this.getConsoleLineSpacing()));
            }
        }
        if (DEFAULT_FONT_SIZE != this.getQuickDocFontSize()) {
            JdomKt.addOptionTag(parentNode, EDITOR_QUICK_JAVADOC_FONT_SIZE, this.getQuickDocFontSize().toString());
        }
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        if (!colorElements.getChildren().isEmpty()) {
            parentNode.addContent(colorElements);
        }
        if (!attrElements.getChildren().isEmpty()) {
            parentNode.addContent(attrElements);
        }
        this.myIsSaveNeeded = false;
    }

    private static void writeLigaturesPreferences(Element parentNode, FontPreferences preferences, String optionName) {
        if (preferences.useLigatures()) {
            JdomKt.addOptionTag(parentNode, optionName, String.valueOf(true));
        }
    }

    private static void writeFontPreferences(@NotNull String key, @NotNull Element parent, @NotNull FontPreferences preferences) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        for (String fontFamily : preferences.getRealFontFamilies()) {
            Element element = new Element(key);
            JdomKt.addOptionTag(element, EDITOR_FONT_NAME, fontFamily);
            JdomKt.addOptionTag(element, EDITOR_FONT_SIZE, String.valueOf(preferences.getSize(fontFamily)));
            parent.addContent(element);
        }
    }

    private boolean isParentOverwritingInheritance(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "isParentOverwritingInheritance"));
        }
        TextAttributes parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null;
        return parentAttributes != null && parentAttributes != TextAttributes.USE_INHERITED_MARKER;
    }

    private void writeAttributes(@NotNull Element attrElements) throws WriteExternalException {
        if (attrElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrElements", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeAttributes"));
        }
        ArrayList<TextAttributesKey> list = new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet());
        list.sort(null);
        for (TextAttributesKey key : list) {
            TextAttributes attributes = this.myAttributesMap.get(key);
            TextAttributesKey baseKey = key.getFallbackAttributeKey();
            if (attributes == TextAttributes.USE_INHERITED_MARKER) {
                if (baseKey == null || !this.isParentOverwritingInheritance(key)) continue;
                attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, baseKey.getExternalName()));
                continue;
            }
            if (this.myParentScheme != null) {
                TextAttributes parentAttributes;
                TextAttributes textAttributes = parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : this.myParentScheme.getAttributes(key);
                if (parentAttributes != null && attributes.equals(parentAttributes)) continue;
            }
            Element valueElement = new Element(VALUE_ELEMENT);
            attributes.writeExternal(valueElement);
            attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).addContent(valueElement));
        }
    }

    public void optimizeAttributeMap() {
        EditorColorsScheme parentScheme = this.myParentScheme;
        if (parentScheme == null) {
            return;
        }
        for (TextAttributesKey key : new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet())) {
            TextAttributes attributes = this.myAttributesMap.get(key);
            if (attributes == TextAttributes.USE_INHERITED_MARKER) {
                if (key.getFallbackAttributeKey() != null) continue;
                this.myAttributesMap.remove(key);
                continue;
            }
            TextAttributes parentAttributes = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getAttributes(key, false) : parentScheme.getAttributes(key);
            if (!Comparing.equal(parentAttributes, attributes)) continue;
            this.myAttributesMap.remove(key);
        }
    }

    @NotNull
    private Element metaInfoToElement() {
        Element metaInfoElement = new Element(META_INFO_ELEMENT);
        this.myMetaInfo.setProperty(META_INFO_MODIFIED_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(this.myMetaInfo.stringPropertyNames());
        sortedPropertyNames.sort(null);
        for (String propertyName : sortedPropertyNames) {
            String value = this.myMetaInfo.getProperty(propertyName);
            Element propertyInfo = new Element(PROPERTY_ELEMENT);
            propertyInfo.setAttribute("name", propertyName);
            propertyInfo.setText(value);
            metaInfoElement.addContent(propertyInfo);
        }
        Element element = metaInfoElement;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "metaInfoToElement"));
        }
        return element;
    }

    protected Color getOwnColor(ColorKey key) {
        return this.myColorsMap.get(key);
    }

    private void writeColors(Element colorElements) {
        ArrayList<ColorKey> list = new ArrayList<ColorKey>(this.myColorsMap.keySet());
        list.sort(null);
        for (ColorKey key : list) {
            if (!this.haveToWrite(key)) continue;
            Color value = this.myColorsMap.get(key);
            String value1 = value == null ? "" : Integer.toString(value.getRGB() & 0xFFFFFF, 16);
            JdomKt.addOptionTag(colorElements, key.getExternalName(), value1);
        }
    }

    private boolean haveToWrite(@NotNull ColorKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "haveToWrite"));
        }
        Color value = this.myColorsMap.get(key);
        return this.myParentScheme == null || !(this.myParentScheme instanceof AbstractColorsScheme ? Comparing.equal(((AbstractColorsScheme)this.myParentScheme).getOwnColor(key), value) && ((AbstractColorsScheme)this.myParentScheme).myColorsMap.containsKey(key) : Comparing.equal(this.myParentScheme.getColor(key), value));
    }

    private ModifiableFontPreferences ensureEditableFontPreferences() {
        if (!(this.myFontPreferences instanceof ModifiableFontPreferences)) {
            FontPreferencesImpl editablePrefs = new FontPreferencesImpl();
            this.myFontPreferences.copyTo(editablePrefs);
            this.myFontPreferences = editablePrefs;
            ((FontPreferencesImpl)this.myFontPreferences).setChangeListener(() -> this.initFonts());
        }
        return (ModifiableFontPreferences)this.myFontPreferences;
    }

    @Override
    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        FontPreferences fontPreferences = this.myConsoleFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getConsoleFontPreferences"));
        }
        return fontPreferences;
    }

    @Override
    public void setUseEditorFontPreferencesInConsole() {
        this.myConsoleFontPreferences = new DelegatingFontPreferences(() -> this.myFontPreferences);
        this.initFonts();
    }

    @Override
    public boolean isUseEditorFontPreferencesInConsole() {
        return this.myConsoleFontPreferences instanceof DelegatingFontPreferences;
    }

    @Override
    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setConsoleFontPreferences"));
        }
        preferences.copyTo(this.ensureEditableConsoleFontPreferences());
        this.initFonts();
    }

    @Override
    public String getConsoleFontName() {
        return this.myConsoleFontPreferences.getFontFamily();
    }

    private ModifiableFontPreferences ensureEditableConsoleFontPreferences() {
        if (!(this.myConsoleFontPreferences instanceof ModifiableFontPreferences)) {
            FontPreferencesImpl editablePrefs = new FontPreferencesImpl();
            this.myConsoleFontPreferences.copyTo(editablePrefs);
            this.myConsoleFontPreferences = editablePrefs;
        }
        return (ModifiableFontPreferences)this.myConsoleFontPreferences;
    }

    @Override
    public void setConsoleFontName(String fontName) {
        ModifiableFontPreferences consolePreferences = this.ensureEditableConsoleFontPreferences();
        int consoleFontSize = this.getConsoleFontSize();
        consolePreferences.clear();
        consolePreferences.register(fontName, consoleFontSize);
    }

    @Override
    public int getConsoleFontSize() {
        String font = this.getConsoleFontName();
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if ((uiSettings == null || !uiSettings.getPresentationMode()) && this.myConsoleFontPreferences.hasSize(font)) {
            return this.myConsoleFontPreferences.getSize(font);
        }
        return this.getEditorFontSize();
    }

    @Override
    public void setConsoleFontSize(int fontSize) {
        ModifiableFontPreferences consoleFontPreferences = this.ensureEditableConsoleFontPreferences();
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        consoleFontPreferences.register(this.getConsoleFontName(), fontSize);
        this.initFonts();
    }

    @Override
    public float getConsoleLineSpacing() {
        return this.myConsoleFontPreferences.getLineSpacing();
    }

    @Override
    public void setConsoleLineSpacing(float lineSpacing) {
        this.ensureEditableConsoleFontPreferences().setLineSpacing(lineSpacing);
    }

    protected TextAttributes getFallbackAttributes(@NotNull TextAttributesKey fallbackKey) {
        if (fallbackKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fallbackKey", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getFallbackAttributes"));
        }
        TextAttributes fallbackAttributes = this.getDirectlyDefinedAttributes(fallbackKey);
        TextAttributesKey fallbackKeyFallbackKey = fallbackKey.getFallbackAttributeKey();
        if (fallbackAttributes != null && (fallbackAttributes != TextAttributes.USE_INHERITED_MARKER || fallbackKeyFallbackKey == null)) {
            return fallbackAttributes;
        }
        return fallbackKeyFallbackKey == null ? null : this.getFallbackAttributes(fallbackKeyFallbackKey);
    }

    @Nullable
    public TextAttributes getDirectlyDefinedAttributes(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDirectlyDefinedAttributes"));
        }
        TextAttributes attributes = this.myAttributesMap.get(key);
        if (attributes != null) {
            return attributes;
        }
        return this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null;
    }

    @Override
    @NotNull
    public SchemeState getSchemeState() {
        SchemeState schemeState = this.myIsSaveNeeded ? SchemeState.POSSIBLY_CHANGED : SchemeState.UNCHANGED;
        if (schemeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getSchemeState"));
        }
        return schemeState;
    }

    public void setSaveNeeded(boolean value) {
        this.myIsSaveNeeded = value;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    @NotNull
    public Properties getMetaProperties() {
        Properties properties = this.myMetaInfo;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getMetaProperties"));
        }
        return properties;
    }

    public boolean canBeDeleted() {
        return this.myCanBeDeleted;
    }

    public void setCanBeDeleted(boolean canBeDeleted) {
        this.myCanBeDeleted = canBeDeleted;
    }

    public boolean isVisible() {
        return true;
    }

    public static boolean isVisible(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SCHEME_ELEMENT, "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "isVisible"));
        }
        return !(scheme instanceof AbstractColorsScheme) || ((AbstractColorsScheme)scheme).isVisible();
    }

    @Nullable
    public AbstractColorsScheme getOriginal() {
        EditorColorsScheme originalScheme;
        String originalSchemeName = this.getMetaProperties().getProperty(META_INFO_ORIGINAL);
        if (originalSchemeName != null && (originalScheme = EditorColorsManager.getInstance().getScheme(originalSchemeName)) instanceof AbstractColorsScheme) {
            return (AbstractColorsScheme)originalScheme;
        }
        return null;
    }

    public EditorColorsScheme getParentScheme() {
        return this.myParentScheme;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element root = new Element(SCHEME_ELEMENT);
        this.writeExternal(root);
        Element element = root;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeScheme"));
        }
        return element;
    }

    public boolean settingsEqual(Object other) {
        if (!(other instanceof AbstractColorsScheme)) {
            return false;
        }
        AbstractColorsScheme otherScheme = (AbstractColorsScheme)other;
        if (AbstractColorsScheme.getBaseDefaultScheme(this) != AbstractColorsScheme.getBaseDefaultScheme(otherScheme)) {
            return false;
        }
        for (String propertyName : this.myMetaInfo.stringPropertyNames()) {
            if (propertyName.equals(META_INFO_CREATION_TIME) || propertyName.equals(META_INFO_MODIFIED_TIME) || propertyName.equals(META_INFO_IDE) || propertyName.equals(META_INFO_IDE_VERSION) || propertyName.equals(META_INFO_ORIGINAL) || Comparing.equal(this.myMetaInfo.getProperty(propertyName), otherScheme.myMetaInfo.getProperty(propertyName))) continue;
            return false;
        }
        return AbstractColorsScheme.areDelegatingOrEqual(this.myFontPreferences, otherScheme.getFontPreferences()) && AbstractColorsScheme.areDelegatingOrEqual(this.myConsoleFontPreferences, otherScheme.getConsoleFontPreferences()) && this.attributesEqual(otherScheme) && this.colorsEqual(otherScheme);
    }

    protected static boolean areDelegatingOrEqual(@NotNull FontPreferences preferences1, @NotNull FontPreferences preferences2) {
        if (preferences1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences1", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "areDelegatingOrEqual"));
        }
        if (preferences2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences2", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "areDelegatingOrEqual"));
        }
        boolean isDelegating1 = preferences1 instanceof DelegatingFontPreferences;
        boolean isDelegating2 = preferences2 instanceof DelegatingFontPreferences;
        return isDelegating1 || isDelegating2 ? isDelegating1 && isDelegating2 : preferences1.equals(preferences2);
    }

    protected boolean attributesEqual(AbstractColorsScheme otherScheme) {
        return this.myAttributesMap.equals(otherScheme.myAttributesMap);
    }

    protected boolean colorsEqual(AbstractColorsScheme otherScheme) {
        return this.myColorsMap.equals(otherScheme.myColorsMap);
    }

    @Nullable
    private static EditorColorsScheme getBaseDefaultScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SCHEME_ELEMENT, "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getBaseDefaultScheme"));
        }
        if (!(scheme instanceof AbstractColorsScheme)) {
            return null;
        }
        if (scheme instanceof DefaultColorsScheme) {
            return scheme;
        }
        EditorColorsScheme parent = ((AbstractColorsScheme)scheme).myParentScheme;
        return parent != null ? AbstractColorsScheme.getBaseDefaultScheme(parent) : null;
    }

    public void setParent(@NotNull EditorColorsScheme newParent) {
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setParent"));
        }
        assert (newParent instanceof ReadOnlyColorsScheme) : "New parent scheme must be read-only";
        this.myParentScheme = newParent;
    }

    void resolveParent(@NotNull Function<String, EditorColorsScheme> nameResolver) {
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "resolveParent"));
        }
        if (this.myParentScheme instanceof TemporaryParent) {
            String parentName = ((TemporaryParent)this.myParentScheme).getParentName();
            EditorColorsScheme newParent = nameResolver.apply(parentName);
            assert (newParent != null) : "Can not resolve '" + parentName + "' color scheme.";
            assert (newParent instanceof ReadOnlyColorsScheme) : "Resolved parent color scheme must be read-only.";
            this.myParentScheme = newParent;
        }
    }

    private static class TemporaryParent
    extends EditorColorsSchemeImpl {
        private static Logger LOG = Logger.getInstance(TemporaryParent.class);
        private String myParentName;
        private boolean isErrorReported;

        public TemporaryParent(@NotNull String parentName) {
            if (parentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentName", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme$TemporaryParent", "<init>"));
            }
            super(EmptyColorScheme.INSTANCE);
            this.myParentName = parentName;
        }

        public String getParentName() {
            return this.myParentName;
        }

        @Override
        public TextAttributes getAttributes(@Nullable TextAttributesKey key) {
            this.reportError();
            return super.getAttributes(key);
        }

        @Override
        @Nullable
        public Color getColor(ColorKey key) {
            this.reportError();
            return super.getColor(key);
        }

        private void reportError() {
            if (!this.isErrorReported) {
                LOG.error("Unresolved link to " + this.myParentName);
                this.isErrorReported = true;
            }
        }
    }
}

