/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public abstract class SyntheticLibrary {
    @NotNull
    public abstract Collection<VirtualFile> getSourceRoots();

    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary", "getExcludedRoots"));
        }
        return set;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptySet());
        if (syntheticLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        return syntheticLibrary;
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(final @NotNull Collection<VirtualFile> sourceRoots, final @NotNull Set<VirtualFile> excludedRoots) {
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        if (excludedRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedRoots", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        SyntheticLibrary syntheticLibrary = new SyntheticLibrary(){

            @Override
            @NotNull
            public Collection<VirtualFile> getSourceRoots() {
                Collection collection = sourceRoots;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary$1", "getSourceRoots"));
                }
                return collection;
            }

            @Override
            @NotNull
            public Set<VirtualFile> getExcludedRoots() {
                Set set = excludedRoots;
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary$1", "getExcludedRoots"));
                }
                return set;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SyntheticLibrary library = (SyntheticLibrary)o;
                if (!sourceRoots.equals(library.getSourceRoots())) {
                    return false;
                }
                return excludedRoots.equals(library.getExcludedRoots());
            }

            @Override
            public int hashCode() {
                int result = sourceRoots.hashCode();
                result = 31 * result + excludedRoots.hashCode();
                return result;
            }
        };
        if (syntheticLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        return syntheticLibrary;
    }
}

