/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class DirectoryInfoWithExcludePatterns
extends DirectoryInfoImpl {
    private static final Logger LOG = Logger.getInstance(DirectoryInfoWithExcludePatterns.class);
    private final FileTypeAssocTable<Boolean> myExcludePatterns;

    public DirectoryInfoWithExcludePatterns(@NotNull VirtualFile root, Module module, VirtualFile contentRoot, VirtualFile sourceRoot, VirtualFile libraryClassRoot, boolean inModuleSource, boolean inLibrarySource, boolean isExcluded, int sourceRootTypeId, FileTypeAssocTable<Boolean> excludePatterns) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "<init>"));
        }
        super(root, module, contentRoot, sourceRoot, libraryClassRoot, inModuleSource, inLibrarySource, isExcluded, sourceRootTypeId);
        this.myExcludePatterns = excludePatterns;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file) {
        VirtualFile current;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "isExcluded"));
        }
        if (this.myExcluded) {
            return true;
        }
        for (current = file; current != null && !this.myRoot.equals(current); current = current.getParent()) {
            if (this.myExcludePatterns.findAssociatedFileType(current.getNameSequence()) == null) continue;
            return true;
        }
        if (current == null) {
            LOG.error("File " + file + " is not under this directory (" + this.myRoot + ")");
        }
        return false;
    }
}

