/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NegativelyNamedBooleanVariableInspectionBase
extends BaseInspection {
    @NonNls
    private static final String[] NEGATIVE_NAMES = new String[]{"not", "isNot", "isNon", "shouldNot", "shallNot", "willNot", "cannot", "cant", "hasNot", "couldNot", "doesNot", "hidden", "isHidden", "disabled", "isDisabled", "isInvalid", "invalid"};

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("negatively.named.boolean.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/NegativelyNamedBooleanVariableInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negatively.named.boolean.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/NegativelyNamedBooleanVariableInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegativelyNamedBooleanVariableVisitor();
    }

    private static class NegativelyNamedBooleanVariableVisitor
    extends BaseInspectionVisitor {
        private NegativelyNamedBooleanVariableVisitor() {
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            if (!PsiType.BOOLEAN.equals(variable.getType())) {
                return;
            }
            String name = variable.getName();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(variable.getProject());
            String prefix = codeStyleManager.getPrefixByVariableKind(codeStyleManager.getVariableKind(variable));
            for (String negativeName : NEGATIVE_NAMES) {
                if (!NegativelyNamedBooleanVariableVisitor.isNegativelyNamed(name, negativeName) && (prefix.isEmpty() || !NegativelyNamedBooleanVariableVisitor.isNegativelyNamed(name, prefix + negativeName))) continue;
                this.registerVariableError(variable, variable);
                break;
            }
        }

        private static boolean isNegativelyNamed(String name, String negativeName) {
            return name.startsWith(negativeName) && (name.length() == negativeName.length() || Character.isUpperCase(name.charAt(negativeName.length())));
        }
    }
}

