/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisIndex;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.HMethod;
import com.intellij.codeInspection.bytecodeAnalysis.InOutAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.InThrowAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.KeyedMethodVisitor;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysisFailure;
import com.intellij.codeInspection.bytecodeAnalysis.NonNullInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableMethodAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.PendingAction;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PurityAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.DFSTree;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LeakingParameters;
import com.intellij.codeInspection.bytecodeAnalysis.asm.OriginsAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.VirtualFileGist;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

public class ClassDataIndexer
implements VirtualFileGist.GistCalculator<Map<HMethod, Equations>> {
    public static final Final FINAL_TOP = new Final(Value.Top);
    public static final Final FINAL_FAIL = new Final(Value.Fail);
    public static final Final FINAL_BOT = new Final(Value.Bot);
    public static final Final FINAL_NOT_NULL = new Final(Value.NotNull);
    public static final Final FINAL_NULL = new Final(Value.Null);
    public static final Consumer<Map<HMethod, Equations>> ourIndexSizeStatistics = ApplicationManager.getApplication().isUnitTestMode() ? new ClassDataIndexerStatistics() : map -> {};

    @Override
    @Nullable
    public Map<HMethod, Equations> calcData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer", "calcData"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer", "calcData"));
        }
        HashMap<HMethod, Equations> map = new HashMap<HMethod, Equations>();
        try {
            MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
            Map<EKey, Equations> allEquations = ClassDataIndexer.processClass(new ClassReader(file.contentsToByteArray(false)), file.getPresentableUrl());
            allEquations.forEach((methodKey, equations) -> map.put(methodKey.method.hashed(md), ClassDataIndexer.hash(equations, md)));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
        }
        ourIndexSizeStatistics.consume(map);
        return map;
    }

    private static Equations hash(Equations equations, MessageDigest md) {
        return new Equations(ContainerUtil.map(equations.results, drp -> ClassDataIndexer.hash(drp, md)), equations.stable);
    }

    private static DirectionResultPair hash(DirectionResultPair drp, MessageDigest md) {
        return new DirectionResultPair(drp.directionKey, ClassDataIndexer.hash(drp.result, md));
    }

    private static Result hash(Result result, MessageDigest md) {
        if (result instanceof Effects) {
            Effects effects = (Effects)result;
            return new Effects(effects.returnValue, StreamEx.of(effects.effects).map(effect -> ClassDataIndexer.hash(effect, md)).toSet());
        }
        if (result instanceof Pending) {
            return new Pending(ContainerUtil.map(((Pending)result).delta, component -> ClassDataIndexer.hash(component, md)));
        }
        return result;
    }

    private static Component hash(Component component, MessageDigest md) {
        return new Component(component.value, (EKey[])StreamEx.of((Object[])component.ids).map(key -> key.hashed(md)).toArray(EKey[]::new));
    }

    private static EffectQuantum hash(EffectQuantum effect, MessageDigest md) {
        if (effect instanceof EffectQuantum.CallQuantum) {
            EffectQuantum.CallQuantum call = (EffectQuantum.CallQuantum)effect;
            return new EffectQuantum.CallQuantum(call.key.hashed(md), call.data, call.isStatic);
        }
        return effect;
    }

    @NotNull
    private static Equations convertEquations(EKey methodKey, List<Equation> rawMethodEquations) {
        List<DirectionResultPair> compressedMethodEquations = ContainerUtil.map(rawMethodEquations, equation -> new DirectionResultPair(equation.key.dirKey, equation.result));
        Equations equations = new Equations(compressedMethodEquations, methodKey.stable);
        if (equations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer", "convertEquations"));
        }
        return equations;
    }

    public static Map<EKey, Equations> processClass(ClassReader classReader, final String presentableUrl) {
        final State[] sharedPendingStates = new State[30000];
        final PendingAction[] sharedPendingActions = new PendingAction[30000];
        final PResults.PResult[] sharedResults = new PResults.PResult[30000];
        final HashMap<EKey, Equations> equations = new HashMap<EKey, Equations>();
        classReader.accept((ClassVisitor)new KeyedMethodVisitor(){

            @Override
            protected MethodVisitor visitMethod(final MethodNode node, final Method method, final EKey key) {
                return new MethodVisitor(393216, (MethodVisitor)node){
                    private boolean jsr;

                    public void visitJumpInsn(int opcode, Label label) {
                        if (opcode == 168) {
                            this.jsr = true;
                        }
                        super.visitJumpInsn(opcode, label);
                    }

                    public void visitEnd() {
                        super.visitEnd();
                        equations.put(key, ClassDataIndexer.convertEquations(key, this.processMethod(node, this.jsr, method, key.stable)));
                    }
                };
            }

            private List<Equation> processMethod(MethodNode methodNode, boolean jsr, Method method, boolean stable) {
                ProgressManager.checkCanceled();
                Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
                Type resultType = Type.getReturnType((String)methodNode.desc);
                boolean isReferenceResult = ASMUtils.isReferenceType(resultType);
                boolean isBooleanResult = ASMUtils.isBooleanType(resultType);
                boolean isInterestingResult = isReferenceResult || isBooleanResult;
                ArrayList<Equation> equations2 = new ArrayList<Equation>();
                ContainerUtil.addIfNotNull(equations2, PurityAnalysis.analyze(method, methodNode, stable));
                try {
                    ControlFlowGraph graph = ControlFlowGraph.build(this.className, methodNode, jsr);
                    if (graph.transitions.length > 0) {
                        boolean branching;
                        DFSTree dfs = DFSTree.build(graph.transitions, graph.edgeCount);
                        boolean bl = branching = !dfs.back.isEmpty();
                        if (!branching) {
                            for (int[] transition : graph.transitions) {
                                if (transition == null || transition.length <= 1) continue;
                                branching = true;
                                break;
                            }
                        }
                        if (branching) {
                            RichControlFlow richControlFlow = new RichControlFlow(graph, dfs);
                            if (richControlFlow.reducible()) {
                                NegationAnalysis negated = this.tryNegation(method, argumentTypes, graph, isBooleanResult, dfs, jsr);
                                this.processBranchingMethod(method, methodNode, richControlFlow, argumentTypes, resultType, stable, jsr, equations2, negated);
                                return equations2;
                            }
                            ProjectBytecodeAnalysis.LOG.debug(method + ": CFG is not reducible");
                        } else {
                            this.processNonBranchingMethod(method, argumentTypes, graph, resultType, stable, equations2);
                            return equations2;
                        }
                    }
                    equations2.addAll(this.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable));
                    return equations2;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during processing of " + method + " in " + presentableUrl, e);
                    return this.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable);
                }
            }

            private NegationAnalysis tryNegation(final Method method, final Type[] argumentTypes, final ControlFlowGraph graph, boolean isBooleanResult, DFSTree dfs, final boolean jsr) throws AnalyzerException {
                Util util;
                class Util {
                    Util() {
                    }

                    boolean isMethodCall(int opCode) {
                        return opCode == 184 || opCode == 183 || opCode == 182 || opCode == 185;
                    }

                    boolean singleIfBranch() {
                        int branch = 0;
                        for (int i2 = 0; i2 < graph.transitions.length; ++i2) {
                            int[] transition = graph.transitions[i2];
                            if (transition.length == 2) {
                                boolean isIfInsn;
                                ++branch;
                                int opCode = graph.methodNode.instructions.get(i2).getOpcode();
                                boolean bl = isIfInsn = opCode == 153 || opCode == 154;
                                if (!isIfInsn) {
                                    return false;
                                }
                            }
                            if (branch <= 1) continue;
                            return false;
                        }
                        return branch == 1;
                    }

                    boolean singleMethodCall() {
                        int callCount = 0;
                        for (int i2 = 0; i2 < graph.transitions.length; ++i2) {
                            if (!this.isMethodCall(graph.methodNode.instructions.get(i2).getOpcode()) || ++callCount <= 1) continue;
                            return false;
                        }
                        return callCount == 1;
                    }

                    public boolean booleanConstResult() {
                        try {
                            boolean[] origins = OriginsAnalysis.resultOrigins((this).leakingParametersAndFrames((Method)method, (MethodNode)graph.methodNode, (Type[])argumentTypes, (boolean)jsr).frames, graph.methodNode.instructions, graph);
                            for (int i2 = 0; i2 < origins.length; ++i2) {
                                boolean isBooleanConst;
                                if (!origins[i2]) continue;
                                int opCode = graph.methodNode.instructions.get(i2).getOpcode();
                                boolean bl = isBooleanConst = opCode == 3 || opCode == 4;
                                if (isBooleanConst) continue;
                                return false;
                            }
                            return true;
                        }
                        catch (AnalyzerException analyzerException) {
                            return false;
                        }
                    }
                }
                if (graph.methodNode.instructions.size() < 20 && isBooleanResult && dfs.back.isEmpty() && !jsr && (util = new Util()).singleIfBranch() && util.singleMethodCall() && util.booleanConstResult()) {
                    NegationAnalysis analyzer = new NegationAnalysis(method, graph);
                    try {
                        analyzer.analyze();
                        return analyzer;
                    }
                    catch (NegationAnalysisFailure ignore) {
                        return null;
                    }
                }
                return null;
            }

            private void processBranchingMethod(Method method, MethodNode methodNode, RichControlFlow richControlFlow, Type[] argumentTypes, Type resultType, boolean stable, boolean jsr, List<Equation> result, NegationAnalysis negatedAnalysis) throws AnalyzerException {
                boolean withCycle;
                Equation throwEquation;
                boolean shouldInferNonTrivialFailingContracts;
                Equation outEquation;
                boolean isReferenceResult = ASMUtils.isReferenceType(resultType);
                boolean isBooleanResult = ASMUtils.isBooleanType(resultType);
                boolean isInterestingResult = isBooleanResult || isReferenceResult;
                LeakingParameters leakingParametersAndFrames = this.leakingParametersAndFrames(method, methodNode, argumentTypes, jsr);
                boolean[] leakingParameters = leakingParametersAndFrames.parameters;
                boolean[] leakingNullableParameters = leakingParametersAndFrames.nullableParameters;
                boolean[] origins = OriginsAnalysis.resultOrigins(leakingParametersAndFrames.frames, methodNode.instructions, richControlFlow.controlFlow);
                Equation equation = outEquation = isInterestingResult ? new InOutAnalysis(richControlFlow, Direction.Out, origins, stable, sharedPendingStates).analyze() : null;
                if (isReferenceResult) {
                    result.add(outEquation);
                    result.add(new Equation(new EKey(method, Direction.NullableOut, stable), NullableMethodAnalysis.analyze(methodNode, origins, jsr)));
                }
                if (methodNode.name.equals("<init>")) {
                    shouldInferNonTrivialFailingContracts = false;
                    throwEquation = new Equation(new EKey(method, Direction.Throw, stable), FINAL_TOP);
                } else {
                    InThrowAnalysis inThrowAnalysis = new InThrowAnalysis(richControlFlow, Direction.Throw, origins, stable, sharedPendingStates);
                    throwEquation = inThrowAnalysis.analyze();
                    if (!throwEquation.result.equals(FINAL_TOP)) {
                        result.add(throwEquation);
                    }
                    shouldInferNonTrivialFailingContracts = !inThrowAnalysis.myHasNonTrivialReturn;
                }
                boolean bl = withCycle = !richControlFlow.dfsTree.back.isEmpty();
                if (argumentTypes.length > 50 && withCycle) {
                    return;
                }
                IntFunction<Function> inOuts = index -> val -> {
                    if (isBooleanResult && negatedAnalysis != null) {
                        return Stream.of(negatedAnalysis.contractEquation(index, (Value)((Object)((Object)val)), stable));
                    }
                    Stream.Builder<Equation> builder = Stream.builder();
                    try {
                        if (isInterestingResult) {
                            builder.add(new InOutAnalysis(richControlFlow, new Direction.InOut(index, (Value)((Object)((Object)val))), origins, stable, sharedPendingStates).analyze());
                        }
                        if (shouldInferNonTrivialFailingContracts) {
                            Direction.InThrow direction = new Direction.InThrow(index, (Value)((Object)((Object)val)));
                            if (throwEquation.result.equals(FINAL_FAIL)) {
                                builder.add(new Equation(new EKey(method, direction, stable), FINAL_FAIL));
                            } else {
                                builder.add(new InThrowAnalysis(richControlFlow, direction, origins, stable, sharedPendingStates).analyze());
                            }
                        }
                    }
                    catch (AnalyzerException e) {
                        throw new RuntimeException("Analyzer error", e);
                    }
                    return builder.build();
                };
                for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
                    boolean notNullParam = false;
                    if (ASMUtils.isReferenceType(argumentTypes[i2])) {
                        boolean possibleNPE = false;
                        if (leakingParameters[i2]) {
                            NonNullInAnalysis notNullInAnalysis = new NonNullInAnalysis(richControlFlow, new Direction.In(i2, false), stable, sharedPendingActions, sharedResults);
                            Equation notNullParamEquation = notNullInAnalysis.analyze();
                            possibleNPE = notNullInAnalysis.possibleNPE;
                            notNullParam = notNullParamEquation.result.equals(FINAL_NOT_NULL);
                            result.add(notNullParamEquation);
                        } else {
                            result.add(new Equation(new EKey(method, new Direction.In(i2, false), stable), FINAL_TOP));
                        }
                        if (leakingNullableParameters[i2]) {
                            if (notNullParam || possibleNPE) {
                                result.add(new Equation(new EKey(method, new Direction.In(i2, true), stable), FINAL_TOP));
                            } else {
                                result.add(new NullableInAnalysis(richControlFlow, new Direction.In(i2, true), stable, sharedPendingStates).analyze());
                            }
                        } else {
                            result.add(new Equation(new EKey(method, new Direction.In(i2, true), stable), FINAL_NULL));
                        }
                        if (isInterestingResult) {
                            if (!leakingParameters[i2]) {
                                result.add(new Equation(new EKey(method, new Direction.InOut(i2, Value.Null), stable), outEquation.result));
                                result.add(new Equation(new EKey(method, new Direction.InOut(i2, Value.NotNull), stable), outEquation.result));
                                continue;
                            }
                            if (notNullParam) {
                                result.add(new Equation(new EKey(method, new Direction.InOut(i2, Value.Null), stable), FINAL_BOT));
                                result.add(new Equation(new EKey(method, new Direction.InOut(i2, Value.NotNull), stable), outEquation.result));
                                continue;
                            }
                        }
                    }
                    Value.typeValues(argumentTypes[i2]).flatMap(inOuts.apply(i2)).forEach(result::add);
                }
            }

            private void processNonBranchingMethod(Method method, Type[] argumentTypes, ControlFlowGraph graph, Type returnType, boolean stable, List<Equation> result) throws AnalyzerException {
                CombinedAnalysis analyzer = new CombinedAnalysis(method, graph);
                analyzer.analyze();
                ContainerUtil.addIfNotNull(result, analyzer.outContractEquation(stable));
                ContainerUtil.addIfNotNull(result, analyzer.failEquation(stable));
                if (ASMUtils.isReferenceType(returnType)) {
                    result.add(analyzer.nullableResultEquation(stable));
                }
                EntryStream.of((Object[])argumentTypes).forKeyValue((i2, argType) -> {
                    if (ASMUtils.isReferenceType(argType)) {
                        result.add(analyzer.notNullParamEquation((int)i2, stable));
                        result.add(analyzer.nullableParamEquation((int)i2, stable));
                    }
                    Value.typeValues(argType).flatMap(val -> Stream.of(analyzer.contractEquation((int)i2, (Value)((Object)((Object)val)), stable), analyzer.failEquation((int)i2, (Value)((Object)((Object)val)), stable))).filter(Objects::nonNull).forEach(result::add);
                });
            }

            private List<Equation> topEquations(Method method, Type[] argumentTypes, boolean isReferenceResult, boolean isInterestingResult, boolean stable) {
                ArrayList<Equation> result = new ArrayList<Equation>(argumentTypes.length * 4 + 2);
                if (isReferenceResult) {
                    result.add(new Equation(new EKey(method, Direction.Out, stable), FINAL_TOP));
                    result.add(new Equation(new EKey(method, Direction.NullableOut, stable), FINAL_BOT));
                }
                for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
                    if (!ASMUtils.isReferenceType(argumentTypes[i2])) continue;
                    result.add(new Equation(new EKey(method, new Direction.In(i2, false), stable), FINAL_TOP));
                    result.add(new Equation(new EKey(method, new Direction.In(i2, true), stable), FINAL_TOP));
                    if (!isInterestingResult) continue;
                    result.add(new Equation(new EKey(method, new Direction.InOut(i2, Value.Null), stable), FINAL_TOP));
                    result.add(new Equation(new EKey(method, new Direction.InOut(i2, Value.NotNull), stable), FINAL_TOP));
                }
                return result;
            }

            @NotNull
            private LeakingParameters leakingParametersAndFrames(Method method, MethodNode methodNode, Type[] argumentTypes, boolean jsr) throws AnalyzerException {
                LeakingParameters leakingParameters = argumentTypes.length < 32 ? LeakingParameters.buildFast(method.internalClassName, methodNode, jsr) : LeakingParameters.build(method.internalClassName, methodNode, jsr);
                if (leakingParameters == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer$1", "leakingParametersAndFrames"));
                }
                return leakingParameters;
            }
        }, 6);
        return equations;
    }

    private static class ClassDataIndexerStatistics
    implements Consumer<Map<HMethod, Equations>> {
        private static final AtomicLong ourTotalSize = new AtomicLong(0L);
        private static final AtomicLong ourTotalCount = new AtomicLong(0L);

        private ClassDataIndexerStatistics() {
        }

        @Override
        public void consume(Map<HMethod, Equations> map) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                new BytecodeAnalysisIndex.EquationsExternalizer().save((DataOutput)new DataOutputStream(stream), map);
                ourTotalSize.addAndGet(stream.size());
                ourTotalCount.incrementAndGet();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            if (ourTotalCount.get() == 0L) {
                return "";
            }
            return String.format(Locale.ENGLISH, "Classes: %d\nBytes: %d\nBytes per class: %.2f%n", ourTotalCount.get(), ourTotalSize.get(), (double)ourTotalSize.get() / (double)ourTotalCount.get());
        }
    }
}

