/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CoreProjectJdkTable
extends ProjectJdkTable {
    private final List<Sdk> mySdks = new ArrayList<Sdk>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sdk findJdk(String name) {
        List<Sdk> list = this.mySdks;
        synchronized (list) {
            for (Sdk jdk : this.mySdks) {
                if (!Comparing.strEqual(name, jdk.getName())) continue;
                return jdk;
            }
        }
        return null;
    }

    @Override
    public Sdk findJdk(String name, String type) {
        return this.findJdk(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Sdk[] getAllJdks() {
        List<Sdk> list = this.mySdks;
        // MONITORENTER : list
        Sdk[] sdkArray = this.mySdks.toArray(new Sdk[this.mySdks.size()]);
        // MONITOREXIT : list
        if (sdkArray != null) return sdkArray;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectJdkTable", "getAllJdks"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Sdk> getSdksOfType(@NotNull SdkTypeId type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/core/CoreProjectJdkTable", "getSdksOfType"));
        }
        ArrayList<Sdk> result = new ArrayList<Sdk>();
        List<Sdk> list = this.mySdks;
        synchronized (list) {
            for (Sdk sdk : this.mySdks) {
                if (sdk.getSdkType() != type) continue;
                result.add(sdk);
            }
        }
        ArrayList<Sdk> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectJdkTable", "getSdksOfType"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/core/CoreProjectJdkTable", "addJdk"));
        }
        List<Sdk> list = this.mySdks;
        synchronized (list) {
            this.mySdks.add(jdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/intellij/core/CoreProjectJdkTable", "removeJdk"));
        }
        List<Sdk> list = this.mySdks;
        synchronized (list) {
            this.mySdks.remove(jdk);
        }
    }

    @Override
    public void updateJdk(@NotNull Sdk originalJdk, @NotNull Sdk modifiedJdk) {
        if (originalJdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalJdk", "com/intellij/core/CoreProjectJdkTable", "updateJdk"));
        }
        if (modifiedJdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiedJdk", "com/intellij/core/CoreProjectJdkTable", "updateJdk"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(@NotNull ProjectJdkTable.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/core/CoreProjectJdkTable", "addListener"));
        }
    }

    @Override
    public void removeListener(@NotNull ProjectJdkTable.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/core/CoreProjectJdkTable", "removeListener"));
        }
    }

    @Override
    @NotNull
    public SdkTypeId getDefaultSdkType() {
        CoreSdkType coreSdkType = CoreSdkType.INSTANCE;
        if (coreSdkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectJdkTable", "getDefaultSdkType"));
        }
        return coreSdkType;
    }

    @Override
    @NotNull
    public SdkTypeId getSdkTypeByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreProjectJdkTable", "getSdkTypeByName"));
        }
        CoreSdkType coreSdkType = CoreSdkType.INSTANCE;
        if (coreSdkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectJdkTable", "getSdkTypeByName"));
        }
        return coreSdkType;
    }

    @Override
    @NotNull
    public Sdk createSdk(@NotNull String name, @NotNull SdkTypeId sdkType) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreProjectJdkTable", "createSdk"));
        }
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkType", "com/intellij/core/CoreProjectJdkTable", "createSdk"));
        }
        throw new UnsupportedOperationException();
    }
}

