/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.Util;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;

class UniteSameType
implements DiffCorrection {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.processing.UniteSameType");
    public static final DiffCorrection INSTANCE = new UniteSameType();

    UniteSameType() {
    }

    @Override
    public DiffFragment[] correct(DiffFragment[] fragments) {
        return UniteSameType.unitSameTypes(UniteSameType.covertSequentialOneSideToChange(UniteSameType.unitSameTypes(fragments)));
    }

    @NotNull
    private static DiffFragment[] unitSameTypes(@NotNull DiffFragment[] fragments) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/openapi/diff/impl/processing/UniteSameType", "unitSameTypes"));
        }
        if (fragments.length < 2) {
            if (fragments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/UniteSameType", "unitSameTypes"));
            }
            return fragments;
        }
        DiffCorrection.FragmentsCollector collector = new DiffCorrection.FragmentsCollector();
        DiffFragment previous = fragments[0];
        for (int i2 = 1; i2 < fragments.length; ++i2) {
            DiffFragment fragment = fragments[i2];
            if (!fragment.isOneSide() && fragment.getText1().isEmpty() && fragment.getText2().isEmpty()) continue;
            if (Util.isSameType(previous, fragment)) {
                previous = Util.unite(previous, fragment);
                continue;
            }
            collector.add(previous);
            previous = fragment;
        }
        collector.add(previous);
        DiffFragment[] diffFragmentArray = collector.toArray();
        if (diffFragmentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/UniteSameType", "unitSameTypes"));
        }
        return diffFragmentArray;
    }

    @NotNull
    private static DiffFragment[] covertSequentialOneSideToChange(@NotNull DiffFragment[] fragments) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/openapi/diff/impl/processing/UniteSameType", "covertSequentialOneSideToChange"));
        }
        if (fragments.length < 2) {
            if (fragments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/UniteSameType", "covertSequentialOneSideToChange"));
            }
            return fragments;
        }
        DiffCorrection.FragmentsCollector collector = new DiffCorrection.FragmentsCollector();
        DiffFragment previous = null;
        for (int i2 = 0; i2 < fragments.length; ++i2) {
            DiffFragment fragment = fragments[i2];
            if (fragment.isOneSide()) {
                if (previous == null) {
                    previous = fragment;
                    continue;
                }
                FragmentSide side = FragmentSide.chooseSide(fragment);
                DiffString previousText = side.getText(previous);
                if (previousText == null) {
                    previousText = DiffString.EMPTY;
                }
                previous = side.createFragment(DiffString.concatenateNullable(previousText, side.getText(fragment)), side.getOtherText(previous), true);
                continue;
            }
            if (previous != null) {
                collector.add(previous);
            }
            previous = null;
            collector.add(fragment);
        }
        if (previous != null) {
            collector.add(previous);
        }
        DiffFragment[] diffFragmentArray = collector.toArray();
        if (diffFragmentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/UniteSameType", "covertSequentialOneSideToChange"));
        }
        return diffFragmentArray;
    }

    public static DiffFragment uniteAll(DiffFragment[] fragments) throws FilesTooBigForDiffException {
        LOG.assertTrue((fragments = INSTANCE.correct(fragments)).length == 1);
        return fragments[0];
    }
}

