/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;

public class InvalidVirtualFileAccessException
extends RuntimeException {
    public InvalidVirtualFileAccessException(VirtualFile file) {
        super(InvalidVirtualFileAccessException.composeMessage(file));
    }

    public InvalidVirtualFileAccessException(String message) {
        super(message);
    }

    private static String composeMessage(VirtualFile file) {
        String url = file.getUrl();
        String message = "Accessing invalid virtual file: " + url;
        try {
            VirtualFile found = VirtualFileManager.getInstance().findFileByUrl(url);
            message = message + "; original:" + InvalidVirtualFileAccessException.hashCode(file) + "; found:" + InvalidVirtualFileAccessException.hashCode(found);
            if (file.isInLocalFileSystem()) {
                boolean physicalExists = new File(file.getPath()).exists();
                message = message + "; File.exists()=" + physicalExists;
            } else {
                message = message + "; file system=" + file.getFileSystem();
            }
        }
        catch (Throwable t) {
            message = message + "; lookup failed: " + t.getMessage();
        }
        return message;
    }

    private static String hashCode(Object o) {
        return o != null ? String.valueOf(o.hashCode()) : "-";
    }
}

