/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FactoryMap<K, V>
implements Map<K, V> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("factoryMap");
    protected Map<K, V> myMap;

    @NotNull
    protected Map<K, V> createMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "createMap"));
        }
        return tHashMap;
    }

    @Nullable
    protected abstract V create(K var1);

    private Map<K, V> getMap() {
        if (this.myMap == null) {
            this.myMap = this.createMap();
        }
        return this.myMap;
    }

    @Override
    public V get(Object key) {
        Object k;
        Map map = this.getMap();
        V value = map.get(k = FactoryMap.notNull(key));
        if (value == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            value = this.create(key);
            if (stamp.mayCacheNow()) {
                Object v = FactoryMap.notNull(value);
                map.put(k, v);
            }
        }
        return value == FactoryMap.FAKE_NULL() ? null : (V)value;
    }

    private static <T> T FAKE_NULL() {
        return (T)ObjectUtils.NULL;
    }

    private static <T> T notNull(Object key) {
        return (T)(key == null ? FactoryMap.FAKE_NULL() : key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.myMap != null && this.myMap.containsKey(FactoryMap.notNull(key));
    }

    @Override
    public V put(K key, V value) {
        Object k = FactoryMap.notNull(key);
        Object v = FactoryMap.notNull(value);
        v = this.getMap().put(k, v);
        return v == FactoryMap.FAKE_NULL() ? null : (V)v;
    }

    @Override
    public V remove(Object key) {
        if (this.myMap == null) {
            return null;
        }
        V v = this.myMap.remove(key);
        return v == FactoryMap.FAKE_NULL() ? null : (V)v;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Object nullKey;
        if (this.myMap == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "keySet"));
            }
            return set;
        }
        Set<K> ts = this.myMap.keySet();
        if (ts.contains(nullKey = FactoryMap.FAKE_NULL())) {
            HashSet<K> hashSet = new HashSet<K>(ts);
            hashSet.remove(nullKey);
            hashSet.add(null);
            HashSet<K> hashSet2 = hashSet;
            if (hashSet2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "keySet"));
            }
            return hashSet2;
        }
        Set<K> set = ts;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "keySet"));
        }
        return set;
    }

    @NotNull
    public Collection<V> notNullValues() {
        if (this.myMap == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "notNullValues"));
            }
            return list;
        }
        ArrayList<V> values = ContainerUtil.newArrayList(this.myMap.values());
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != FactoryMap.FAKE_NULL()) continue;
            iterator.remove();
        }
        ArrayList<V> arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "notNullValues"));
        }
        return arrayList;
    }

    public boolean removeValue(Object value) {
        if (this.myMap == null) {
            return false;
        }
        Object t = ObjectUtils.notNull(value, FactoryMap.FAKE_NULL());
        return this.myMap.values().remove(t);
    }

    @Override
    public void clear() {
        if (this.myMap != null) {
            this.myMap.clear();
        }
    }

    @Override
    public int size() {
        if (this.myMap == null) {
            return 0;
        }
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap == null || this.myMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myMap != null && this.myMap.containsValue(value);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/util/containers/FactoryMap", "putAll"));
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.myMap == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "values"));
            }
            return list;
        }
        Collection<V> collection = this.myMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "values"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.myMap == null) {
            Set<Map.Entry<K, V>> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "entrySet"));
            }
            return set;
        }
        Set<Map.Entry<K, V>> set = this.myMap.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "entrySet"));
        }
        return set;
    }

    @NotNull
    public static <K, V> FactoryMap<K, V> createMap(final @NotNull Function<K, V> computeValue) {
        if (computeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computeValue", "com/intellij/util/containers/FactoryMap", "createMap"));
        }
        FactoryMap factoryMap = new FactoryMap<K, V>(){

            @Override
            @Nullable
            protected V create(K key) {
                return computeValue.fun(key);
            }
        };
        if (factoryMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FactoryMap", "createMap"));
        }
        return factoryMap;
    }
}

