/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class WaitNotifyNotInSynchronizedContextInspection
extends BaseInspection {
    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/threading/WaitNotifyNotInSynchronizedContextInspection", "isSuppressedFor"));
        }
        return super.isSuppressedFor(element);
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("wait.notify.not.in.synchronized.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitNotifyNotInSynchronizedContextInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String text2 = (String)infos[0];
        String string = InspectionGadgetsBundle.message("wait.notify.while.not.synchronized.on.problem.descriptor", text2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/WaitNotifyNotInSynchronizedContextInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaiNotifyNotInSynchronizedContextVisitor();
    }

    private static class WaiNotifyNotInSynchronizedContextVisitor
    extends BaseInspectionVisitor {
        private WaiNotifyNotInSynchronizedContextVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/WaitNotifyNotInSynchronizedContextInspection$WaiNotifyNotInSynchronizedContextVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (!ThreadingUtils.isNotifyOrNotifyAllCall(expression) && !ThreadingUtils.isWaitCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                if (WaiNotifyNotInSynchronizedContextVisitor.isSynchronizedOnThis(expression) || WaiNotifyNotInSynchronizedContextVisitor.isCoveredByGuardedByAnnotation(expression, "this")) {
                    return;
                }
                this.registerError((PsiElement)expression, "this");
            } else if (qualifier instanceof PsiReferenceExpression) {
                if (WaiNotifyNotInSynchronizedContextVisitor.isSynchronizedOn(expression, qualifier)) {
                    return;
                }
                String text2 = qualifier.getText();
                if (WaiNotifyNotInSynchronizedContextVisitor.isCoveredByGuardedByAnnotation(expression, text2)) {
                    return;
                }
                this.registerError((PsiElement)expression, text2);
            }
        }

        private static boolean isCoveredByGuardedByAnnotation(PsiElement context, String guard) {
            PsiMember member = PsiTreeUtil.getParentOfType(context, PsiMember.class);
            if (member == null) {
                return false;
            }
            return guard.equals(JCiPUtil.findGuardForMember(member));
        }

        private static boolean isSynchronizedOn(@NotNull PsiElement element, @NotNull PsiExpression target) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/threading/WaitNotifyNotInSynchronizedContextInspection$WaiNotifyNotInSynchronizedContextVisitor", "isSynchronizedOn"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/siyeh/ig/threading/WaitNotifyNotInSynchronizedContextInspection$WaiNotifyNotInSynchronizedContextVisitor", "isSynchronizedOn"));
            }
            PsiSynchronizedStatement context = PsiTreeUtil.getParentOfType(element, PsiSynchronizedStatement.class);
            if (context == null) {
                return false;
            }
            PsiSynchronizedStatement synchronizedStatement = context;
            PsiExpression lockExpression = ParenthesesUtils.stripParentheses(synchronizedStatement.getLockExpression());
            EquivalenceChecker checker = EquivalenceChecker.getCanonicalPsiEquivalence();
            return checker.expressionsAreEquivalent(lockExpression, target) || WaiNotifyNotInSynchronizedContextVisitor.isSynchronizedOn(synchronizedStatement, target);
        }

        private static boolean isSynchronizedOnThis(@NotNull PsiElement element) {
            PsiMethod method;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/threading/WaitNotifyNotInSynchronizedContextInspection$WaiNotifyNotInSynchronizedContextVisitor", "isSynchronizedOnThis"));
            }
            Object context = PsiTreeUtil.getParentOfType(element, PsiMethod.class, PsiSynchronizedStatement.class);
            if (context instanceof PsiSynchronizedStatement) {
                PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)context;
                PsiExpression lockExpression = ParenthesesUtils.stripParentheses(synchronizedStatement.getLockExpression());
                return lockExpression instanceof PsiThisExpression || WaiNotifyNotInSynchronizedContextVisitor.isSynchronizedOnThis(synchronizedStatement);
            }
            return context instanceof PsiMethod && (method = (PsiMethod)context).hasModifierProperty("synchronized");
        }
    }
}

