/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.source.AstPathPsiMap;
import com.intellij.psi.impl.source.FileTrees;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.tree.AstPath;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PatchedWeakReference;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFileImpl
extends ElementBase
implements PsiFileEx,
PsiFileWithStubSupport,
Queryable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiFileImpl");
    public static final String STUB_PSI_MISMATCH = "stub-psi mismatch";
    private static final AtomicFieldUpdater<PsiFileImpl, FileTrees> ourTreeUpdater = AtomicFieldUpdater.forFieldOfType(PsiFileImpl.class, FileTrees.class);
    private IElementType myElementType;
    protected IElementType myContentElementType;
    private long myModificationStamp;
    protected PsiFile myOriginalFile;
    private final FileViewProvider myViewProvider;
    private volatile FileTrees myTrees;
    private boolean myInvalidated;
    private AstPathPsiMap myRefToPsi;
    private final ThreadLocal<FileElement> myFileElementBeingLoaded;
    protected final PsiManagerEx myManager;
    public static final Key<Boolean> BUILDING_STUB = new Key("Don't use stubs mark!");
    private static final Comparator<PsiFile> FILE_BY_LANGUAGE_ID = Comparator.comparing(o -> o.getLanguage().getID());
    private final Object myStubFromTreeLock;

    protected PsiFileImpl(@NotNull IElementType elementType, IElementType contentElementType, @NotNull FileViewProvider provider) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/impl/source/PsiFileImpl", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PsiFileImpl", "<init>"));
        }
        this(provider);
        this.init(elementType, contentElementType);
    }

    protected PsiFileImpl(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PsiFileImpl", "<init>"));
        }
        this.myTrees = FileTrees.noStub(null, this);
        this.myFileElementBeingLoaded = new ThreadLocal();
        this.myStubFromTreeLock = new Object();
        this.myManager = (PsiManagerEx)provider.getManager();
        this.myViewProvider = provider;
        this.myRefToPsi = new AstPathPsiMap(this.getProject());
    }

    public void setContentElementType(IElementType contentElementType) {
        LOG.assertTrue(contentElementType instanceof ILazyParseableElementType, contentElementType);
        this.myContentElementType = contentElementType;
    }

    public IElementType getContentElementType() {
        return this.myContentElementType;
    }

    protected void init(@NotNull IElementType elementType, IElementType contentElementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/impl/source/PsiFileImpl", "init"));
        }
        this.myElementType = elementType;
        this.setContentElementType(contentElementType);
    }

    public TreeElement createContentLeafElement(CharSequence leafText) {
        if (this.myContentElementType instanceof ILazyParseableElementType) {
            return ASTFactory.lazy((ILazyParseableElementType)this.myContentElementType, leafText);
        }
        return ASTFactory.leaf(this.myContentElementType, leafText);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Nullable
    public FileElement getTreeElement() {
        FileElement node = this.derefTreeElement();
        if (node != null) {
            return node;
        }
        if (!this.getViewProvider().isPhysical()) {
            return this.loadTreeElement();
        }
        return null;
    }

    protected FileElement derefTreeElement() {
        return this.myTrees.derefTreeElement();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.myManager.getProject().isDisposed()) {
            return false;
        }
        if (!this.myViewProvider.getVirtualFile().isValid()) {
            return false;
        }
        return !this.myInvalidated;
    }

    @Override
    public void markInvalidated() {
        this.myInvalidated = true;
        DebugUtil.onInvalidated(this);
    }

    @Override
    public boolean isContentsLoaded() {
        return this.derefTreeElement() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FileElement loadTreeElement() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileViewProvider viewProvider = this.getViewProvider();
        if (viewProvider.isPhysical() && this.myManager.isAssertOnFileLoading(viewProvider.getVirtualFile())) {
            LOG.error("Access to tree elements not allowed in tests. path='" + viewProvider.getVirtualFile().getPresentableUrl() + "'");
        }
        FileElement treeElement = this.createFileElement(viewProvider.getContents());
        treeElement.setPsi(this);
        this.myFileElementBeingLoaded.set(treeElement);
        try {
            List<Pair<StubBasedPsiElementBase, AstPath>> bindings;
            FileTrees trees;
            FileElement savedTree;
            while ((savedTree = this.ensureTreeElement(viewProvider, treeElement, trees = this.myTrees, bindings = this.calcStubAstBindings(treeElement, trees))) == null) {
            }
            FileElement fileElement = savedTree;
            FileElement fileElement2 = fileElement;
            if (fileElement2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "loadTreeElement"));
            }
            return fileElement2;
        }
        finally {
            this.myFileElementBeingLoaded.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FileElement ensureTreeElement(@NotNull FileViewProvider viewProvider, @NotNull FileElement treeElement, @NotNull FileTrees trees, @NotNull List<Pair<StubBasedPsiElementBase, AstPath>> bindings) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PsiFileImpl", "ensureTreeElement"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/psi/impl/source/PsiFileImpl", "ensureTreeElement"));
        }
        if (trees == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trees", "com/intellij/psi/impl/source/PsiFileImpl", "ensureTreeElement"));
        }
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "com/intellij/psi/impl/source/PsiFileImpl", "ensureTreeElement"));
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            FileElement existing = this.derefTreeElement();
            if (existing != null) {
                return existing;
            }
            if (trees != this.myTrees) {
                return null;
            }
            this.switchFromStubToAst(bindings, trees);
            this.updateTrees(trees.withAst(this.createTreeElementPointer(treeElement)));
            if (LOG.isDebugEnabled() && viewProvider.isPhysical()) {
                LOG.debug("Loaded text for file " + viewProvider.getVirtualFile().getPresentableUrl());
            }
            return treeElement;
        }
    }

    @Override
    public ASTNode findTreeForStub(StubTree tree, StubElement<?> stub) {
        Iterator<StubElement<?>> stubs = tree.getPlainList().iterator();
        StubElement root = (StubElement)stubs.next();
        FileElement ast = this.calcTreeElement();
        if (root == stub) {
            return ast;
        }
        return PsiFileImpl.findTreeForStub(ast, stubs, stub);
    }

    @Nullable
    private static ASTNode findTreeForStub(ASTNode tree, Iterator<StubElement<?>> stubs, StubElement stub) {
        StubElement<?> curStub;
        IElementType type = tree.getElementType();
        if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(tree) && (curStub = stubs.next()) == stub) {
            return tree;
        }
        for (ASTNode node : tree.getChildren(null)) {
            ASTNode treeForStub = PsiFileImpl.findTreeForStub(node, stubs, stub);
            if (treeForStub == null) continue;
            return treeForStub;
        }
        return null;
    }

    private void switchFromStubToAst(List<Pair<StubBasedPsiElementBase, AstPath>> bindings, FileTrees trees) {
        if (!bindings.isEmpty() && trees.useStrongRefs) {
            List<String> psiStrings = ContainerUtil.map(bindings, pair -> ((StubBasedPsiElementBase)pair.first).getClass().getName());
            LOG.error(this + " of " + this.getClass() + "; " + psiStrings);
        }
        for (int i = 0; i < bindings.size(); ++i) {
            Pair<StubBasedPsiElementBase, AstPath> pair2 = bindings.get(i);
            StubBasedPsiElementBase psi = (StubBasedPsiElementBase)pair2.first;
            AstPath path = (AstPath)pair2.second;
            path.getNode().setPsi(psi);
            this.myRefToPsi.cachePsi(path, psi);
            psi.setStubIndex(i + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<StubBasedPsiElementBase, AstPath>> calcStubAstBindings(@NotNull FileElement root, FileTrees trees) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/source/PsiFileImpl", "calcStubAstBindings"));
        }
        final StubTree stubTree = trees.derefStub();
        if (stubTree == null || trees.astLoaded) {
            return Collections.emptyList();
        }
        final Iterator stubs = stubTree.getPlainList().iterator();
        stubs.next();
        final ArrayList result = ContainerUtil.newArrayList();
        IStubFileElementType elementType = this.getElementTypeForStubBuilder();
        assert (elementType != null);
        final StubBuilder builder = elementType.getBuilder();
        root.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement node) {
                CompositeElement parent = node.getTreeParent();
                if (parent != null && builder.skipChildProcessingWhenBuildingStubs(parent, node)) {
                    return;
                }
                IElementType type = node.getElementType();
                if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(node)) {
                    StubElement stub;
                    if (!stubs.hasNext()) {
                        PsiFileImpl.this.reportStubAstMismatch("Stub list is less than AST, last AST element: " + node.getElementType() + " " + node, stubTree);
                    }
                    if ((stub = (StubElement)stubs.next()).getStubType() != node.getElementType()) {
                        PsiFileImpl.this.reportStubAstMismatch("Stub and PSI element type mismatch in " + PsiFileImpl.this.getName() + ": stub " + stub + ", AST " + node.getElementType() + "; " + node, stubTree);
                    }
                    AstPath path = AstPath.getNodePath((CompositeElement)node);
                    assert (path != null);
                    result.add(Pair.create(stub, path));
                }
                super.visitNode(node);
            }
        });
        if (stubs.hasNext()) {
            this.reportStubAstMismatch("Stub list in " + this.getName() + " has more elements than PSI", stubTree);
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            return ContainerUtil.map(result, pair -> {
                StubElement stub = (StubElement)pair.first;
                Object psi = stub.getPsi();
                assert (psi != null) : "Stub " + stub + " (" + stub.getClass() + ") has returned null PSI";
                return Pair.create((StubBasedPsiElementBase)psi, pair.second);
            });
        }
    }

    @Nullable
    public IStubFileElementType getElementTypeForStubBuilder() {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage());
        IFileElementType type = definition == null ? null : definition.getFileNodeType();
        return type instanceof IStubFileElementType ? (IStubFileElementType)type : null;
    }

    void reportStubAstMismatch(String message, StubTree stubTree) {
        this.rebuildStub();
        this.updateTrees(this.myTrees.clearStub(STUB_PSI_MISMATCH));
        throw StubTreeLoader.getInstance().stubTreeAndIndexDoNotMatch(message, stubTree, this);
    }

    @NotNull
    protected FileElement createFileElement(CharSequence docText) {
        FileElement treeElement;
        TreeElement contentLeaf = this.createContentLeafElement(docText);
        if (contentLeaf instanceof FileElement) {
            treeElement = (FileElement)contentLeaf;
        } else {
            CompositeElement xxx = ASTFactory.composite(this.myElementType);
            assert (xxx instanceof FileElement) : "BUMM";
            treeElement = (FileElement)xxx;
            treeElement.rawAddChildrenWithoutNotifications(contentLeaf);
        }
        FileElement fileElement = treeElement;
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "createFileElement"));
        }
        return fileElement;
    }

    public void clearCaches() {
        ++this.myModificationStamp;
    }

    @Override
    public String getText() {
        FileElement tree = this.derefTreeElement();
        if (!this.isValid()) {
            if (tree != null) {
                return tree.getText();
            }
            throw new PsiInvalidElementAccessException(this);
        }
        String string = this.getViewProvider().getContents().toString();
        if (tree != null && string.length() != tree.getTextLength()) {
            throw new AssertionError((Object)("File text mismatch: tree.length=" + tree.getTextLength() + "; psi.length=" + string.length() + "; this=" + this + "; vp=" + this.getViewProvider()));
        }
        return string;
    }

    @Override
    public int getTextLength() {
        FileElement tree = this.derefTreeElement();
        if (tree != null) {
            return tree.getTextLength();
        }
        PsiUtilCore.ensureValid(this);
        return this.getViewProvider().getContents().length();
    }

    @Override
    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling(this);
    }

    @Override
    public long getModificationStamp() {
        PsiElement context = this.getContext();
        PsiFile contextFile = context == null || !context.isValid() ? null : context.getContainingFile();
        long contextStamp = contextFile == null ? 0L : contextFile.getModificationStamp();
        return this.myModificationStamp + contextStamp;
    }

    @Override
    public void subtreeChanged() {
        this.doClearCaches("subtreeChanged");
        this.getViewProvider().rootChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClearCaches(String reason) {
        FileElement tree = this.getTreeElement();
        if (tree != null) {
            tree.clearCaches();
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.updateTrees(this.myTrees.clearStub(reason));
        }
        this.clearCaches();
    }

    @Override
    protected PsiFileImpl clone() {
        FileViewProvider viewProvider = this.getViewProvider();
        FileViewProvider providerCopy = viewProvider.clone();
        Language language = this.getLanguage();
        if (providerCopy == null) {
            throw new AssertionError((Object)("Unable to clone the view provider: " + viewProvider + "; " + language));
        }
        PsiFileImpl clone = BlockSupportImpl.getFileCopy(this, providerCopy);
        this.copyCopyableDataTo(clone);
        clone.myRefToPsi = new AstPathPsiMap(this.getProject());
        if (this.getTreeElement() != null) {
            FileElement treeClone = (FileElement)this.calcTreeElement().clone();
            clone.setTreeElementPointer(treeClone);
            treeClone.setPsi(clone);
        }
        if (viewProvider.isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        FileManagerImpl.clearPsiCaches(providerCopy);
        return clone;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiFileImpl", "setName"));
        }
        this.checkSetName(name);
        this.doClearCaches("setName");
        return PsiFileImplUtil.setName(this, name);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    @Override
    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    @Nullable
    public PsiDirectory getContainingDirectory() {
        VirtualFile file = this.getViewProvider().getVirtualFile();
        VirtualFile parentFile = file.getParent();
        if (parentFile == null) {
            return null;
        }
        if (!parentFile.isValid()) {
            LOG.error("Invalid parent: " + parentFile + " of file " + file + ", file.valid=" + file.isValid());
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFileImpl psiFileImpl = this;
        if (psiFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getContainingFile"));
        }
        return psiFileImpl;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getOriginalFile"));
        }
        return psiFile;
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/psi/impl/source/PsiFileImpl", "setOriginalFile"));
        }
        this.myOriginalFile = originalFile.getOriginalFile();
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        FileViewProvider viewProvider = this.getViewProvider();
        Set<Language> languages = viewProvider.getLanguages();
        PsiFile[] roots = new PsiFile[languages.size()];
        int i = 0;
        for (Language language : languages) {
            PsiFile psi = viewProvider.getPsi(language);
            if (psi == null) {
                LOG.error("PSI is null for " + language + "; in file: " + this);
            }
            roots[i++] = psi;
        }
        if (roots.length > 1) {
            Arrays.sort(roots, FILE_BY_LANGUAGE_ID);
        }
        if (roots == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getPsiRoots"));
        }
        return roots;
    }

    @Override
    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getLanguage"));
        }
        return language;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    public void setTreeElementPointer(@Nullable FileElement element) {
        this.updateTrees(FileTrees.noStub(element, this));
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return this.getViewProvider().findReferenceAt(offset);
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequence(this.getViewProvider().getContents());
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "textToCharArray"));
        }
        return cArray;
    }

    @NotNull
    public <T> T[] findChildrenByClass(Class<T> aClass) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            result.add(child);
        }
        Object[] objectArray = result.toArray((Object[])Array.newInstance(aClass, result.size()));
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "findChildrenByClass"));
        }
        return objectArray;
    }

    @Nullable
    public <T> T findChildByClass(Class<T> aClass) {
        for (PsiElement child : this.getChildren()) {
            if (!aClass.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public boolean isTemplateDataFile() {
        return false;
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DebugUtil.startPsiModification("onContentReload");
        try {
            this.myRefToPsi.invalidatePsi();
            FileElement treeElement = this.derefTreeElement();
            if (treeElement != null) {
                this.setTreeElementPointer(null);
                treeElement.detachFromFile();
                DebugUtil.onInvalidated(treeElement);
            }
            this.updateTrees(this.myTrees.clearStub("onContentReload"));
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        this.clearCaches();
    }

    @Nullable
    public StubElement getStub() {
        StubTree stubHolder = this.getStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    @Nullable
    public final StubElement getGreenStub() {
        StubTree stubHolder = this.getGreenStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myTrees.astLoaded && !this.mayReloadStub()) {
            return null;
        }
        if (Boolean.TRUE.equals(this.getUserData(BUILDING_STUB))) {
            return null;
        }
        StubTree derefd = this.derefStub();
        if (derefd != null) {
            return derefd;
        }
        if (this.getElementTypeForStubBuilder() == null) {
            return null;
        }
        VirtualFile vFile = this.getVirtualFile();
        if (!(vFile instanceof VirtualFileWithId) || !vFile.isValid()) {
            return null;
        }
        ObjectStubTree tree = StubTreeLoader.getInstance().readOrBuild(this.getProject(), vFile, this);
        if (!(tree instanceof StubTree)) {
            return null;
        }
        FileViewProvider viewProvider = this.getViewProvider();
        List<Pair<IStubFileElementType, PsiFile>> roots = StubTreeBuilder.getStubbedRoots(viewProvider);
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.getTreeElement() != null || this.hasUnbindableCachedPsi()) {
                return null;
            }
            StubTree derefdOnLock = this.derefStub();
            if (derefdOnLock != null) {
                return derefdOnLock;
            }
            PsiFileStub baseRoot = ((StubTree)tree).getRoot();
            if (baseRoot instanceof PsiFileStubImpl && !((PsiFileStubImpl)baseRoot).rootsAreSet()) {
                LOG.error("Stub roots must be set when stub tree was read or built with StubTreeLoader");
                return null;
            }
            PsiFileStub[] stubRoots = baseRoot.getStubRoots();
            if (stubRoots.length != roots.size()) {
                Function<PsiFileStub, String> stubToString = stub -> stub.getClass().getSimpleName();
                LOG.error("readOrBuilt roots = " + StringUtil.join(stubRoots, stubToString, ", ") + "; " + StubTreeLoader.getFileViewProviderMismatchDiagnostics(viewProvider));
                this.rebuildStub();
                return null;
            }
            Map<PsiFileImpl, StubTree> bindings = PsiFileImpl.prepareAllStubTrees(roots, stubRoots);
            StubTree result = bindings.get(this);
            assert (result != null) : "Current file not in root list: " + roots + ", vp=" + viewProvider;
            for (PsiFileImpl eachPsiRoot : bindings.keySet()) {
                eachPsiRoot.updateTrees(eachPsiRoot.myTrees.withExclusiveStub(bindings.get(eachPsiRoot), bindings.keySet()));
            }
            return result;
        }
    }

    private static Map<PsiFileImpl, StubTree> prepareAllStubTrees(List<Pair<IStubFileElementType, PsiFile>> roots, PsiFileStub[] rootStubs) {
        IdentityHashMap<PsiFileImpl, StubTree> bindings = ContainerUtil.newIdentityHashMap();
        for (int i = 0; i < roots.size(); ++i) {
            PsiFileImpl eachPsiRoot = (PsiFileImpl)roots.get((int)i).second;
            ((StubBase)((Object)rootStubs[i])).setPsi(eachPsiRoot);
            StubTree stubTree = new StubTree(rootStubs[i]);
            FileElement fileElement = eachPsiRoot.getTreeElement();
            stubTree.setDebugInfo("created in getStubTree(), with AST = " + (fileElement != null));
            if (fileElement != null) {
                TreeUtil.bindStubsToTree(eachPsiRoot, stubTree, fileElement);
                continue;
            }
            eachPsiRoot.bindStubsToCachedPsi(stubTree);
            bindings.put(eachPsiRoot, stubTree);
        }
        return bindings;
    }

    private boolean mayReloadStub() {
        StubTreeLoader loader = StubTreeLoader.getInstance();
        if (loader != null && loader.isStubReloadingProhibited()) {
            return false;
        }
        return this.getTreeElement() == null && !this.useStrongRefs() && !this.hasUnbindableCachedPsi();
    }

    private boolean hasUnbindableCachedPsi() {
        for (PsiFile file : this.myViewProvider.getAllFiles()) {
            if (!(file instanceof PsiFileImpl)) continue;
            for (StubBasedPsiElementBase<?> psi : ((PsiFileImpl)file).myRefToPsi.getAllCachedPsi()) {
                if (psi.getStubIndex() >= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private StubTree derefStub() {
        return this.myTrees.derefStub();
    }

    private void updateTrees(@NotNull FileTrees trees) {
        if (trees == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trees", "com/intellij/psi/impl/source/PsiFileImpl", "updateTrees"));
        }
        if (!ourTreeUpdater.compareAndSet(this, this.myTrees, trees)) {
            LOG.error("Non-atomic trees update");
            this.myTrees = trees;
        }
    }

    private void bindStubsToCachedPsi(StubTree stubTree) {
        for (StubBasedPsiElementBase<?> psi : this.myRefToPsi.getAllCachedPsi()) {
            int index = psi.getStubIndex();
            if (index < 0) continue;
            ((StubBase)stubTree.getPlainList().get(index)).setPsi(psi);
        }
    }

    protected PsiFileImpl cloneImpl(FileElement treeElementClone) {
        PsiFileImpl clone = (PsiFileImpl)super.clone();
        clone.myRefToPsi = new AstPathPsiMap(this.getProject());
        clone.setTreeElementPointer(treeElementClone);
        treeElementClone.setPsi(clone);
        return clone;
    }

    private boolean isKeepTreeElementByHardReference() {
        return !this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    private Getter<FileElement> createTreeElementPointer(@NotNull FileElement treeElement) {
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/psi/impl/source/PsiFileImpl", "createTreeElementPointer"));
        }
        if (this.isKeepTreeElementByHardReference()) {
            FileElement fileElement = treeElement;
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "createTreeElementPointer"));
            }
            return fileElement;
        }
        Reference reference = this.myManager.isBatchFilesProcessingMode() ? new PatchedWeakReference<FileElement>(treeElement) : new SoftReference<FileElement>(treeElement);
        if (reference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "createTreeElementPointer"));
        }
        return reference;
    }

    @Override
    public final PsiManager getManager() {
        return this.myManager;
    }

    @Override
    public PsiElement getNavigationElement() {
        return this;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this.getOriginalFile();
    }

    @NotNull
    public final FileElement calcTreeElement() {
        FileElement treeElement = this.getTreeElement();
        if (treeElement != null) {
            FileElement fileElement = treeElement;
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcTreeElement"));
            }
            return fileElement;
        }
        treeElement = this.myFileElementBeingLoaded.get();
        if (treeElement != null) {
            FileElement fileElement = treeElement;
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcTreeElement"));
            }
            return fileElement;
        }
        FileElement fileElement = this.loadTreeElement();
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcTreeElement"));
        }
        return fileElement;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.calcTreeElement().getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.getNode());
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.getNode());
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiFileImpl", "acceptChildren"));
        }
        SharedImplUtil.acceptChildren(visitor, this.getNode());
    }

    @Override
    public int getStartOffsetInParent() {
        return this.calcTreeElement().getStartOffsetInParent();
    }

    @Override
    public int getTextOffset() {
        return this.calcTreeElement().getTextOffset();
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/PsiFileImpl", "textMatches"));
        }
        return this.calcTreeElement().textMatches(text);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "textMatches"));
        }
        return this.calcTreeElement().textMatches(element);
    }

    @Override
    public boolean textContains(char c) {
        return this.calcTreeElement().textContains(c);
    }

    @Override
    public final PsiElement copy() {
        return this.clone();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "add"));
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "addBefore"));
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "addAfter"));
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "checkAdd"));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/PsiFileImpl", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/psi/impl/source/PsiFileImpl", "addRangeBefore"));
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor), Boolean.FALSE);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        if (first == null) {
            LOG.assertTrue(last == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        FileElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren(treeElement, firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/PsiFileImpl", "replace"));
        }
        FileElement treeElement = this.calcTreeElement();
        return SharedImplUtil.doReplace(this, treeElement, newElement);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/PsiFileImpl", "processDeclarations"));
        }
        return true;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getUseScope"));
        }
        return globalSearchScope;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Override
            public String getPresentableText() {
                return PsiFileImpl.this.getName();
            }

            @Override
            public String getLocationString() {
                PsiDirectory psiDirectory = PsiFileImpl.this.getParent();
                if (psiDirectory != null) {
                    return psiDirectory.getVirtualFile().getPresentableUrl();
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean open) {
                return PsiFileImpl.this.getIcon(0);
            }
        };
    }

    @Override
    public void navigate(boolean requestFocus) {
        assert (this.canNavigate()) : this;
        PsiNavigationSupport.getInstance().getDescriptor(this).navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.getManager().getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public FileASTNode getNode() {
        FileElement fileElement = this.calcTreeElement();
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getNode"));
        }
        return fileElement;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    @Nullable
    public final StubTree getGreenStubTree() {
        StubTree result = this.derefStub();
        return result != null ? result : this.getStubTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public StubTree calcStubTree() {
        StubTree tree = this.derefStub();
        if (tree != null) {
            StubTree stubTree = tree;
            if (stubTree != null) return stubTree;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcStubTree"));
        }
        assert (this.myFileElementBeingLoaded.get() == null) : "non-empty thread-local";
        FileElement fileElement = this.calcTreeElement();
        Object object = this.myStubFromTreeLock;
        // MONITORENTER : object
        tree = this.derefStub();
        if (tree == null) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            IStubFileElementType contentElementType = this.getElementTypeForStubBuilder();
            if (contentElementType == null) {
                VirtualFile vFile = this.getVirtualFile();
                String message = "ContentElementType: " + this.getContentElementType() + "; file: " + this + "\n\tBoolean.TRUE.equals(getUserData(BUILDING_STUB)) = " + Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)) + "\n\tgetTreeElement() = " + this.getTreeElement() + "\n\tvFile instanceof VirtualFileWithId = " + (vFile instanceof VirtualFileWithId) + "\n\tStubUpdatingIndex.canHaveStub(vFile) = " + StubTreeLoader.getInstance().canHaveStub(vFile);
                this.rebuildStub();
                throw new AssertionError((Object)message);
            }
            StubElement currentStubTree = contentElementType.getBuilder().buildStubTree(this);
            if (currentStubTree == null) {
                throw new AssertionError((Object)("Stub tree wasn't built for " + contentElementType + "; file: " + this));
            }
            tree = new StubTree((PsiFileStub)currentStubTree);
            tree.setDebugInfo("created in calcStubTree");
            try {
                TreeUtil.bindStubsToTree(this, tree, fileElement);
            }
            catch (TreeUtil.StubBindingException e) {
                this.rebuildStub();
                throw new RuntimeException("Stub and PSI element type mismatch in " + this.getName(), e);
            }
            this.updateTrees(this.myTrees.withGreenStub(tree, this));
        }
        StubTree stubTree = tree;
        // MONITOREXIT : object
        if (stubTree != null) return stubTree;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcStubTree"));
    }

    private void rebuildStub() {
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile vFile;
            if (!this.myManager.isDisposed()) {
                this.myManager.dropPsiCaches();
            }
            if ((vFile = this.getVirtualFile()) != null && vFile.isValid()) {
                Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                if (doc != null) {
                    FileDocumentManager.getInstance().saveDocument(doc);
                }
                FileContentUtilCore.reparseFiles(vFile);
                StubTreeLoader.getInstance().rebuildStubTree(vFile);
            }
        }, ModalityState.NON_MODAL);
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/source/PsiFileImpl", "putInfo"));
        }
        PsiFileImpl.putInfo(this, info);
    }

    public static void putInfo(PsiFile psiFile, Map<String, String> info) {
        info.put("fileName", psiFile.getName());
        info.put("fileType", psiFile.getFileType().toString());
    }

    @Override
    public String toString() {
        return this.myElementType.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeAstChange() {
        if (!this.useStrongRefs()) {
            Object object = PsiLock.LOCK;
            synchronized (object) {
                for (PsiFile root : this.myViewProvider.getAllFiles()) {
                    if (!(root instanceof PsiFileImpl)) continue;
                    ((PsiFileImpl)root).switchToStrongRefs();
                }
            }
        }
    }

    private void switchToStrongRefs() {
        FileElement node = this.calcTreeElement();
        this.updateTrees(this.myTrees.switchToStrongRefs());
        this.myRefToPsi.switchToStrongRefs();
        AstPath.invalidatePaths(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public StubBasedPsiElementBase<?> obtainPsi(@NotNull AstPath path, @NotNull Factory<StubBasedPsiElementBase<?>> creator) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/psi/impl/source/PsiFileImpl", "obtainPsi"));
        }
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/psi/impl/source/PsiFileImpl", "obtainPsi"));
        }
        if (this.useStrongRefs()) {
            return null;
        }
        StubBasedPsiElementBase<?> psi = this.myRefToPsi.getCachedPsi(path);
        if (psi != null) {
            return psi;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            psi = this.myRefToPsi.getCachedPsi(path);
            return psi != null ? psi : this.myRefToPsi.cachePsi(path, creator.create());
        }
    }

    final AstPathPsiMap getRefToPsi() {
        return this.myRefToPsi;
    }

    public final boolean useStrongRefs() {
        return this.myTrees.useStrongRefs;
    }

    public boolean mayCacheAst() {
        return this.myFileElementBeingLoaded.get() == null;
    }
}

