/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAttributeIntentionFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myLocalName;

    public RemoveAttributeIntentionFix(String localName, @NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix", "<init>"));
        }
        super(attribute);
        this.myLocalName = localName;
    }

    @Override
    @NotNull
    public String getText() {
        String string = XmlErrorMessages.message("remove.attribute.quickfix.text", this.myLocalName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("remove.attribute.quickfix.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix", "invoke"));
        }
        PsiElement next = RemoveAttributeIntentionFix.findNextAttribute((XmlAttribute)startElement);
        startElement.delete();
        if (next != null && editor != null) {
            editor.getCaretModel().moveToOffset(next.getTextRange().getStartOffset());
        }
    }

    @Nullable
    private static PsiElement findNextAttribute(XmlAttribute attribute) {
        for (PsiElement nextSibling = attribute.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof XmlAttribute)) continue;
            return nextSibling;
        }
        return null;
    }
}

