/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class Equations {
    @NotNull
    final List<DirectionResultPair> results;
    final boolean stable;

    Equations(@NotNull List<DirectionResultPair> results, boolean stable) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/codeInspection/bytecodeAnalysis/Equations", "<init>"));
        }
        this.results = results;
        this.stable = stable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Equations that = (Equations)o;
        return this.stable == that.stable && this.results.equals(that.results);
    }

    public int hashCode() {
        return 31 * this.results.hashCode() + (this.stable ? 1 : 0);
    }

    @NotNull
    Equations update(Direction direction, Effects newResult) {
        List newPairs = ((StreamEx)StreamEx.of(this.results).map(drp -> drp.updateForDirection(direction, newResult)).nonNull()).toList();
        Equations equations = new Equations(newPairs, this.stable);
        if (equations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/Equations", "update"));
        }
        return equations;
    }
}

