/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisIndex;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.EquationsLimitException;
import com.intellij.codeInspection.bytecodeAnalysis.HMethod;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.MethodDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.ParameterAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.PuritySolver;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Solver;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class ProjectBytecodeAnalysis {
    private static final boolean SKIP_INDEX = false;
    public static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.bytecodeAnalysis");
    public static final Key<Boolean> INFERRED_ANNOTATION = Key.create("INFERRED_ANNOTATION");
    public static final String NULLABLE_METHOD = "java.annotations.inference.nullable.method";
    public static final String NULLABLE_METHOD_TRANSITIVITY = "java.annotations.inference.nullable.method.transitivity";
    public static final int EQUATIONS_LIMIT = 1000;
    private final Project myProject;
    private final boolean nullableMethod;
    private final boolean nullableMethodTransitivity;
    private final EquationProvider<?> myEquationProvider;

    public static ProjectBytecodeAnalysis getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "getInstance"));
        }
        return ServiceManager.getService(project, ProjectBytecodeAnalysis.class);
    }

    public ProjectBytecodeAnalysis(Project project) {
        this.myProject = project;
        this.myEquationProvider = new IndexedEquationProvider(this.myProject);
        this.nullableMethod = Registry.is(NULLABLE_METHOD);
        this.nullableMethodTransitivity = Registry.is(NULLABLE_METHOD_TRANSITIVITY);
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotation"));
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            return null;
        }
        if (annotationFQN.equals("org.jetbrains.annotations.NotNull") || annotationFQN.equals("org.jetbrains.annotations.Nullable") || annotationFQN.equals(ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = this.findInferredAnnotations(listOwner)) {
                if (!annotationFQN.equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
            return null;
        }
        return null;
    }

    @NotNull
    public PsiAnnotation[] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotations"));
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotations"));
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue(listOwner, () -> {
            if (listOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "lambda$findInferredAnnotations$0"));
            }
            return CachedValueProvider.Result.create(this.collectInferredAnnotations(listOwner), listOwner);
        });
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotations"));
        }
        return psiAnnotationArray;
    }

    private static boolean isInsideDummyAndroidJar(@Nullable PsiFile psiFile) {
        VirtualFile file;
        VirtualFile virtualFile = file = psiFile == null ? null : psiFile.getVirtualFile();
        if (file == null) {
            return false;
        }
        String path = file.getPath();
        int index = path.indexOf("/android.jar!/");
        return index > 0 && path.lastIndexOf("platforms/android-", index) > 0;
    }

    @NotNull
    private PsiAnnotation[] collectInferredAnnotations(PsiModifierListOwner listOwner) {
        block15: {
            block14: {
                EKey primaryKey;
                block13: {
                    block11: {
                        block12: {
                            if (ProjectBytecodeAnalysis.isInsideDummyAndroidJar(listOwner.getContainingFile())) {
                                if (PsiAnnotation.EMPTY_ARRAY == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                                }
                                return PsiAnnotation.EMPTY_ARRAY;
                            }
                            try {
                                MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
                                primaryKey = this.getKey(listOwner, md);
                                if (primaryKey != null) break block11;
                                if (PsiAnnotation.EMPTY_ARRAY != null) break block12;
                            }
                            catch (EquationsLimitException e) {
                                if (LOG.isDebugEnabled()) {
                                    String externalName = PsiFormatUtil.getExternalName(listOwner, false, Integer.MAX_VALUE);
                                    LOG.debug("Too many equations for " + externalName);
                                }
                                if (PsiAnnotation.EMPTY_ARRAY == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                                }
                                return PsiAnnotation.EMPTY_ARRAY;
                            }
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                        }
                        return PsiAnnotation.EMPTY_ARRAY;
                    }
                    if (!(listOwner instanceof PsiMethod)) break block13;
                    ArrayList<EKey> allKeys = ProjectBytecodeAnalysis.collectMethodKeys((PsiMethod)listOwner, primaryKey);
                    MethodAnnotations methodAnnotations = this.loadMethodAnnotations((PsiMethod)listOwner, primaryKey, allKeys);
                    PsiAnnotation[] psiAnnotationArray = this.toPsi(primaryKey, methodAnnotations);
                    if (psiAnnotationArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                    }
                    return psiAnnotationArray;
                }
                if (!(listOwner instanceof PsiParameter)) break block14;
                ParameterAnnotations parameterAnnotations = this.loadParameterAnnotations(primaryKey);
                PsiAnnotation[] psiAnnotationArray = this.toPsi(parameterAnnotations);
                if (psiAnnotationArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                }
                return psiAnnotationArray;
            }
            if (PsiAnnotation.EMPTY_ARRAY != null) break block15;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @NotNull
    private PsiAnnotation[] toPsi(EKey primaryKey, MethodAnnotations methodAnnotations) {
        PsiAnnotation psiAnnotation;
        boolean notNull = methodAnnotations.notNulls.contains(primaryKey);
        boolean nullable = methodAnnotations.nullables.contains(primaryKey);
        boolean pure = methodAnnotations.pures.contains(primaryKey);
        String contractValues = methodAnnotations.contractsValues.get(primaryKey);
        String contractPsiText = null;
        if (contractValues != null) {
            contractPsiText = pure ? "value=" + contractValues + ",pure=true" : contractValues;
        } else if (pure) {
            contractPsiText = "pure=true";
        }
        PsiAnnotation psiAnnotation2 = psiAnnotation = contractPsiText == null ? null : this.createContractAnnotation(contractPsiText);
        if (notNull && psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation(), psiAnnotation};
            if (psiAnnotationArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "toPsi"));
            }
            return psiAnnotationArray;
        }
        if (nullable && psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation(), psiAnnotation};
            if (psiAnnotationArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "toPsi"));
            }
            return psiAnnotationArray;
        }
        if (notNull) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation()};
            if (psiAnnotationArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "toPsi"));
            }
            return psiAnnotationArray;
        }
        if (nullable) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation()};
            if (psiAnnotationArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "toPsi"));
            }
            return psiAnnotationArray;
        }
        if (psiAnnotation != null) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{psiAnnotation};
            if (psiAnnotationArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "toPsi"));
            }
            return psiAnnotationArray;
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "toPsi"));
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @NotNull
    private PsiAnnotation[] toPsi(ParameterAnnotations parameterAnnotations) {
        if (parameterAnnotations.notNull) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNotNullAnnotation()};
            if (psiAnnotationArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "toPsi"));
            }
            return psiAnnotationArray;
        }
        if (parameterAnnotations.nullable) {
            PsiAnnotation[] psiAnnotationArray = new PsiAnnotation[]{this.getNullableAnnotation()};
            if (psiAnnotationArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "toPsi"));
            }
            return psiAnnotationArray;
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "toPsi"));
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    public PsiAnnotation getNotNullAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager(this.myProject).getCachedValue(this.myProject, () -> CachedValueProvider.Result.create(this.createAnnotationFromText("@org.jetbrains.annotations.NotNull"), ModificationTracker.NEVER_CHANGED));
    }

    public PsiAnnotation getNullableAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager(this.myProject).getCachedValue(this.myProject, () -> CachedValueProvider.Result.create(this.createAnnotationFromText("@org.jetbrains.annotations.Nullable"), ModificationTracker.NEVER_CHANGED));
    }

    public PsiAnnotation createContractAnnotation(String contractValue) {
        Map cache = (Map)CachedValuesManager.getManager(this.myProject).getCachedValue(this.myProject, () -> {
            ConcurrentFactoryMap<String, PsiAnnotation> map = ConcurrentFactoryMap.createConcurrentMap(attrs -> this.createAnnotationFromText("@org.jetbrains.annotations.Contract(" + attrs + ")"));
            return CachedValueProvider.Result.create(map, ModificationTracker.NEVER_CHANGED);
        });
        return (PsiAnnotation)cache.get(contractValue);
    }

    @Nullable
    public EKey getKey(@NotNull PsiModifierListOwner owner, MessageDigest md) {
        PsiElement gParent;
        PsiElement parent;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "getKey"));
        }
        LOG.assertTrue(owner instanceof PsiCompiledElement, owner);
        if (owner instanceof PsiMethod) {
            EKey key = BytecodeAnalysisConverter.psiKey((PsiMethod)owner, Direction.Out);
            return key == null ? null : this.myEquationProvider.adaptKey(key, md);
        }
        if (owner instanceof PsiParameter && (parent = owner.getParent()) instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod) {
            int index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)owner);
            EKey key = BytecodeAnalysisConverter.psiKey((PsiMethod)gParent, new Direction.In(index, false));
            return key == null ? null : this.myEquationProvider.adaptKey(key, md);
        }
        return null;
    }

    public static ArrayList<EKey> collectMethodKeys(@NotNull PsiMethod method, EKey primaryKey) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectMethodKeys"));
        }
        return BytecodeAnalysisConverter.mkInOutKeys(method, primaryKey);
    }

    private ParameterAnnotations loadParameterAnnotations(@NotNull EKey notNullKey) throws EquationsLimitException {
        if (notNullKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notNullKey", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "loadParameterAnnotations"));
        }
        Solver notNullSolver = new Solver(new ELattice<Value>(Value.NotNull, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(notNullKey), notNullSolver);
        Map<EKey, Value> notNullSolutions = notNullSolver.solve();
        boolean notNull = Value.NotNull == notNullSolutions.get(notNullKey) || Value.NotNull == notNullSolutions.get(notNullKey.mkUnstable());
        Solver nullableSolver = new Solver(new ELattice<Value>(Value.Null, Value.Top), Value.Top);
        EKey nullableKey = new EKey(notNullKey.method, notNullKey.dirKey + 1, true, false);
        this.collectEquations(Collections.singletonList(nullableKey), nullableSolver);
        Map<EKey, Value> nullableSolutions = nullableSolver.solve();
        boolean nullable = Value.Null == nullableSolutions.get(nullableKey) || Value.Null == nullableSolutions.get(nullableKey.mkUnstable());
        return new ParameterAnnotations(notNull, nullable);
    }

    private MethodAnnotations loadMethodAnnotations(@NotNull PsiMethod owner, @NotNull EKey key, ArrayList<EKey> allKeys) throws EquationsLimitException {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "loadMethodAnnotations"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "loadMethodAnnotations"));
        }
        MethodAnnotations result = new MethodAnnotations();
        PuritySolver puritySolver = new PuritySolver();
        this.collectPurityEquations(key.withDirection(Direction.Pure), puritySolver);
        Map<EKey, Effects> puritySolutions = puritySolver.solve();
        int arity = owner.getParameterList().getParameters().length;
        BytecodeAnalysisConverter.addEffectAnnotations(puritySolutions, result, key, owner.isConstructor());
        EKey failureKey = key.withDirection(Direction.Throw);
        Solver failureSolver = new Solver(new ELattice<Value>(Value.Fail, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(failureKey), failureSolver);
        if (failureSolver.solve().get(failureKey) == Value.Fail) {
            result.contractsValues.put(key, StreamEx.constant((Object)"_", (long)arity).joining((CharSequence)",", (CharSequence)"\"", (CharSequence)"->fail\""));
        } else {
            Solver outSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Top), Value.Top);
            this.collectEquations(allKeys, outSolver);
            Map<EKey, Value> solutions = outSolver.solve();
            BytecodeAnalysisConverter.addMethodAnnotations(solutions, result, key, arity);
        }
        if (this.nullableMethod) {
            Solver nullableMethodSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Null), Value.Bot);
            EKey nullableKey = key.withDirection(Direction.NullableOut);
            if (this.nullableMethodTransitivity) {
                this.collectEquations(Collections.singletonList(nullableKey), nullableMethodSolver);
            } else {
                this.collectSingleEquation(nullableKey, nullableMethodSolver);
            }
            Map<EKey, Value> nullableSolutions = nullableMethodSolver.solve();
            if (nullableSolutions.get(nullableKey) == Value.Null || nullableSolutions.get(nullableKey.invertStability()) == Value.Null) {
                result.nullables.add(key);
            }
        }
        return result;
    }

    private void collectPurityEquations(EKey key, PuritySolver puritySolver) throws EquationsLimitException {
        HashSet<EKey> queued = new HashSet<EKey>();
        Stack<EKey> queue = new Stack<EKey>();
        queue.push(key);
        queued.add(key);
        while (!queue.empty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            EKey hKey = (EKey)queue.pop();
            for (Equations equations : this.myEquationProvider.getEquations(hKey.method)) {
                boolean stable = equations.stable;
                for (DirectionResultPair pair : equations.results) {
                    int dirKey = pair.directionKey;
                    if (dirKey != hKey.dirKey) continue;
                    Effects effects = (Effects)pair.result;
                    puritySolver.addEquation(new EKey(hKey.method, dirKey, stable, false), effects);
                    effects.dependencies().forEach(depKey -> {
                        if (!queued.contains(depKey)) {
                            queue.push((EKey)depKey);
                            queued.add((EKey)depKey);
                        }
                    });
                }
            }
        }
    }

    private void collectEquations(List<EKey> keys, Solver solver) throws EquationsLimitException {
        HashSet<EKey> queued = new HashSet<EKey>();
        Stack<EKey> queue = new Stack<EKey>();
        for (EKey key : keys) {
            queue.push(key);
            queued.add(key);
        }
        while (!queue.empty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            EKey hKey = (EKey)queue.pop();
            for (Equations equations : this.myEquationProvider.getEquations(hKey.method)) {
                boolean stable = equations.stable;
                for (DirectionResultPair pair : equations.results) {
                    int dirKey = pair.directionKey;
                    if (dirKey != hKey.dirKey) continue;
                    Result result = pair.result;
                    solver.addEquation(new Equation(new EKey(hKey.method, dirKey, stable, false), result));
                    if (!(result instanceof Pending)) continue;
                    Pending pending = (Pending)result;
                    for (Component component : pending.delta) {
                        for (EKey depKey : component.ids) {
                            if (queued.contains(depKey)) continue;
                            queue.push(depKey);
                            queued.add(depKey);
                        }
                    }
                }
            }
        }
    }

    private void collectSingleEquation(EKey hKey, Solver solver) throws EquationsLimitException {
        ProgressManager.checkCanceled();
        for (Equations equations : this.myEquationProvider.getEquations(hKey.method)) {
            boolean stable = equations.stable;
            for (DirectionResultPair pair : equations.results) {
                int dirKey = pair.directionKey;
                if (dirKey != hKey.dirKey) continue;
                Result result = pair.result;
                solver.addEquation(new Equation(new EKey(hKey.method, dirKey, stable, false), result));
            }
        }
    }

    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "createAnnotationFromText"));
        }
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory(this.myProject).createAnnotationFromText(text2, null);
        annotation.putUserData(INFERRED_ANNOTATION, Boolean.TRUE);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        PsiAnnotation psiAnnotation = annotation;
        if (psiAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "createAnnotationFromText"));
        }
        return psiAnnotation;
    }

    static class IndexedEquationProvider
    extends EquationProvider<HMethod> {
        IndexedEquationProvider(Project project) {
            super(project);
        }

        @Override
        public EKey adaptKey(@NotNull EKey key, MessageDigest messageDigest) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis$IndexedEquationProvider", "adaptKey"));
            }
            return key.hashed(messageDigest);
        }

        @Override
        public List<Equations> getEquations(MethodDescriptor method) {
            HMethod key = method.hashed(null);
            return this.myEquationCache.computeIfAbsent(key, m -> BytecodeAnalysisIndex.getEquations(ProjectScope.getLibrariesScope(this.myProject), m));
        }
    }

    static class PlainEquationProvider
    extends EquationProvider<Method> {
        PlainEquationProvider(Project project) {
            super(project);
        }

        @Override
        public EKey adaptKey(@NotNull EKey key, MessageDigest messageDigest) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis$PlainEquationProvider", "adaptKey"));
            }
            assert (key.method instanceof Method);
            return key;
        }

        @Override
        public List<Equations> getEquations(MethodDescriptor methodDescriptor) {
            assert (methodDescriptor instanceof Method);
            Method method = (Method)methodDescriptor;
            List<Equations> equations = (List<Equations>)this.myEquationCache.get(method);
            return equations == null ? this.loadEquations(method) : equations;
        }

        private VirtualFile findClassFile(String internalClassName) {
            String packageName = StringUtil.getPackageName(internalClassName, '/').replace('/', '.');
            String className = StringUtil.getShortName(internalClassName, '/');
            PsiPackage aPackage = JavaPsiFacade.getInstance(this.myProject).findPackage(packageName);
            if (aPackage == null) {
                PsiModifierListOwner compiledClass;
                PsiClass psiClass = JavaPsiFacade.getInstance(this.myProject).findClass(StringUtil.getQualifiedName(packageName, className), GlobalSearchScope.allScope(this.myProject));
                if (psiClass != null && (compiledClass = PsiUtil.preferCompiledElement(psiClass)) instanceof ClsClassImpl) {
                    return compiledClass.getContainingFile().getVirtualFile();
                }
                return null;
            }
            String classFileName = className + ".class";
            for (PsiDirectory directory : aPackage.getDirectories()) {
                VirtualFile file = directory.getVirtualFile().findChild(classFileName);
                if (file == null) continue;
                return file;
            }
            return null;
        }

        private List<Equations> loadEquations(Method method) {
            VirtualFile file = this.findClassFile(method.internalClassName);
            if (file == null) {
                return Collections.emptyList();
            }
            try {
                Map<EKey, Equations> map = ClassDataIndexer.processClass(new ClassReader(file.contentsToByteArray(false)), file.getPresentableUrl());
                Map groups = EntryStream.of(map).mapKeys(key -> (Method)key.method).grouping();
                this.myEquationCache.putAll(groups);
                return groups.getOrDefault(method, Collections.emptyList());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    static abstract class EquationProvider<T extends MethodDescriptor> {
        final Map<T, List<Equations>> myEquationCache = ContainerUtil.createConcurrentSoftValueMap();
        final Project myProject;

        EquationProvider(Project project) {
            this.myProject = project;
            project.getMessageBus().connect().subscribe(PsiModificationTracker.TOPIC, () -> this.myEquationCache.clear());
        }

        abstract EKey adaptKey(@NotNull EKey var1, MessageDigest var2);

        abstract List<Equations> getEquations(MethodDescriptor var1);
    }
}

