/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.customRegions;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionTreeElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRegionStructureUtil {
    public static Collection<StructureViewTreeElement> groupByCustomRegions(@NotNull PsiElement rootElement, @NotNull Collection<StructureViewTreeElement> originalElements) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil", "groupByCustomRegions"));
        }
        if (originalElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElements", "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil", "groupByCustomRegions"));
        }
        if (rootElement instanceof StubBasedPsiElement && ((StubBasedPsiElement)rootElement).getStub() != null) {
            return originalElements;
        }
        Set<TextRange> childrenRanges = ContainerUtil.map2SetNotNull(originalElements, element -> {
            Object value = element.getValue();
            return value instanceof PsiElement ? CustomRegionStructureUtil.getTextRange((PsiElement)value) : null;
        });
        Collection<CustomRegionTreeElement> customRegions = CustomRegionStructureUtil.collectCustomRegions(rootElement, childrenRanges);
        if (customRegions.size() > 0) {
            ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
            result.addAll(customRegions);
            for (StructureViewTreeElement element2 : originalElements) {
                boolean isInCustomRegion = false;
                for (CustomRegionTreeElement customRegion : customRegions) {
                    if (!customRegion.containsElement(element2)) continue;
                    customRegion.addChild(element2);
                    isInCustomRegion = true;
                    break;
                }
                if (isInCustomRegion) continue;
                result.add(element2);
            }
            return result;
        }
        return originalElements;
    }

    private static TextRange getTextRange(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil", "getTextRange"));
        }
        PsiElement first = element.getFirstChild();
        if (first instanceof PsiComment && !first.textContains('\n')) {
            PsiElement next = first.getNextSibling();
            if (next instanceof PsiWhiteSpace) {
                next = next.getNextSibling();
            }
            if (next != null) {
                return new TextRange(next.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
            }
        }
        return element.getTextRange();
    }

    private static Collection<CustomRegionTreeElement> collectCustomRegions(@NotNull PsiElement rootElement, @NotNull Set<TextRange> ranges) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil", "collectCustomRegions"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil", "collectCustomRegions"));
        }
        Iterator iterator = ((SyntaxTraverser)SyntaxTraverser.psiTraverser(rootElement).filter(element -> {
            if (ranges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil", "lambda$collectCustomRegions$1"));
            }
            return CustomRegionStructureUtil.isCustomRegionCommentCandidate(element) && !CustomRegionStructureUtil.isInsideRanges(element, ranges);
        })).iterator();
        List<CustomRegionTreeElement> customRegions = ContainerUtil.newSmartList();
        CustomRegionTreeElement currRegionElement = null;
        CustomFoldingProvider provider = null;
        while (iterator.hasNext()) {
            PsiElement child = (PsiElement)iterator.next();
            if (provider == null) {
                provider = CustomRegionStructureUtil.getProvider(child);
            }
            if (provider == null) continue;
            String commentText = child.getText();
            if (provider.isCustomRegionStart(commentText)) {
                if (currRegionElement == null) {
                    currRegionElement = new CustomRegionTreeElement(child, provider);
                    customRegions.add(currRegionElement);
                    continue;
                }
                currRegionElement = currRegionElement.createNestedRegion(child);
                continue;
            }
            if (!provider.isCustomRegionEnd(commentText) || currRegionElement == null) continue;
            currRegionElement = currRegionElement.endRegion(child);
        }
        return customRegions;
    }

    @Nullable
    static CustomFoldingProvider getProvider(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil", "getProvider"));
        }
        ASTNode node = element.getNode();
        if (node != null) {
            for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
                if (!provider.isCustomRegionStart(node.getText())) continue;
                return provider;
            }
        }
        return null;
    }

    private static boolean isInsideRanges(@NotNull PsiElement element, @NotNull Set<TextRange> ranges) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil", "isInsideRanges"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil", "isInsideRanges"));
        }
        for (TextRange range : ranges) {
            TextRange elementRange;
            if (!range.contains((elementRange = element.getTextRange()).getStartOffset()) && !range.contains(elementRange.getEndOffset())) continue;
            return true;
        }
        return false;
    }

    private static boolean isCustomRegionCommentCandidate(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil", "isCustomRegionCommentCandidate"));
        }
        Language language = element.getLanguage();
        if (!Language.ANY.is(language)) {
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder instanceof CustomFoldingBuilder) {
                return ((CustomFoldingBuilder)foldingBuilder).isCustomFoldingCandidate(element);
            }
            if (foldingBuilder instanceof CompositeFoldingBuilder) {
                for (FoldingBuilder simpleBuilder : ((CompositeFoldingBuilder)foldingBuilder).getAllBuilders()) {
                    if (!(simpleBuilder instanceof CustomFoldingBuilder) || !((CustomFoldingBuilder)simpleBuilder).isCustomFoldingCandidate(element)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

