/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleRootModificationUtil {
    public static void addContentRoot(@NotNull Module module, @NotNull String path) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addContentRoot"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addContentRoot"));
        }
        ModuleRootModificationUtil.updateModel(module, model -> {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$addContentRoot$0"));
            }
            model.addContentEntry(VfsUtilCore.pathToUrl(path));
        });
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, DependencyScope.COMPILE);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots, @NotNull DependencyScope scope) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, Collections.emptyList(), scope);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots, @NotNull List<String> excludedRoots, @NotNull DependencyScope scope) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (excludedRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, excludedRoots, scope, false);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots, @NotNull List<String> excludedRoots, @NotNull DependencyScope scope, boolean exported) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (excludedRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        ModuleRootModificationUtil.updateModel(module, model -> {
            if (classesRoots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$addModuleLibrary$2"));
            }
            if (sourceRoots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$addModuleLibrary$2"));
            }
            if (excludedRoots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedRoots", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$addModuleLibrary$2"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$addModuleLibrary$2"));
            }
            LibraryEx library = (LibraryEx)model.getModuleLibraryTable().createLibrary(libName);
            LibraryEx.ModifiableModelEx libraryModel = library.getModifiableModel();
            for (String root : classesRoots) {
                libraryModel.addRoot(root, OrderRootType.CLASSES);
            }
            for (String root : sourceRoots) {
                libraryModel.addRoot(root, OrderRootType.SOURCES);
            }
            for (String excluded : excludedRoots) {
                libraryModel.addExcludedRoot(excluded);
            }
            LibraryOrderEntry entry = model.findLibraryOrderEntry(library);
            assert (entry != null) : library;
            entry.setScope(scope);
            entry.setExported(exported);
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(libraryModel::commit));
        });
    }

    public static void addModuleLibrary(@NotNull Module module, @NotNull String classesRootUrl) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        if (classesRootUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRootUrl", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addModuleLibrary"));
        }
        ModuleRootModificationUtil.addModuleLibrary(module, null, Collections.singletonList(classesRootUrl), Collections.emptyList());
    }

    public static void addDependency(@NotNull Module module, @NotNull Library library) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addDependency"));
        }
        ModuleRootModificationUtil.addDependency(module, library, DependencyScope.COMPILE, false);
    }

    public static void addDependency(@NotNull Module module, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addDependency"));
        }
        ModuleRootModificationUtil.updateModel(module, model -> {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$addDependency$3"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$addDependency$3"));
            }
            LibraryOrderEntry entry = model.addLibraryEntry(library);
            entry.setExported(exported);
            entry.setScope(scope);
        });
    }

    public static void setModuleSdk(@NotNull Module module, @Nullable Sdk sdk) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "setModuleSdk"));
        }
        ModuleRootModificationUtil.updateModel(module, model -> model.setSdk(sdk));
    }

    public static void setSdkInherited(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "setSdkInherited"));
        }
        ModuleRootModificationUtil.updateModel(module, model -> model.inheritSdk());
    }

    public static void addDependency(@NotNull Module from, @NotNull Module to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addDependency"));
        }
        ModuleRootModificationUtil.addDependency(from, to, DependencyScope.COMPILE, false);
    }

    public static void addDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope, boolean exported) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/ModuleRootModificationUtil", "addDependency"));
        }
        ModuleRootModificationUtil.updateModel(from, model -> {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$addDependency$6"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$addDependency$6"));
            }
            ModuleOrderEntry entry = model.addModuleOrderEntry(to);
            entry.setScope(scope);
            entry.setExported(exported);
        });
    }

    public static void updateModel(@NotNull Module module, @NotNull Consumer<ModifiableRootModel> task) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "updateModel"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/roots/ModuleRootModificationUtil", "updateModel"));
        }
        ModifiableRootModel model = ReadAction.compute(() -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$updateModel$7"));
            }
            return ModuleRootManager.getInstance(module).getModifiableModel();
        });
        try {
            task.consume(model);
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(model::commit));
        }
        finally {
            if (!model.isDisposed()) {
                model.dispose();
            }
        }
    }

    public static void updateExcludedFolders(@NotNull Module module, @NotNull VirtualFile contentRoot, @NotNull Collection<String> urlsToUnExclude, @NotNull Collection<String> urlsToExclude) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "updateExcludedFolders"));
        }
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/intellij/openapi/roots/ModuleRootModificationUtil", "updateExcludedFolders"));
        }
        if (urlsToUnExclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlsToUnExclude", "com/intellij/openapi/roots/ModuleRootModificationUtil", "updateExcludedFolders"));
        }
        if (urlsToExclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlsToExclude", "com/intellij/openapi/roots/ModuleRootModificationUtil", "updateExcludedFolders"));
        }
        ModuleRootModificationUtil.updateModel(module, modifiableModel -> {
            if (contentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$updateExcludedFolders$9"));
            }
            if (urlsToUnExclude == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlsToUnExclude", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$updateExcludedFolders$9"));
            }
            if (urlsToExclude == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlsToExclude", "com/intellij/openapi/roots/ModuleRootModificationUtil", "lambda$updateExcludedFolders$9"));
            }
            for (ContentEntry contentEntry : modifiableModel.getContentEntries()) {
                if (!contentRoot.equals(contentEntry.getFile())) continue;
                for (String url : urlsToUnExclude) {
                    contentEntry.removeExcludeFolder(url);
                }
                for (String url : urlsToExclude) {
                    contentEntry.addExcludeFolder(url);
                }
                break;
            }
        });
    }
}

