/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.ConstructorReferencesSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class ConstructorReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    @Override
    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/ConstructorReferencesSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/ConstructorReferencesSearcher", "processQuery"));
        }
        PsiElement element = p.getElementToSearch();
        if (!(element instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)element;
        PsiManager[] manager = new PsiManager[1];
        PsiClass aClass = ReadAction.compute(() -> {
            if (!method.isConstructor()) {
                return null;
            }
            PsiClass aClass1 = method.getContainingClass();
            manager[0] = aClass1 == null ? null : aClass1.getManager();
            return aClass1;
        });
        if (manager[0] == null) {
            return;
        }
        SearchScope scope = ReadAction.compute(() -> {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/ConstructorReferencesSearcher", "lambda$processQuery$1"));
            }
            return p.getEffectiveSearchScope();
        });
        new ConstructorReferencesSearchHelper(manager[0]).processConstructorReferences(consumer, method, aClass, scope, p.getProject(), p.isIgnoreAccessScope(), true, p.getOptimizer());
    }
}

