/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlEntityRefImpl
extends XmlElementImpl
implements XmlEntityRef {
    @NonNls
    private static final String GT_ENTITY = "&gt;";
    @NonNls
    private static final String QUOT_ENTITY = "&quot;";
    private static final Key<Boolean> DISABLE_ENTITY_EXPAND = Key.create("disable.entity.expand");

    public XmlEntityRefImpl() {
        super(XmlElementType.XML_ENTITY_REF);
    }

    @Override
    public XmlEntityDecl resolve(PsiFile targetFile) {
        String text2 = this.getText();
        if (text2.equals(GT_ENTITY) || text2.equals(QUOT_ENTITY)) {
            return null;
        }
        return XmlEntityRefImpl.resolveEntity(this, text2, targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlEntityDecl resolveEntity(XmlElement element, String text2, PsiFile targetFile) {
        CachedValue<XmlEntityDecl> value;
        XmlDocument document;
        if (targetFile instanceof XmlFile && (document = ((XmlFile)targetFile).getDocument()) != null && document.getUserData(DISABLE_ENTITY_EXPAND) != null) {
            return null;
        }
        String entityName = text2.substring(1, text2.length() - 1);
        PsiElement targetElement = targetFile != null ? targetFile : element;
        Object object = XmlEntityCache.LOCK;
        synchronized (object) {
            Map<String, CachedValue<XmlEntityDecl>> map = XmlEntityCache.getCachingMap(targetElement);
            value = map.get(entityName);
            PsiFile containingFile = element.getContainingFile();
            if (value == null) {
                PsiManager manager = element.getManager();
                if (manager == null) {
                    return XmlEntityRefImpl.doResolveEntity(targetElement, entityName, containingFile).getValue();
                }
                value = CachedValuesManager.getManager(manager.getProject()).createCachedValue(() -> XmlEntityRefImpl.doResolveEntity(targetElement, entityName, containingFile));
                map.put(entityName, value);
            }
        }
        return value.getValue();
    }

    private static CachedValueProvider.Result<XmlEntityDecl> doResolveEntity(final PsiElement targetElement, final String entityName, final PsiFile contextFile) {
        return RecursionManager.doPreventingRecursion(targetElement, true, new Computable<CachedValueProvider.Result<XmlEntityDecl>>(){

            @Override
            public CachedValueProvider.Result<XmlEntityDecl> compute() {
                final ArrayList<PsiFile> deps = new ArrayList<PsiFile>();
                final XmlEntityDecl[] result = new XmlEntityDecl[]{null};
                PsiElementProcessor processor = new PsiElementProcessor(){

                    public boolean execute(@NotNull PsiElement element) {
                        XmlEntityDecl entityDecl;
                        String declName;
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlEntityRefImpl$1$1", "execute"));
                        }
                        if (element instanceof XmlDoctype) {
                            XmlMarkupDecl markupDecl;
                            XmlDoctype xmlDoctype = (XmlDoctype)element;
                            String dtdUri = XmlEntityRefImpl.getDtdForEntity(xmlDoctype);
                            if (dtdUri != null) {
                                XmlFile file = XmlUtil.getContainingFile(element);
                                if (file == null) {
                                    return true;
                                }
                                XmlFile xmlFile = XmlUtil.findNamespace(file, dtdUri);
                                if (xmlFile != null && xmlFile != targetElement) {
                                    deps.add(xmlFile);
                                    if (!XmlUtil.processXmlElements(xmlFile, this, true)) {
                                        return false;
                                    }
                                }
                            }
                            if ((markupDecl = xmlDoctype.getMarkupDecl()) != null && !XmlUtil.processXmlElements(markupDecl, this, true)) {
                                return false;
                            }
                        } else if (element instanceof XmlEntityDecl && StringUtil.equals(declName = (entityDecl = (XmlEntityDecl)element).getName(), entityName)) {
                            result[0] = entityDecl;
                            return false;
                        }
                        return true;
                    }
                };
                FileViewProvider provider = targetElement.getContainingFile().getViewProvider();
                deps.add(provider.getPsi(provider.getBaseLanguage()));
                boolean notfound = PsiTreeUtil.processElements(targetElement, processor);
                if (notfound && contextFile != targetElement && contextFile != null && contextFile.isValid()) {
                    notfound = PsiTreeUtil.processElements(contextFile, processor);
                }
                if (notfound && targetElement instanceof XmlFile && deps.size() == 1 && ((XmlFile)targetElement).getFileType() != DTDFileType.INSTANCE) {
                    XmlElementDescriptor descriptor;
                    XmlDocument document = ((XmlFile)targetElement).getDocument();
                    XmlTag rootTag = document != null ? document.getRootTag() : null;
                    XmlFile descriptorFile = null;
                    if (HtmlUtil.isHtml5Document(document)) {
                        descriptorFile = XmlUtil.findXmlFile((XmlFile)targetElement, Html5SchemaProvider.getCharsDtdLocation());
                    } else if (rootTag != null && document.getUserData(DISABLE_ENTITY_EXPAND) == null && (descriptor = rootTag.getDescriptor()) != null && !(descriptor instanceof AnyXmlElementDescriptor)) {
                        PsiElement element = descriptor.getDeclaration();
                        PsiFile containingFile = element != null ? element.getContainingFile() : null;
                        XmlFile xmlFile = descriptorFile = containingFile instanceof XmlFile ? (XmlFile)containingFile : null;
                    }
                    if (descriptorFile != null && !descriptorFile.getName().equals(((XmlFile)targetElement).getName() + ".dtd")) {
                        deps.add(descriptorFile);
                        XmlUtil.processXmlElements(descriptorFile, processor, true);
                    }
                }
                return new CachedValueProvider.Result<XmlEntityDecl>(result[0], ArrayUtil.toObjectArray(deps));
            }
        });
    }

    private static String getDtdForEntity(XmlDoctype xmlDoctype) {
        return HtmlUtil.isHtml5Doctype(xmlDoctype) ? Html5SchemaProvider.getCharsDtdLocation() : XmlUtil.getDtdUri(xmlDoctype);
    }

    @Override
    public XmlTag getParentTag() {
        XmlElement parent = (XmlElement)this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    @Override
    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    @Override
    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlEntityRefImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/xml/XmlEntityRefImpl", "accept"));
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    public static void setNoEntityExpandOutOfDocument(XmlDocument doc, boolean b) {
        if (b) {
            doc.putUserData(DISABLE_ENTITY_EXPAND, Boolean.TRUE);
        } else {
            doc.putUserData(DISABLE_ENTITY_EXPAND, null);
        }
    }
}

