/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.List;
import java.util.RandomAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stack<T>
extends ArrayList<T> {
    public Stack() {
    }

    public Stack(int initialCapacity) {
        super(initialCapacity);
    }

    public Stack(@NotNull Collection<T> init) {
        if (init == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "init", "com/intellij/util/containers/Stack", "<init>"));
        }
        super(init);
    }

    public Stack(T ... items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/containers/Stack", "<init>"));
        }
        for (T item : items) {
            this.push(item);
        }
    }

    public void push(T t) {
        this.add(t);
    }

    public T peek() {
        int size = this.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return (T)this.get(size - 1);
    }

    public T pop() {
        int size = this.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return (T)this.remove(size - 1);
    }

    @Nullable
    public T tryPop() {
        return this.isEmpty() ? null : (T)this.pop();
    }

    public boolean empty() {
        return this.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof RandomAccess && o instanceof List) {
            List other = (List)o;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i2 = 0; i2 < other.size(); ++i2) {
                Object o1 = other.get(i2);
                Object o2 = this.get(i2);
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return true;
        }
        return super.equals(o);
    }
}

