/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.MapBackedFMap;
import com.intellij.util.keyFMap.OneElementFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import org.jetbrains.annotations.NotNull;

public class ArrayBackedFMap
implements KeyFMap {
    static final int ARRAY_THRESHOLD = 8;
    private final int[] keys;
    private final Object[] values;

    ArrayBackedFMap(@NotNull int[] keys, @NotNull Object[] values) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/util/keyFMap/ArrayBackedFMap", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/keyFMap/ArrayBackedFMap", "<init>"));
        }
        this.keys = keys;
        this.values = values;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
        }
        int keyCode = key.hashCode();
        int keyPos = this.indexOf(keyCode);
        if (keyPos >= 0) {
            if (this.values[keyPos] == value) {
                ArrayBackedFMap arrayBackedFMap = this;
                if (arrayBackedFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
                }
                return arrayBackedFMap;
            }
            Object[] newValues = (Object[])this.values.clone();
            newValues[keyPos] = value;
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(this.keys, newValues);
            if (arrayBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
            }
            return arrayBackedFMap;
        }
        if (this.size() < 8) {
            int[] newKeys = ArrayUtil.insert(this.keys, -keyPos - 1, keyCode);
            Object[] newValues = ArrayUtil.insert(this.values, -keyPos - 1, value);
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(newKeys, newValues);
            if (arrayBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
            }
            return arrayBackedFMap;
        }
        MapBackedFMap mapBackedFMap = new MapBackedFMap(this.keys, keyCode, this.values, value);
        if (mapBackedFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "plus"));
        }
        return mapBackedFMap;
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    private int indexOf(int keyCode) {
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            int key = this.keys[i2];
            if (key == keyCode) {
                return i2;
            }
            if (key <= keyCode) continue;
            return -i2 - 1;
        }
        return -this.keys.length - 1;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
        }
        int i2 = this.indexOf(key.hashCode());
        if (i2 >= 0) {
            if (this.size() == 3) {
                int i1 = (2 - i2) / 2;
                int i22 = 3 - (i2 + 2) / 2;
                Key key1 = Key.getKeyByIndex(this.keys[i1]);
                Key key2 = Key.getKeyByIndex(this.keys[i22]);
                if (key1 == null && key2 == null) {
                    KeyFMap keyFMap = EMPTY_MAP;
                    if (keyFMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
                    }
                    return keyFMap;
                }
                if (key1 == null) {
                    OneElementFMap oneElementFMap = new OneElementFMap(key2, this.values[i22]);
                    if (oneElementFMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
                    }
                    return oneElementFMap;
                }
                if (key2 == null) {
                    OneElementFMap oneElementFMap = new OneElementFMap(key1, this.values[i1]);
                    if (oneElementFMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
                    }
                    return oneElementFMap;
                }
                PairElementsFMap pairElementsFMap = new PairElementsFMap(key1, this.values[i1], key2, this.values[i22]);
                if (pairElementsFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
                }
                return pairElementsFMap;
            }
            int[] newKeys = ArrayUtil.remove(this.keys, i2);
            Object[] newValues = ArrayUtil.remove(this.values, i2, ArrayUtil.OBJECT_ARRAY_FACTORY);
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(newKeys, newValues);
            if (arrayBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
            }
            return arrayBackedFMap;
        }
        ArrayBackedFMap arrayBackedFMap = this;
        if (arrayBackedFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "minus"));
        }
        return arrayBackedFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/keyFMap/ArrayBackedFMap", "get"));
        }
        int i2 = this.indexOf(key.hashCode());
        return (V)(i2 < 0 ? null : this.values[i2]);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            int key = this.keys[i2];
            Object value = this.values[i2];
            s.append(s.length() == 1 ? "" : ", ").append(Key.getKeyByIndex(key)).append("=").append(value);
        }
        return s.append("}").toString();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getValueIdentityHashCode() {
        int hash = 0;
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            hash = hash * 31 + this.keys[i2];
            hash = hash * 31 + System.identityHashCode(this.values[i2]);
        }
        return hash;
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        Key[] keyArray = ArrayBackedFMap.getKeysByIndices(this.keys);
        if (keyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "getKeys"));
        }
        return keyArray;
    }

    @NotNull
    static Key[] getKeysByIndices(int[] indexes) {
        Key[] result = new Key[indexes.length];
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            result[i2] = Key.getKeyByIndex(indexes[i2]);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/ArrayBackedFMap", "getKeysByIndices"));
        }
        return result;
    }

    public int hashCode() {
        int hash = 0;
        int length = this.keys.length;
        for (int i2 = 0; i2 < length; ++i2) {
            hash += this.keys[i2] ^ this.values[i2].hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayBackedFMap)) {
            return false;
        }
        ArrayBackedFMap map = (ArrayBackedFMap)o;
        if (map.size() != this.size()) {
            return false;
        }
        int length = this.keys.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.keys[i2] == map.keys[i2] && this.values[i2].equals(map.values[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsByReference(KeyFMap o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayBackedFMap)) {
            return false;
        }
        ArrayBackedFMap map = (ArrayBackedFMap)o;
        if (map.size() != this.size()) {
            return false;
        }
        int length = this.keys.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.keys[i2] == map.keys[i2] && this.values[i2] == map.values[i2]) continue;
            return false;
        }
        return true;
    }
}

