/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

abstract class BaseEqualsVisitor
extends BaseInspectionVisitor {
    private static final CallMatcher OBJECT_EQUALS = CallMatcher.instanceCall("java.lang.Object", "equals").parameterTypes("java.lang.Object");
    private static final CallMatcher STATIC_EQUALS = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2), CallMatcher.staticCall("com.google.common.base.Objects", "equal").parameterCount(2));

    BaseEqualsVisitor() {
    }

    @Override
    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        super.visitMethodReferenceExpression(expression);
        if (!OBJECT_EQUALS.methodReferenceMatches(expression) && !STATIC_EQUALS.methodReferenceMatches(expression)) {
            return;
        }
        PsiMethod method = ObjectUtils.tryCast(expression.resolve(), PsiMethod.class);
        if (method == null) {
            return;
        }
        PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
        if (functionalInterfaceType == null) {
            return;
        }
        PsiExpression qualifier = expression.getQualifierExpression();
        PsiType type1 = LambdaUtil.getLambdaParameterFromType(functionalInterfaceType, 0);
        PsiType type2 = qualifier == null || qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).isReferenceTo(method.getContainingClass()) ? LambdaUtil.getLambdaParameterFromType(functionalInterfaceType, 1) : qualifier.getType();
        this.checkTypes(expression, type1, type2);
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        boolean staticEqualsCall;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/BaseEqualsVisitor", "visitMethodCallExpression"));
        }
        super.visitMethodCallExpression(expression);
        if (OBJECT_EQUALS.test(expression)) {
            staticEqualsCall = false;
        } else if (STATIC_EQUALS.test(expression)) {
            staticEqualsCall = true;
        } else {
            return;
        }
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        PsiExpression expression1 = arguments[0];
        PsiExpression expression2 = staticEqualsCall ? arguments[1] : ExpressionUtils.getQualifierOrThis(expression.getMethodExpression());
        this.checkTypes(expression.getMethodExpression(), expression1.getType(), expression2.getType());
    }

    abstract void checkTypes(PsiReferenceExpression var1, PsiType var2, PsiType var3);
}

