/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessNullCheckInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessNullCheckInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean before = (Boolean)infos[1];
        String string = InspectionGadgetsBundle.message(before != false ? "pointless.nullcheck.problem.descriptor" : "pointless.nullcheck.after.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessNullCheckInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessNullCheckVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        return new PointlessNullCheckFix(expression.getText());
    }

    private static class PointlessNullCheckVisitor
    extends BaseInspectionVisitor {
        private PointlessNullCheckVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            block5: {
                IElementType operationTokenType;
                block4: {
                    super.visitPolyadicExpression(expression);
                    operationTokenType = expression.getOperationTokenType();
                    if (!operationTokenType.equals(JavaTokenType.ANDAND)) break block4;
                    PsiExpression[] operands = expression.getOperands();
                    for (int i2 = 0; i2 < operands.length - 1; ++i2) {
                        for (int j = i2 + 1; j < operands.length; ++j) {
                            if (!this.checkAndedExpressions(operands, i2, j)) continue;
                            return;
                        }
                    }
                    break block5;
                }
                if (!operationTokenType.equals(JavaTokenType.OROR)) break block5;
                PsiExpression[] operands = expression.getOperands();
                for (int i3 = 0; i3 < operands.length - 1; ++i3) {
                    for (int j = i3 + 1; j < operands.length; ++j) {
                        if (!this.checkOrredExpressions(operands, i3, j)) continue;
                        return;
                    }
                }
            }
        }

        public boolean checkOrredExpressions(PsiExpression[] operands, int i2, int j) {
            boolean checkRef;
            PsiBinaryExpression binaryExpression;
            PsiPrefixExpression prefixExpression;
            PsiExpression lhs = ParenthesesUtils.stripParentheses(operands[i2]);
            PsiExpression rhs = ParenthesesUtils.stripParentheses(operands[j]);
            if (lhs instanceof PsiBinaryExpression && rhs instanceof PsiPrefixExpression) {
                prefixExpression = (PsiPrefixExpression)rhs;
                binaryExpression = (PsiBinaryExpression)lhs;
                checkRef = true;
            } else if (rhs instanceof PsiBinaryExpression && lhs instanceof PsiPrefixExpression) {
                prefixExpression = (PsiPrefixExpression)lhs;
                binaryExpression = (PsiBinaryExpression)rhs;
                checkRef = false;
            } else {
                return false;
            }
            IElementType prefixTokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.EXCL.equals(prefixTokenType)) {
                return false;
            }
            PsiExpression possibleInstanceofExpression = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ)) {
                return false;
            }
            PsiVariable variable = PointlessNullCheckVisitor.checkExpressions(binaryExpression, possibleInstanceofExpression);
            if (variable == null || checkRef && PointlessNullCheckVisitor.isVariableUsed(operands, i2, j, variable)) {
                return false;
            }
            this.registerError((PsiElement)binaryExpression, binaryExpression, checkRef);
            return true;
        }

        public boolean checkAndedExpressions(PsiExpression[] operands, int i2, int j) {
            boolean checkRef;
            PsiExpression possibleInstanceofExpression;
            PsiBinaryExpression binaryExpression;
            PsiExpression lhs = ParenthesesUtils.stripParentheses(operands[i2]);
            PsiExpression rhs = ParenthesesUtils.stripParentheses(operands[j]);
            if (lhs instanceof PsiBinaryExpression) {
                binaryExpression = (PsiBinaryExpression)lhs;
                possibleInstanceofExpression = rhs;
                checkRef = true;
            } else if (rhs instanceof PsiBinaryExpression) {
                binaryExpression = (PsiBinaryExpression)rhs;
                possibleInstanceofExpression = lhs;
                checkRef = false;
            } else {
                return false;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.NE)) {
                return false;
            }
            PsiVariable variable = PointlessNullCheckVisitor.checkExpressions(binaryExpression, possibleInstanceofExpression);
            if (variable == null || checkRef && PointlessNullCheckVisitor.isVariableUsed(operands, i2, j, variable)) {
                return false;
            }
            this.registerError((PsiElement)binaryExpression, binaryExpression, checkRef);
            return true;
        }

        private static boolean isVariableUsed(PsiExpression[] operands, int i2, int j, PsiVariable variable) {
            ++i2;
            while (i2 < j) {
                if (VariableAccessUtils.variableIsUsed(variable, operands[i2])) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        public static PsiVariable checkExpressions(PsiBinaryExpression binaryExpression, PsiExpression possibleInstanceofExpression) {
            PsiReferenceExpression referenceExpression1 = PointlessNullCheckVisitor.getReferenceFromNullCheck(binaryExpression);
            if (referenceExpression1 == null) {
                return null;
            }
            PsiElement target1 = referenceExpression1.resolve();
            if (!(target1 instanceof PsiVariable)) {
                return null;
            }
            PsiVariable variable = (PsiVariable)target1;
            PsiReferenceExpression referenceExpression2 = PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(possibleInstanceofExpression);
            if (referenceExpression2 == null || !referenceExpression2.isReferenceTo(variable)) {
                return null;
            }
            return variable;
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromNullCheck(PsiBinaryExpression expression) {
            PsiExpression lhs = ParenthesesUtils.stripParentheses(expression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(expression.getROperand());
            if (lhs instanceof PsiReferenceExpression) {
                if (!(rhs instanceof PsiLiteralExpression) || !PsiType.NULL.equals(rhs.getType())) {
                    return null;
                }
                return (PsiReferenceExpression)lhs;
            }
            if (rhs instanceof PsiReferenceExpression) {
                if (!(lhs instanceof PsiLiteralExpression) || !PsiType.NULL.equals(lhs.getType())) {
                    return null;
                }
                return (PsiReferenceExpression)rhs;
            }
            return null;
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromInstanceofExpression(PsiExpression expression) {
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                return PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(parenthesizedExpression.getExpression());
            }
            if (expression instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
                PsiExpression operand = ParenthesesUtils.stripParentheses(instanceOfExpression.getOperand());
                if (!(operand instanceof PsiReferenceExpression)) {
                    return null;
                }
                return (PsiReferenceExpression)operand;
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                if (JavaTokenType.OROR != tokenType) {
                    return null;
                }
                PsiExpression[] operands = polyadicExpression.getOperands();
                PsiReferenceExpression referenceExpression = PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(operands[0]);
                if (referenceExpression == null) {
                    return null;
                }
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)target;
                int operandsLength = operands.length;
                for (int i2 = 1; i2 < operandsLength; ++i2) {
                    PsiReferenceExpression reference2 = PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(operands[i2]);
                    if (reference2 != null && reference2.isReferenceTo(variable)) continue;
                    return null;
                }
                return referenceExpression;
            }
            return null;
        }
    }

    private static class PointlessNullCheckFix
    extends InspectionGadgetsFix {
        private final String myExpressionText;

        public PointlessNullCheckFix(String expressionText) {
            this.myExpressionText = expressionText;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("pointless.nullcheck.simplify.quickfix", this.myExpressionText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessNullCheckInspection$PointlessNullCheckFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessNullCheckInspection$PointlessNullCheckFix", "getFamilyName"));
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiPolyadicExpression polyadicExpression = PsiTreeUtil.getParentOfType(element, PsiPolyadicExpression.class);
            if (polyadicExpression == null) {
                return;
            }
            StringBuilder replacement = new StringBuilder();
            PsiElement anchor = polyadicExpression.getFirstChild();
            if (!(anchor instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)anchor;
            boolean hasText = false;
            while (expression != null) {
                if (PsiTreeUtil.isAncestor(expression, element, false)) {
                    while (anchor != expression) {
                        if (hasText && anchor instanceof PsiComment) {
                            replacement.append(anchor.getText());
                        }
                        anchor = anchor.getNextSibling();
                    }
                    anchor = expression.getNextSibling();
                } else {
                    while (anchor != expression) {
                        if (hasText) {
                            replacement.append(anchor.getText());
                        }
                        anchor = anchor.getNextSibling();
                    }
                    replacement.append(expression.getText());
                    hasText = true;
                    anchor = expression.getNextSibling();
                }
                expression = PsiTreeUtil.getNextSiblingOfType(anchor, PsiExpression.class);
            }
            PsiReplacementUtil.replaceExpression(polyadicExpression, replacement.toString());
        }
    }
}

