/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.JavaSoftKeywordHighlightingVisitor;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiJavaFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/daemon/impl/JavaSoftKeywordHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiJavaFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/psi/PsiJavaFile;Lcom/intellij/openapi/editor/Document;)V", "results", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "java-analysis-impl"})
final class JavaSoftKeywordHighlightingPass
extends TextEditorHighlightingPass {
    private final List<HighlightInfo> results;
    private final PsiJavaFile file;

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkParameterIsNotNull((Object)progress, (String)"progress");
        LanguageLevel languageLevel = this.file.getLanguageLevel();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)languageLevel), (String)"file.languageLevel");
        this.file.accept(new JavaSoftKeywordHighlightingVisitor(this.results, languageLevel));
    }

    @Override
    public void doApplyInformationToEditor() {
        Document document = this.myDocument;
        if (document == null) {
            Intrinsics.throwNpe();
        }
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, document, 0, this.file.getTextLength(), (Collection<HighlightInfo>)this.results, this.getColorsScheme(), this.getId());
    }

    public JavaSoftKeywordHighlightingPass(@NotNull PsiJavaFile file, @NotNull Document document) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        super(file.getProject(), document);
        this.file = file;
        JavaSoftKeywordHighlightingPass javaSoftKeywordHighlightingPass = this;
        javaSoftKeywordHighlightingPass.results = list = (List)new ArrayList();
    }
}

