/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaFactMap {
    public static final DfaFactMap EMPTY = new DfaFactMap(KeyFMap.EMPTY_MAP);
    @NotNull
    private final KeyFMap myMap;

    private DfaFactMap(@NotNull KeyFMap map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/codeInspection/dataFlow/DfaFactMap", "<init>"));
        }
        this.myMap = map;
    }

    @Nullable
    public <T> T get(@NotNull DfaFactType<T> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/DfaFactMap", "get"));
        }
        return this.myMap.get(type);
    }

    @NotNull
    public <T> DfaFactMap with(@NotNull DfaFactType<T> type, @Nullable T value) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/DfaFactMap", "with"));
        }
        KeyFMap newMap = value == null ? this.myMap.minus(type) : this.myMap.plus(type, value);
        DfaFactMap dfaFactMap = newMap == this.myMap ? this : new DfaFactMap(newMap);
        if (dfaFactMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaFactMap", "with"));
        }
        return dfaFactMap;
    }

    public boolean isSuperStateOf(DfaFactMap subMap) {
        for (Key key : this.myMap.getKeys()) {
            DfaFactType type = (DfaFactType)key;
            Object other = subMap.get(type);
            if (other == null) {
                return false;
            }
            Object thisValue = this.myMap.get(type);
            Objects.requireNonNull(thisValue);
            if (type.isSuper(thisValue, other)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public <T> DfaFactMap intersect(@NotNull DfaFactType<T> type, @Nullable T value) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/DfaFactMap", "intersect"));
        }
        if (value == null) {
            return this;
        }
        T curFact = this.get(type);
        if (curFact == null) {
            return this.with(type, value);
        }
        T newFact = type.intersectFacts(curFact, value);
        return newFact == null ? null : this.with(type, newFact);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof DfaFactMap && this.myMap.equals(((DfaFactMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return StreamEx.of((Object[])this.myMap.getKeys()).map(key -> ((DfaFactType)key).toString(this.myMap.get(key))).joining((CharSequence)", ");
    }

    public static DfaFactMap calcFromVariable(@NotNull DfaVariableValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaFactMap", "calcFromVariable"));
        }
        return (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)EMPTY, (factMap, type) -> {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaFactMap", "lambda$calcFromVariable$1"));
            }
            return DfaFactMap.updateMap(factMap, type, value);
        });
    }

    private static <T> DfaFactMap updateMap(DfaFactMap map, DfaFactType<T> factType, DfaVariableValue value) {
        return map.with(factType, factType.calcFromVariable(value));
    }
}

