/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaVariableValue
extends DfaValue {
    private final PsiModifierListOwner myVariable;
    private final PsiType myVarType;
    @Nullable
    private final DfaVariableValue myQualifier;
    private DfaVariableValue myNegatedValue;
    private final boolean myIsNegated;
    private DfaFactMap myInherentFacts;
    private final DfaTypeValue myTypeValue;
    private final List<DfaVariableValue> myDependents;

    private DfaVariableValue(@NotNull PsiModifierListOwner variable, @Nullable PsiType varType, boolean isNegated, DfaValueFactory factory, @Nullable DfaVariableValue qualifier) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "<init>"));
        }
        super(factory);
        this.myDependents = new SmartList<DfaVariableValue>();
        this.myVariable = variable;
        this.myIsNegated = isNegated;
        this.myQualifier = qualifier;
        this.myVarType = varType;
        DfaValue typeValue = this.myFactory.createTypeValue(varType, Nullness.UNKNOWN);
        DfaTypeValue dfaTypeValue = this.myTypeValue = typeValue instanceof DfaTypeValue ? (DfaTypeValue)typeValue : null;
        if (varType != null && !varType.isValid()) {
            PsiUtil.ensureValidType(varType, "Variable: " + variable + " of class " + variable.getClass());
        }
    }

    @Nullable
    public DfaTypeValue getTypeValue() {
        return this.myTypeValue;
    }

    @NotNull
    public PsiModifierListOwner getPsiVariable() {
        PsiModifierListOwner psiModifierListOwner = this.myVariable;
        if (psiModifierListOwner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "getPsiVariable"));
        }
        return psiModifierListOwner;
    }

    @Nullable
    public PsiType getVariableType() {
        return this.myVarType;
    }

    public boolean isNegated() {
        return this.myIsNegated;
    }

    @Nullable
    public DfaVariableValue getNegatedValue() {
        return this.myNegatedValue;
    }

    @Override
    public DfaVariableValue createNegated() {
        if (this.myNegatedValue != null) {
            return this.myNegatedValue;
        }
        this.myNegatedValue = this.myFactory.getVarFactory().createVariableValue(this.myVariable, this.myVarType, !this.myIsNegated, this.myQualifier);
        return this.myNegatedValue;
    }

    public String toString() {
        return (this.myIsNegated ? "!" : "") + ((PsiNamedElement)((Object)this.myVariable)).getName() + (this.myQualifier == null ? "" : "|" + this.myQualifier.toString());
    }

    private boolean hardEquals(PsiModifierListOwner psiVar, PsiType varType, boolean negated, DfaVariableValue qualifier) {
        return psiVar == this.myVariable && negated == this.myIsNegated && qualifier == this.myQualifier && Comparing.equal(TypeConversionUtil.erasure(varType), TypeConversionUtil.erasure(this.myVarType));
    }

    @Nullable
    public DfaVariableValue getQualifier() {
        return this.myQualifier;
    }

    public DfaFactMap getInherentFacts() {
        if (this.myInherentFacts == null) {
            this.myInherentFacts = DfaFactMap.calcFromVariable(this);
        }
        return this.myInherentFacts;
    }

    @NotNull
    public Nullness getInherentNullability() {
        Nullness nullness = NullnessUtil.fromBoolean(this.getInherentFacts().get(DfaFactType.CAN_BE_NULL));
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "getInherentNullability"));
        }
        return nullness;
    }

    public boolean isFlushableByCalls() {
        boolean specialFinalField;
        if (this.myVariable instanceof PsiLocalVariable || this.myVariable instanceof PsiParameter) {
            return false;
        }
        boolean finalField = this.myVariable instanceof PsiVariable && this.myVariable.hasModifierProperty("final");
        boolean bl = specialFinalField = this.myVariable instanceof PsiMethod && Arrays.stream(SpecialField.values()).anyMatch(sf -> sf.isFinal() && sf.isMyAccessor(this.myVariable));
        if (finalField || specialFinalField) {
            return this.myQualifier != null && this.myQualifier.isFlushableByCalls();
        }
        return true;
    }

    public boolean containsCalls() {
        return this.myVariable instanceof PsiMethod || this.myQualifier != null && this.myQualifier.containsCalls();
    }

    public static class Factory {
        private final MultiMap<Trinity<Boolean, String, DfaVariableValue>, DfaVariableValue> myExistingVars = new MultiMap();
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        public DfaVariableValue createVariableValue(PsiVariable myVariable, boolean isNegated) {
            PsiType varType = myVariable.getType();
            if (varType instanceof PsiEllipsisType) {
                varType = new PsiArrayType(((PsiEllipsisType)varType).getComponentType());
            }
            return this.createVariableValue(myVariable, varType, isNegated, null);
        }

        @NotNull
        public DfaVariableValue createVariableValue(@NotNull PsiModifierListOwner myVariable, @Nullable PsiType varType, boolean isNegated, @Nullable DfaVariableValue qualifier) {
            if (myVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myVariable", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "createVariableValue"));
            }
            Trinity<Boolean, String, DfaVariableValue> key = Trinity.create(isNegated, ((PsiNamedElement)((Object)myVariable)).getName(), qualifier);
            for (DfaVariableValue aVar : this.myExistingVars.get(key)) {
                if (!aVar.hardEquals(myVariable, varType, isNegated, qualifier)) continue;
                DfaVariableValue dfaVariableValue = aVar;
                if (dfaVariableValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "createVariableValue"));
                }
                return dfaVariableValue;
            }
            DfaVariableValue result = new DfaVariableValue(myVariable, varType, isNegated, this.myFactory, qualifier);
            this.myExistingVars.putValue(key, result);
            while (qualifier != null) {
                qualifier.myDependents.add(result);
                qualifier = qualifier.getQualifier();
            }
            DfaVariableValue dfaVariableValue = result;
            if (dfaVariableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "createVariableValue"));
            }
            return dfaVariableValue;
        }

        @NotNull
        public List<DfaVariableValue> getAllQualifiedBy(@NotNull DfaVariableValue value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "getAllQualifiedBy"));
            }
            List list = value.myDependents;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "getAllQualifiedBy"));
            }
            return list;
        }
    }
}

