/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class Java9ModuleExportsPackageToItselfInspection
extends BaseJavaLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = PsiUtil.isModuleFile(holder.getFile()) ? new ExportedToSelfVisitor(holder) : PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/Java9ModuleExportsPackageToItselfInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static class ExportedToSelfVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public ExportedToSelfVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitPackageAccessibilityStatement(PsiPackageAccessibilityStatement statement) {
            super.visitPackageAccessibilityStatement(statement);
            PsiJavaModule javaModule = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiJavaModule.class);
            if (javaModule != null) {
                String moduleName = javaModule.getName();
                ArrayList<PsiJavaModuleReferenceElement> references = ContainerUtil.newArrayList(statement.getModuleReferences());
                for (PsiJavaModuleReferenceElement referenceElement : references) {
                    String fixText;
                    if (!moduleName.equals(referenceElement.getReferenceText())) continue;
                    String message = InspectionsBundle.message("inspection.module.exports.package.to.itself", new Object[0]);
                    if (references.size() == 1) {
                        fixText = InspectionsBundle.message("exports.to.itself.delete.statement.fix", new Object[0]);
                        this.myHolder.registerProblem((PsiElement)referenceElement, message, QuickFixFactory.getInstance().createDeleteFix(statement, fixText));
                        continue;
                    }
                    fixText = InspectionsBundle.message("exports.to.itself.delete.module.ref.fix", moduleName);
                    this.myHolder.registerProblem((PsiElement)referenceElement, message, QuickFixFactory.getInstance().createDeleteFix(referenceElement, fixText));
                }
            }
        }
    }
}

