/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.xml;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.structureView.impl.xml.DtdFileTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlFileTreeElement;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStructureViewTreeModel
extends TextEditorBasedStructureViewModel {
    private static final Class[] CLASSES = new Class[]{XmlTag.class, XmlFile.class, XmlEntityDecl.class, XmlElementDecl.class, XmlAttlistDecl.class, XmlConditionalSection.class};
    private static final Sorter[] SORTERS = new Sorter[]{Sorter.ALPHA_SORTER};

    public XmlStructureViewTreeModel(@NotNull XmlFile file, @Nullable Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/structureView/impl/xml/XmlStructureViewTreeModel", "<init>"));
        }
        super(editor, file);
    }

    @Override
    @NotNull
    public StructureViewTreeElement getRoot() {
        XmlFile myFile = this.getPsiFile();
        if (myFile.getLanguage() == DTDLanguage.INSTANCE) {
            DtdFileTreeElement dtdFileTreeElement = new DtdFileTreeElement(myFile);
            if (dtdFileTreeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/xml/XmlStructureViewTreeModel", "getRoot"));
            }
            return dtdFileTreeElement;
        }
        XmlFileTreeElement xmlFileTreeElement = new XmlFileTreeElement(myFile);
        if (xmlFileTreeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/xml/XmlStructureViewTreeModel", "getRoot"));
        }
        return xmlFileTreeElement;
    }

    @Override
    public boolean shouldEnterElement(Object element) {
        return element instanceof XmlTag && ((XmlTag)element).getSubTags().length > 0;
    }

    @Override
    protected XmlFile getPsiFile() {
        return (XmlFile)super.getPsiFile();
    }

    @Override
    @NotNull
    protected Class[] getSuitableClasses() {
        if (CLASSES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/xml/XmlStructureViewTreeModel", "getSuitableClasses"));
        }
        return CLASSES;
    }

    @Override
    public Object getCurrentEditorElement() {
        Object editorElement = super.getCurrentEditorElement();
        if (editorElement instanceof XmlTag) {
            PsiUtilCore.ensureValid((XmlTag)editorElement);
            for (StructureViewExtension extension : StructureViewFactoryEx.getInstanceEx(this.getPsiFile().getProject()).getAllExtensions(XmlTag.class)) {
                Object element = extension.getCurrentEditorElement(this.getEditor(), (PsiElement)editorElement);
                if (element == null) continue;
                return element;
            }
        }
        return editorElement;
    }

    @Override
    @NotNull
    public Sorter[] getSorters() {
        if (SORTERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/xml/XmlStructureViewTreeModel", "getSorters"));
        }
        return SORTERS;
    }
}

