/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.components.StoredPropertyBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\"\u0010\b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J%\u0010\t\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\u0004\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/components/FloatStoredProperty;", "Lcom/intellij/openapi/components/StoredPropertyBase;", "", "defaultValue", "(F)V", "getDefaultValue", "()Ljava/lang/Float;", "value", "getValue", "setValue", "equals", "", "other", "", "thisRef", "Lcom/intellij/openapi/components/BaseState;", "property", "Lkotlin/reflect/KProperty;", "(Lcom/intellij/openapi/components/BaseState;Lkotlin/reflect/KProperty;)Ljava/lang/Float;", "hashCode", "", "", "Lcom/intellij/openapi/components/StoredProperty;", "toString", "", "projectModel-api"})
final class FloatStoredProperty
extends StoredPropertyBase<Float> {
    private float value;
    private final float defaultValue;

    @Override
    @NotNull
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public void setValue(float f) {
        this.value = f;
    }

    @NotNull
    public Float getValue(@NotNull BaseState thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        this.setName(property.getName());
        return this.getValue();
    }

    public void setValue(@NotNull BaseState thisRef, @NotNull KProperty<?> property, float value) {
        Intrinsics.checkParameterIsNotNull((Object)thisRef, (String)"thisRef");
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        this.setName(property.getName());
        if (this.getValue().floatValue() != value) {
            long l = thisRef.ownModificationCount;
            thisRef.ownModificationCount = l + 1L;
            this.setValue(value);
        }
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof FloatStoredProperty && this.getValue().floatValue() == ((FloatStoredProperty)other).getValue().floatValue();
    }

    public int hashCode() {
        return ((Object)this.getValue()).hashCode();
    }

    @NotNull
    public String toString() {
        return this.getValue().floatValue() == this.getDefaultValue().floatValue() ? "" : String.valueOf(this.getValue().floatValue());
    }

    @Override
    public boolean setValue(@NotNull StoredProperty other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        float newValue = ((FloatStoredProperty)other).getValue().floatValue();
        if (newValue == this.getValue().floatValue()) {
            return false;
        }
        this.setValue(newValue);
        return true;
    }

    @Override
    @NotNull
    public Float getDefaultValue() {
        return Float.valueOf(this.defaultValue);
    }

    public FloatStoredProperty(float defaultValue) {
        this.defaultValue = defaultValue;
        this.value = this.getDefaultValue().floatValue();
    }
}

