/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DefaultFont", storages={@Storage(value="editor.xml")})
public class AppEditorFontOptions
implements PersistentStateComponent<PersistentFontPreferences> {
    private final FontPreferencesImpl myFontPreferences = new FontPreferencesImpl();

    public AppEditorFontOptions() {
        this.myFontPreferences.register(FontPreferences.DEFAULT_FONT_NAME, UISettings.restoreFontSize(FontPreferences.DEFAULT_FONT_SIZE, Float.valueOf(1.0f)));
    }

    public static AppEditorFontOptions getInstance() {
        return ServiceManager.getService(AppEditorFontOptions.class);
    }

    @Override
    @Nullable
    public PersistentFontPreferences getState() {
        return new PersistentFontPreferences(this.myFontPreferences);
    }

    @Override
    public void loadState(PersistentFontPreferences state) {
        this.myFontPreferences.clear();
        int fontSize = UISettings.restoreFontSize(state.FONT_SIZE, Float.valueOf(state.FONT_SCALE));
        this.myFontPreferences.register(state.FONT_FAMILY, fontSize);
        this.myFontPreferences.setLineSpacing(state.LINE_SPACING);
        this.myFontPreferences.setUseLigatures(state.USE_LIGATURES);
        if (state.SECONDARY_FONT_FAMILY != null) {
            this.myFontPreferences.register(state.SECONDARY_FONT_FAMILY, fontSize);
        }
        this.myFontPreferences.setChangeListener(() -> EditorFontCache.getInstance().reset());
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferencesImpl fontPreferencesImpl = this.myFontPreferences;
        if (fontPreferencesImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AppEditorFontOptions", "getFontPreferences"));
        }
        return fontPreferencesImpl;
    }

    public static class PersistentFontPreferences {
        public int FONT_SIZE = FontPreferences.DEFAULT_FONT_SIZE;
        @NotNull
        public String FONT_FAMILY = FontPreferences.DEFAULT_FONT_NAME;
        public float FONT_SCALE = 1.0f;
        public float LINE_SPACING = 1.0f;
        public boolean USE_LIGATURES = false;
        @Nullable
        public String SECONDARY_FONT_FAMILY;

        private PersistentFontPreferences() {
        }

        public PersistentFontPreferences(FontPreferences fontPreferences) {
            this.FONT_FAMILY = fontPreferences.getFontFamily();
            this.FONT_SIZE = fontPreferences.getSize(this.FONT_FAMILY);
            this.FONT_SCALE = UISettings.getDefFontScale();
            this.LINE_SPACING = fontPreferences.getLineSpacing();
            this.USE_LIGATURES = fontPreferences.useLigatures();
            List<String> fontFamilies = fontPreferences.getEffectiveFontFamilies();
            if (fontFamilies.size() > 1) {
                this.SECONDARY_FONT_FAMILY = fontFamilies.get(1);
            }
        }
    }
}

