/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementResolveResult
implements ResolveResult {
    @NotNull
    private final PsiElement myElement;
    private final boolean myValidResult;

    public PsiElementResolveResult(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiElementResolveResult", "<init>"));
        }
        this(element, true);
    }

    public PsiElementResolveResult(@NotNull PsiElement element, boolean validResult) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiElementResolveResult", "<init>"));
        }
        this.myElement = element;
        this.myValidResult = validResult;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementResolveResult", "getElement"));
        }
        return psiElement;
    }

    @Override
    public boolean isValidResult() {
        return this.myValidResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiElementResolveResult that = (PsiElementResolveResult)o;
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    @NonNls
    public String toString() {
        return "PsiElementResolveResult with " + this.myElement.getClass() + ": " + (this.myElement instanceof PsiNamedElement ? ((PsiNamedElement)this.myElement).getName() : this.myElement.getText());
    }

    @NotNull
    public static ResolveResult[] createResults(@Nullable Collection<? extends PsiElement> elements) {
        if (elements == null || elements.isEmpty()) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementResolveResult", "createResults"));
            }
            return EMPTY_ARRAY;
        }
        ResolveResult[] results = new ResolveResult[elements.size()];
        int i2 = 0;
        for (PsiElement psiElement : elements) {
            results[i2++] = new PsiElementResolveResult(psiElement);
        }
        if (results == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementResolveResult", "createResults"));
        }
        return results;
    }

    @NotNull
    public static ResolveResult[] createResults(PsiElement ... elements) {
        if (elements == null || elements.length == 0) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementResolveResult", "createResults"));
            }
            return EMPTY_ARRAY;
        }
        ResolveResult[] results = new ResolveResult[elements.length];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            results[i2] = new PsiElementResolveResult(elements[i2]);
        }
        if (results == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementResolveResult", "createResults"));
        }
        return results;
    }
}

