/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.messages.MessageBus;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoIndex
extends FileBasedIndexExtension<TodoIndexEntry, Integer> {
    @NonNls
    public static final ID<TodoIndexEntry, Integer> NAME = ID.create("TodoIndex");
    private final FileTypeRegistry myFileTypeManager;
    private final KeyDescriptor<TodoIndexEntry> myKeyDescriptor = new KeyDescriptor<TodoIndexEntry>(){

        @Override
        public int getHashCode(TodoIndexEntry value) {
            return value.hashCode();
        }

        @Override
        public boolean isEqual(TodoIndexEntry val1, TodoIndexEntry val2) {
            return val1.equals(val2);
        }

        @Override
        public void save(@NotNull DataOutput out, TodoIndexEntry value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/cache/impl/todo/TodoIndex$2", "save"));
            }
            out.writeUTF(value.pattern);
            out.writeBoolean(value.caseSensitive);
        }

        @Override
        public TodoIndexEntry read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/impl/cache/impl/todo/TodoIndex$2", "read"));
            }
            String pattern = in.readUTF();
            boolean caseSensitive = in.readBoolean();
            return new TodoIndexEntry(pattern, caseSensitive);
        }
    };
    private final DataExternalizer<Integer> myValueExternalizer = new IntInlineKeyDescriptor(){

        @Override
        protected boolean isCompactFormat() {
            return true;
        }
    };
    private final DataIndexer<TodoIndexEntry, Integer, FileContent> myIndexer = new DataIndexer<TodoIndexEntry, Integer, FileContent>(){

        @Override
        @NotNull
        public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/impl/cache/impl/todo/TodoIndex$4", "map"));
            }
            VirtualFile file = inputData.getFile();
            DataIndexer<TodoIndexEntry, Integer, FileContent> indexer = PlatformIdTableBuilding.getTodoIndexer(inputData.getFileType(), file);
            if (indexer != null) {
                Map<TodoIndexEntry, Integer> map = indexer.map(inputData);
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/todo/TodoIndex$4", "map"));
                }
                return map;
            }
            Map<TodoIndexEntry, Integer> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/todo/TodoIndex$4", "map"));
            }
            return map;
        }
    };
    private final FileBasedIndex.InputFilter myInputFilter = file -> {
        if (!file.isInLocalFileSystem()) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language lang = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            TokenSet commentTokens = parserDef != null ? parserDef.getCommentTokens() : null;
            return commentTokens != null;
        }
        return PlatformIdTableBuilding.isTodoIndexerRegistered(fileType) || fileType instanceof CustomSyntaxTableFileType;
    };

    public TodoIndex(MessageBus messageBus, FileTypeRegistry manager) {
        this.myFileTypeManager = manager;
        messageBus.connect().subscribe(IndexPatternProvider.INDEX_PATTERNS_CHANGED, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FileBasedIndex.getInstance().requestRebuild(NAME);
            }
        });
    }

    @Override
    public int getVersion() {
        int version = 9;
        FileType[] types = this.myFileTypeManager.getRegisteredFileTypes();
        Arrays.sort(types, (o1, o2) -> Comparing.compare(o1.getName(), o2.getName()));
        for (FileType fileType : types) {
            DataIndexer indexer = (DataIndexer)TodoIndexers.INSTANCE.forFileType(fileType);
            if (indexer == null) continue;
            int versionFromIndexer = indexer instanceof VersionedTodoIndexer ? ((VersionedTodoIndexer)indexer).getVersion() : 255;
            version = version * 31 + (versionFromIndexer ^ indexer.getClass().getName().hashCode());
        }
        return version;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    @NotNull
    public ID<TodoIndexEntry, Integer> getName() {
        ID<TodoIndexEntry, Integer> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/todo/TodoIndex", "getName"));
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<TodoIndexEntry, Integer, FileContent> getIndexer() {
        DataIndexer<TodoIndexEntry, Integer, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/todo/TodoIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @Override
    @NotNull
    public KeyDescriptor<TodoIndexEntry> getKeyDescriptor() {
        KeyDescriptor<TodoIndexEntry> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/todo/TodoIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    @Override
    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        DataExternalizer<Integer> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/todo/TodoIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/todo/TodoIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    @Override
    public boolean hasSnapshotMapping() {
        return true;
    }
}

