/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.FormatDecode;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MalformedFormatStringInspectionBase
extends BaseInspection {
    @NonNls
    public String additionalClasses = "";
    @NonNls
    public String additionalMethods = "";
    final List<String> classNames = new ArrayList<String>();
    final List<String> methodNames = new ArrayList<String>();

    public MalformedFormatStringInspectionBase() {
        MalformedFormatStringInspectionBase.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspectionBase.parseString(this.additionalMethods, this.methodNames);
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        MalformedFormatStringInspectionBase.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspectionBase.parseString(this.additionalMethods, this.methodNames);
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "writeSettings"));
        }
        this.additionalClasses = MalformedFormatStringInspectionBase.formatString(this.classNames);
        this.additionalMethods = MalformedFormatStringInspectionBase.formatString(this.methodNames);
        super.writeSettings(node);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("malformed.format.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Object value = infos[0];
        if (value instanceof Exception) {
            Exception exception = (Exception)value;
            String message = exception.getMessage();
            if (message != null) {
                String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.illegal", message);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "buildErrorString"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.malformed", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "buildErrorString"));
            }
            return string;
        }
        FormatDecode.Validator[] validators = (FormatDecode.Validator[])value;
        int argumentCount = (Integer)infos[1];
        if (validators.length < argumentCount) {
            String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.many.arguments", argumentCount, validators.length);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "buildErrorString"));
            }
            return string;
        }
        if (validators.length > argumentCount) {
            String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.few.arguments", argumentCount, validators.length);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "buildErrorString"));
            }
            return string;
        }
        PsiType argumentType = (PsiType)infos[2];
        FormatDecode.Validator validator = (FormatDecode.Validator)infos[3];
        String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.arguments.do.not.match.type", argumentType.getPresentableText(), validator.getSpecifier());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedFormatStringVisitor();
    }

    private class MalformedFormatStringVisitor
    extends BaseInspectionVisitor {
        private MalformedFormatStringVisitor() {
        }

        private int findFirstStringArgumentIndex(PsiExpression[] expressions) {
            int length = expressions.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiExpression expression = expressions[i2];
                if (!ExpressionUtils.hasStringType(expression)) continue;
                return i2;
            }
            return -1;
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiExpression argument;
            PsiType argumentType;
            FormatDecode.Validator[] validators;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase$MalformedFormatStringVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (!FormatUtils.isFormatCall(expression, MalformedFormatStringInspectionBase.this.methodNames, MalformedFormatStringInspectionBase.this.classNames)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            int formatArgumentIndex = this.findFirstStringArgumentIndex(arguments);
            if (formatArgumentIndex < 0) {
                return;
            }
            PsiExpression formatArgument = arguments[formatArgumentIndex];
            ++formatArgumentIndex;
            if (!ExpressionUtils.hasStringType(formatArgument) || !PsiUtil.isConstantExpression(formatArgument)) {
                return;
            }
            PsiType formatType = formatArgument.getType();
            if (formatType == null) {
                return;
            }
            String value = (String)ConstantExpressionUtil.computeCastTo(formatArgument, formatType);
            if (value == null) {
                return;
            }
            int argumentCount = arguments.length - formatArgumentIndex;
            try {
                validators = FormatDecode.decode(value, argumentCount);
            }
            catch (FormatDecode.IllegalFormatException e) {
                this.registerError((PsiElement)formatArgument, e);
                return;
            }
            if (argumentCount == 1 && (argumentType = (argument = this.resolveIfPossible(arguments[formatArgumentIndex])).getType()) instanceof PsiArrayType) {
                PsiArrayInitializerExpression arrayInitializer;
                if (argument instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)argument;
                    arrayInitializer = newExpression.getArrayInitializer();
                } else if (argument instanceof PsiArrayInitializerExpression) {
                    arrayInitializer = (PsiArrayInitializerExpression)argument;
                } else {
                    return;
                }
                if (arrayInitializer == null) {
                    return;
                }
                arguments = arrayInitializer.getInitializers();
                argumentCount = arguments.length;
                formatArgumentIndex = 0;
            }
            if (validators.length != argumentCount) {
                this.registerMethodCallError(expression, validators, argumentCount);
                return;
            }
            for (int i2 = 0; i2 < validators.length; ++i2) {
                FormatDecode.Validator validator = validators[i2];
                PsiExpression argument2 = arguments[i2 + formatArgumentIndex];
                PsiType argumentType2 = argument2.getType();
                if (argumentType2 == null || validator == null || validator.valid(argumentType2)) continue;
                this.registerError((PsiElement)argument2, validators, argumentCount, argumentType2, validator);
            }
        }

        private PsiExpression resolveIfPossible(PsiExpression expression) {
            PsiVariable variable;
            PsiExpression initializer;
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)expression).resolve()) instanceof PsiVariable && target.getContainingFile() == expression.getContainingFile() && (initializer = (variable = (PsiVariable)target).getInitializer()) != null) {
                return initializer;
            }
            return expression;
        }
    }
}

