/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.facet;

import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import org.jetbrains.jps.model.serialization.facet.FacetState;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;

public class JpsFacetSerializer {
    @NonNls
    public static final String FACET_TAG = "facet";
    @NonNls
    public static final String TYPE_ATTRIBUTE = "type";
    @NonNls
    public static final String CONFIGURATION_TAG = "configuration";
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";

    public static void loadFacets(JpsModule module, @Nullable Element facetManagerElement) {
        if (facetManagerElement == null) {
            return;
        }
        FacetManagerState state = XmlSerializer.deserialize(facetManagerElement, FacetManagerState.class);
        JpsFacetSerializer.addFacets(module, state.getFacets(), null);
    }

    public static void saveFacets(JpsModule module, @NotNull Element facetManagerElement) {
        if (facetManagerElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetManagerElement", "org/jetbrains/jps/model/serialization/facet/JpsFacetSerializer", "saveFacets"));
        }
        FacetManagerState managerState = new FacetManagerState();
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsFacetConfigurationSerializer<?> serializer2 : extension.getFacetConfigurationSerializers()) {
                if (!serializer2.hasExtension(module)) continue;
                serializer2.saveExtension(module, managerState.getFacets());
            }
        }
        XmlSerializer.serializeInto(managerState, facetManagerElement, new SkipDefaultValuesSerializationFilters());
    }

    private static void addFacets(JpsModule module, List<FacetState> facets, @Nullable JpsElement parentFacet) {
        for (FacetState facetState : facets) {
            JpsFacetConfigurationSerializer<?> serializer2 = JpsFacetSerializer.getModuleExtensionSerializer(facetState.getFacetType());
            if (serializer2 == null) continue;
            Object element = JpsFacetSerializer.addExtension(module, serializer2, facetState, parentFacet);
            JpsFacetSerializer.addFacets(module, facetState.getSubFacets(), element);
        }
    }

    private static <E extends JpsElement> E addExtension(JpsModule module, JpsFacetConfigurationSerializer<E> serializer2, FacetState facet, JpsElement parentFacet) {
        return serializer2.loadExtension(facet.getConfiguration(), facet.getName(), module, parentFacet);
    }

    @Nullable
    private static JpsFacetConfigurationSerializer<?> getModuleExtensionSerializer(@NotNull String typeId) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "org/jetbrains/jps/model/serialization/facet/JpsFacetSerializer", "getModuleExtensionSerializer"));
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsFacetConfigurationSerializer<?> serializer2 : extension.getFacetConfigurationSerializers()) {
                if (!serializer2.getFacetTypeId().equals(typeId)) continue;
                return serializer2;
            }
        }
        return null;
    }

    public static JpsModuleReference createModuleReference(String facetId) {
        String moduleName = facetId.substring(0, facetId.indexOf(47));
        return JpsElementFactory.getInstance().createModuleReference(moduleName);
    }

    public static String getFacetId(JpsModuleReference moduleReference, String facetTypeId, String facetName) {
        return moduleReference.getModuleName() + "/" + facetTypeId + "/" + facetName;
    }
}

