/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class Effects
implements Result {
    static final Set<EffectQuantum> TOP_EFFECTS = Collections.singleton(EffectQuantum.TopEffectQuantum);
    @NotNull
    final DataValue returnValue;
    @NotNull
    final Set<EffectQuantum> effects;

    Effects(@NotNull DataValue returnValue, @NotNull Set<EffectQuantum> effects) {
        if (returnValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnValue", "com/intellij/codeInspection/bytecodeAnalysis/Effects", "<init>"));
        }
        if (effects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effects", "com/intellij/codeInspection/bytecodeAnalysis/Effects", "<init>"));
        }
        this.returnValue = returnValue;
        this.effects = effects;
    }

    Stream<EKey> dependencies() {
        return Stream.concat(this.returnValue.dependencies(), this.effects.stream().flatMap(EffectQuantum::dependencies));
    }

    public boolean isTop() {
        return this.returnValue == DataValue.UnknownDataValue1 && this.effects.equals(TOP_EFFECTS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Effects that = (Effects)o;
        return this.returnValue.equals(that.returnValue) && this.effects.equals(that.effects);
    }

    public int hashCode() {
        return this.effects.hashCode() * 31 + this.returnValue.hashCode();
    }

    public String toString() {
        String effectsPresentation = this.effects.isEmpty() ? "Pure" : (this.effects.size() == 1 ? this.effects.iterator().next() : Integer.valueOf(this.effects.size()));
        return "Effects[" + effectsPresentation + "|" + this.returnValue + "]";
    }
}

