/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryInfoWithExcludePatterns
extends DirectoryInfoImpl {
    private static final Logger LOG = Logger.getInstance(DirectoryInfoWithExcludePatterns.class);
    @Nullable
    private final FileTypeAssocTable<Boolean> myContentExcludePatterns;
    @Nullable
    private final FileTypeAssocTable<Boolean> myLibraryExcludePatterns;

    public DirectoryInfoWithExcludePatterns(@NotNull VirtualFile root, Module module, VirtualFile contentRoot, VirtualFile sourceRoot, VirtualFile libraryClassRoot, boolean inModuleSource, boolean inLibrarySource, boolean isExcluded, int sourceRootTypeId, @Nullable FileTypeAssocTable<Boolean> contentExcludePatterns, @Nullable FileTypeAssocTable<Boolean> libraryExcludePatterns, @Nullable String unloadedModuleName) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "<init>"));
        }
        super(root, module, contentRoot, sourceRoot, libraryClassRoot, inModuleSource, inLibrarySource, isExcluded, sourceRootTypeId, unloadedModuleName);
        this.myContentExcludePatterns = contentExcludePatterns;
        this.myLibraryExcludePatterns = libraryExcludePatterns;
        LOG.assertTrue(this.myContentExcludePatterns != null || this.myLibraryExcludePatterns != null, "Directory info of '" + root + "' with exclude patterns have no any exclude patterns: " + this.toString());
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "isInLibrarySource"));
        }
        return this.myInLibrarySource && !this.isExcludedByPatterns(file, this.myLibraryExcludePatterns);
    }

    private boolean isExcludedByPatterns(@NotNull VirtualFile file, @Nullable FileTypeAssocTable<Boolean> patterns) {
        VirtualFile current;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "isExcludedByPatterns"));
        }
        if (patterns == null) {
            return false;
        }
        for (current = file; current != null && !this.myRoot.equals(current); current = current.getParent()) {
            if (patterns.findAssociatedFileType(current.getNameSequence()) == null) continue;
            return true;
        }
        if (current == null) {
            LOG.error("File " + file + " is not under this directory (" + this.myRoot + ")");
        }
        return false;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file) {
        VirtualFile current;
        boolean inContent;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "isExcluded"));
        }
        if (this.myExcluded) {
            return true;
        }
        if (this.myLibraryExcludePatterns == null && this.myContentExcludePatterns == null) {
            LOG.error("Directory info of '" + this.getRoot() + "' with exclude patterns have no any exclude patterns: " + this.toString());
            return false;
        }
        boolean bl = inContent = this.getContentRoot() != null;
        if (!inContent && !this.myInLibrarySource) {
            return false;
        }
        for (current = file; current != null && !this.myRoot.equals(current); current = current.getParent()) {
            boolean excludedFromLibrary;
            CharSequence name = current.getNameSequence();
            boolean excludedFromModule = this.myContentExcludePatterns != null && this.myContentExcludePatterns.findAssociatedFileType(name) != null;
            boolean bl2 = excludedFromLibrary = this.myLibraryExcludePatterns != null && this.myLibraryExcludePatterns.findAssociatedFileType(name) != null;
            if (inContent && !excludedFromModule || this.myInLibrarySource && !excludedFromLibrary) continue;
            return true;
        }
        if (current == null) {
            LOG.error("File " + file + " is not under this directory (" + this.myRoot + ")");
        }
        return false;
    }

    @Override
    public boolean isInModuleSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/DirectoryInfoWithExcludePatterns", "isInModuleSource"));
        }
        return this.myInModuleSource && !this.isExcludedByPatterns(file, this.myContentExcludePatterns);
    }
}

