/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSourceFilterScope
extends DelegatingGlobalSearchScope {
    @Nullable
    private final ProjectFileIndex myIndex;

    public JavaSourceFilterScope(@NotNull GlobalSearchScope delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/impl/search/JavaSourceFilterScope", "<init>"));
        }
        super(delegate);
        Project project = this.getProject();
        this.myIndex = project == null ? null : ProjectRootManager.getInstance(project).getFileIndex();
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/JavaSourceFilterScope", "contains"));
        }
        if (!super.contains(file)) {
            return false;
        }
        if (this.myIndex == null) {
            return false;
        }
        if (JavaClassFileType.INSTANCE == file.getFileType()) {
            return this.myIndex.isInLibraryClasses(file);
        }
        return this.myIndex.isInSourceContent(file) || this.myBaseScope.isForceSearchingInLibrarySources() && this.myIndex.isInLibrarySource(file);
    }
}

