/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniqueNameGenerator
implements Condition<String> {
    private final Set<String> myExistingNames;

    public <T> UniqueNameGenerator(@NotNull Collection<T> elements, @Nullable Function<T, String> namer) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/text/UniqueNameGenerator", "<init>"));
        }
        this.myExistingNames = new THashSet();
        for (T t : elements) {
            this.addExistingName(namer != null ? StringUtil.notNullize(namer.fun(t)) : t.toString());
        }
    }

    public UniqueNameGenerator() {
        this.myExistingNames = new THashSet();
    }

    @Override
    public final boolean value(String candidate) {
        return this.isUnique(candidate);
    }

    public final boolean isUnique(@NotNull String candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/util/text/UniqueNameGenerator", "isUnique"));
        }
        return !this.myExistingNames.contains(candidate);
    }

    public final boolean isUnique(String name, String prefix, String suffix) {
        return this.value(prefix + name + suffix);
    }

    @NotNull
    public static String generateUniqueName(String defaultName, Collection<String> existingNames) {
        String string = UniqueNameGenerator.generateUniqueName(defaultName, "", "", existingNames);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
        }
        return string;
    }

    @NotNull
    public static String generateUniqueName(String defaultName, String prefix, String suffix, final Collection<String> existingNames) {
        String string = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, new Condition<String>(){

            @Override
            public boolean value(String s) {
                return !existingNames.contains(s);
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
        }
        return string;
    }

    @NotNull
    public static String generateUniqueName(String defaultName, Condition<String> validator) {
        String string = UniqueNameGenerator.generateUniqueName(defaultName, "", "", validator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
        }
        return string;
    }

    @NotNull
    public static String generateUniqueName(String defaultName, String prefix, String suffix, Condition<String> validator) {
        String string = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, "", "", validator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
        }
        return string;
    }

    @NotNull
    public static String generateUniqueName(String defaultName, String prefix, String suffix, String beforeNumber, String afterNumber, Condition<String> validator) {
        String defaultFullName = prefix + defaultName + suffix;
        if (validator.value(defaultFullName)) {
            String string = defaultFullName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
            }
            return string;
        }
        int i2 = 2;
        while (true) {
            String fullName;
            if (validator.value(fullName = prefix + defaultName + beforeNumber + i2 + afterNumber + suffix)) {
                String string = fullName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
                }
                return string;
            }
            ++i2;
        }
    }

    @NotNull
    public String generateUniqueName(String defaultName, String prefix, String suffix) {
        String string = this.generateUniqueName(defaultName, prefix, suffix, "", "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
        }
        return string;
    }

    @NotNull
    public String generateUniqueName(String defaultName, String prefix, String suffix, String beforeNumber, String afterNumber) {
        String result = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, beforeNumber, afterNumber, this);
        this.addExistingName(result);
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
        }
        return string;
    }

    public void addExistingName(@NotNull String result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/text/UniqueNameGenerator", "addExistingName"));
        }
        this.myExistingNames.add(result);
    }

    public String generateUniqueName(String defaultName) {
        return this.generateUniqueName(defaultName, "", "");
    }
}

