/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DynamicRegexReplaceableByCompiledPatternInspectionBase
extends BaseInspection {
    @NonNls
    protected static final Collection<String> regexMethodNames = new HashSet<String>(4);

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/DynamicRegexReplaceableByCompiledPatternInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/DynamicRegexReplaceableByCompiledPatternInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DynamicRegexReplaceableByCompiledPatternVisitor();
    }

    static {
        regexMethodNames.add("matches");
        regexMethodNames.add("replace");
        regexMethodNames.add("replaceFirst");
        regexMethodNames.add("replaceAll");
        regexMethodNames.add("split");
    }

    private static class DynamicRegexReplaceableByCompiledPatternVisitor
    extends BaseInspectionVisitor {
        private DynamicRegexReplaceableByCompiledPatternVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (!DynamicRegexReplaceableByCompiledPatternVisitor.isCallToRegexMethod(expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean isCallToRegexMethod(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!regexMethodNames.contains(name)) {
                return false;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return false;
            }
            Object value = ExpressionUtils.computeConstantExpression(arguments[0]);
            if (!(value instanceof String)) {
                return false;
            }
            String regex = (String)value;
            if (PsiUtil.isLanguageLevel7OrHigher(expression) && "split".equals(name) && DynamicRegexReplaceableByCompiledPatternVisitor.isOptimizedPattern(regex) || PsiUtil.isLanguageLevel9OrHigher(expression) && "replace".equals(name)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return false;
            }
            if (Extensions.getRootArea().hasExtensionPoint(AllowedApiFilterExtension.EP_NAME.getName())) {
                return AllowedApiFilterExtension.isClassAllowed("java.util.regex.Pattern", expression);
            }
            return true;
        }

        private static boolean isOptimizedPattern(String regex) {
            char ch;
            return (regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff');
        }
    }
}

