/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class InstantiatingObjectToGetClassObjectInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instantiating.object.to.get.class.object.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instantiating.object.to.get.class.object.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InstantiatingObjectToGetClassObjectFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstantiatingObjectToGetClassObjectVisitor();
    }

    private static class InstantiatingObjectToGetClassObjectVisitor
    extends BaseInspectionVisitor {
        private InstantiatingObjectToGetClassObjectVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection$InstantiatingObjectToGetClassObjectVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getClass".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 0) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            if (newExpression.getAnonymousClass() != null) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class InstantiatingObjectToGetClassObjectFix
    extends InspectionGadgetsFix {
        private InstantiatingObjectToGetClassObjectFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("instantiating.object.to.get.class.object.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/InstantiatingObjectToGetClassObjectInspection$InstantiatingObjectToGetClassObjectFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression expression = (PsiMethodCallExpression)descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type = qualifier.getType();
            if (type == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression(expression, InstantiatingObjectToGetClassObjectFix.getTypeText(type, new StringBuilder()) + ".class");
        }

        private static StringBuilder getTypeText(PsiType type, StringBuilder text2) {
            if (type instanceof PsiArrayType) {
                text2.append("[]");
                PsiArrayType arrayType = (PsiArrayType)type;
                InstantiatingObjectToGetClassObjectFix.getTypeText(arrayType.getComponentType(), text2);
            } else if (type instanceof PsiClassType) {
                String canonicalText = type.getCanonicalText();
                String typeText = StringUtils.stripAngleBrackets(canonicalText);
                text2.insert(0, typeText);
            } else {
                text2.insert(0, type.getCanonicalText());
            }
            return text2;
        }
    }
}

