/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.style.ControlFlowStatementVisitorBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleStatementInBlockInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("single.statement.in.block.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SingleStatementInBlockInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("single.statement.in.block.descriptor", infos);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SingleStatementInBlockInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SingleStatementInBlockVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length == 1 && infos[0] instanceof String) {
            return new SingleStatementInBlockFix((String)infos[0]);
        }
        return null;
    }

    private static void doFixImpl(@NotNull PsiBlockStatement blockStatement) {
        if (blockStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockStatement", "com/siyeh/ig/style/SingleStatementInBlockInspection", "doFixImpl"));
        }
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement[] statements = codeBlock.getStatements();
        PsiStatement statement = statements[0];
        SingleStatementInBlockInspection.handleComments(blockStatement, codeBlock);
        String text2 = statement.getText();
        PsiReplacementUtil.replaceStatement(blockStatement, text2);
    }

    private static void handleComments(PsiBlockStatement blockStatement, PsiCodeBlock codeBlock) {
        PsiElement parent = blockStatement.getParent();
        assert (parent != null);
        PsiElement grandParent = parent.getParent();
        assert (grandParent != null);
        PsiElement sibling = codeBlock.getFirstChild();
        assert (sibling != null);
        for (sibling = sibling.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!(sibling instanceof PsiComment)) continue;
            grandParent.addBefore(sibling, parent);
        }
        PsiElement lastChild = blockStatement.getLastChild();
        if (lastChild instanceof PsiComment) {
            PsiElement nextSibling = parent.getNextSibling();
            grandParent.addAfter(lastChild, nextSibling);
        }
    }

    private static class SingleStatementInBlockFix
    extends InspectionGadgetsFix {
        private final String myKeywordText;

        private SingleStatementInBlockFix(String keywordText) {
            this.myKeywordText = keywordText;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("single.statement.in.block.quickfix", this.myKeywordText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SingleStatementInBlockInspection$SingleStatementInBlockFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("single.statement.in.block.family.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SingleStatementInBlockInspection$SingleStatementInBlockFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement body;
            PsiElement startElement = descriptor.getStartElement();
            PsiElement startParent = startElement.getParent();
            if (startElement instanceof PsiLoopStatement) {
                body = ((PsiLoopStatement)startElement).getBody();
            } else if (startParent instanceof PsiLoopStatement) {
                body = ((PsiLoopStatement)startParent).getBody();
            } else if (startElement instanceof PsiKeyword) {
                assert (startParent instanceof PsiIfStatement);
                PsiIfStatement ifStatement = (PsiIfStatement)startParent;
                body = ((PsiKeyword)startElement).getTokenType() == JavaTokenType.IF_KEYWORD ? ifStatement.getThenBranch() : ifStatement.getElseBranch();
            } else if (startElement instanceof PsiJavaToken && ((PsiJavaToken)startElement).getTokenType() == JavaTokenType.RBRACE) {
                assert (startParent instanceof PsiCodeBlock);
                body = startParent.getParent();
            } else {
                return;
            }
            assert (body instanceof PsiBlockStatement);
            SingleStatementInBlockInspection.doFixImpl((PsiBlockStatement)body);
        }
    }

    private static class SingleStatementInBlockVisitor
    extends ControlFlowStatementVisitorBase {
        private SingleStatementInBlockVisitor() {
        }

        @Override
        @Contract(value="null->false")
        protected boolean isApplicable(PsiStatement body) {
            PsiFile file;
            PsiStatement[] statements;
            return body instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)body).getCodeBlock().getStatements()).length == 1 && !(statements[0] instanceof PsiDeclarationStatement) && !FileTypeUtils.isInServerPageFile(file = body.getContainingFile());
        }

        @Override
        @Nullable
        protected Pair<PsiElement, PsiElement> getOmittedBodyBounds(PsiStatement body) {
            PsiStatement statement;
            PsiCodeBlock codeBlock;
            PsiStatement[] statements;
            if (body instanceof PsiBlockStatement && (statements = (codeBlock = ((PsiBlockStatement)body).getCodeBlock()).getStatements()).length == 1 && ((statement = statements[0]) instanceof PsiLoopStatement || statement instanceof PsiIfStatement)) {
                return Pair.create(codeBlock.getLBrace(), codeBlock.getRBrace());
            }
            return null;
        }
    }
}

